#include "sgoscene.h"

sgoScene::sgoScene(void)
{
}

sgoScene::~sgoScene(void)
{
}

void sgoScene::loadScene(char *filename)
{
	FileHolder fh;
	fh.openToRead(filename);

	c_nodes = fh.readWord();
	nodes = new sgoNode[c_nodes];

	for (int i = 0; i < c_nodes; i++)
	{
		nodes[i].loadNode(fh);
	}

	c_texs = fh.readWord();
	texs = new sgoTexture[c_texs];

	for (int i = 0; i < c_texs; i++)
	{
		texs[i].u_offset = fh.readFloat();
		texs[i].v_offset = fh.readFloat();
		texs[i].u_tiling = fh.readFloat();
		texs[i].v_tiling = fh.readFloat();

		BYTE filename_size = fh.readByte();
		char *filename = new char[filename_size + 1];

		fh.readBuffer((BYTE *) filename, filename_size);
		filename[filename_size] = 0;

		SetCurrentDirectory("./data/scenes/");

		texs[i].texture = new aTex2D();
		texs[i].texture ->loadFromFile(filename);

		delete [] filename;
	}

	fh.close();

	for (int i = 0; i < c_nodes; i++)
	{
		assignTextures(nodes[i]);
	}

	for (int i = 0; i < c_nodes; i++)
	{
		nodes[i].buildList();
	}
}

void sgoScene::renderScene(float time)
{
	for (int i = 0; i < c_nodes; i++) nodes[i].renderNode(time);
}

void sgoScene::assignTextures(sgoNode &node)
{
	if ((node.node_type == sgoNode::nodeType::MESH) && (short)((sgoMesh *)node.object) ->tex_index != -1)
		((sgoMesh *)node.object) ->tex = &texs[((sgoMesh *)node.object) ->tex_index];
	
	for (int i = 0; i < node.c_child_nodes; i++)
	{
		assignTextures(node.child_nodes[i]);
	}
}