#ifndef _QUAT_
#define _QUAT_

#include <windows.h>
#include <math.h>
#include "G3DVector.h"

class QUAT
{
private:
public:
	static QUAT lerp(float time, QUAT q1, QUAT q2);
	static QUAT slerp(float time, QUAT q1, QUAT q2);
	static QUAT squad(float time, QUAT q1, QUAT q2, QUAT a, QUAT b);
	static float DotProduct(QUAT q1, QUAT q2);
	static float GetAngle(QUAT q1, QUAT q2);

	void	operator ()(float x, float y, float z, float scalar);
	QUAT	operator + (QUAT source);
	QUAT	operator - (QUAT source);
	QUAT	operator * (QUAT source);
	QUAT	operator * (float source);

	QUAT		GetCoupleQuat();
	float		GetLength();
	void		Normalize();
	void		RotateToQuat(float x, float y, float z, float angle);
	void		QuatToRotate(G3DVECTOR *axis, float *angle);
	G3DVECTOR	Rotate(G3DVECTOR source);

	G3DVECTOR	vector;
	float		scalar;
};

#endif
