#pragma once

#include <windows.h>
#include "g3dvector.h"

class HERMITESPLINE
{
public:
	G3DVECTOR	*position;
	DWORD		c_keys;
	DWORD		*frames;

	HERMITESPLINE();
	~HERMITESPLINE();

	void	Release();
	void	CreateKeys(DWORD c_keys);
	void	SetKey(DWORD key, G3DVECTOR position, DWORD frame);
	void	SetKey(DWORD key, float x, float y, float z, DWORD frame);

	void	Get4Keys(DWORD frame, DWORD *k1, DWORD *k2, DWORD *k3, DWORD *k4);
	void	GetPositionOnFrame(DWORD frame, G3DVECTOR *position);

	DWORD	GetLastFrame();
};