#include "active_camera.h"

ActiveCamera::ActiveCamera(void)
{
}

ActiveCamera::~ActiveCamera(void)
{
}

void ActiveCamera::translate(float time)
{
	G3DVECTOR vec;

	cam_pos.getDataOnFrame((DWORD) time, &pos, NULL, NULL);
	cam_trg_pos.getDataOnFrame((DWORD) time, &vec, NULL, NULL);	

	LookAt(vec.x, vec.y, vec.z);
}

void ActiveCamera::loadCamera(char *filename)
{
	WORD		c_keys;
	int			time;
	G3DVECTOR	vec;

	FileHolder	fh;

	fh.openToRead(filename);

	c_keys = fh.readWord();
	cam_pos.createKeySlots(0, c_keys);
	
	for (int i = 0; i < c_keys; i++)
	{
		time = fh.readInt();
		vec.x = fh.readFloat();
		vec.y = fh.readFloat();
		vec.z = fh.readFloat();
		cam_pos.setKey(i, time, &vec, NULL, NULL);
	}

	//rolling, i tak nie dziala przy eksportowaniu
	c_keys = fh.readWord();

	c_keys = fh.readWord();
	cam_trg_pos.createKeySlots(0, c_keys);
	
	for (int i = 0; i < c_keys; i++)
	{
		time = fh.readInt();
		vec.x = fh.readFloat();
		vec.y = fh.readFloat();
		vec.z = fh.readFloat();
		cam_trg_pos.setKey(i, time, &vec, NULL, NULL);
	}

	/*FILE *file = fopen(filename, "r");

	fscanf(file, "%*s %u", &c_cam_directs);
	st_cam_direct = new ST_CAM_DIRECT[c_cam_directs];

	for (DWORD i = 0; i < c_cam_directs; i++)
	{
		fscanf(file, "%*s %u", &c_keys);
		st_cam_direct[i].hs_position.CreateKeys(c_keys);
		st_cam_direct[i].hs_look_at.CreateKeys(c_keys);

		for (DWORD j = 0; j < c_keys; j++)
		{
			fscanf(file, "%*s %u %*s %f %f %f %*s %f %f %f", &time, &position.x, &position.y, &position.z, &look_at.x, &look_at.y, &look_at.z);
			st_cam_direct[i].hs_position.SetKey(j, position, time);
			st_cam_direct[i].hs_look_at.SetKey(j, look_at, time);
		}	
	}

	fclose(file);*/
}