#include "aAnim.h"

aAnim::aAnim(void)
{
	c_keys		= 0;
	keys		= NULL;
}

aAnim::~aAnim(void)
{
	if (keys)
	{
		delete [] keys;
		keys = NULL;
	}
}

void aAnim::createKeySlots(DWORD key_index, DWORD c_keys)
{
	if (key_index > this ->c_keys) return;
	if (c_keys == 0) return;

	this ->c_keys += c_keys;

	aAnimKey	*tmp_keys = new aAnimKey[this ->c_keys];

	if (keys == NULL)
	{
		keys = tmp_keys;
		return;
	}

	for (DWORD i = 0; i < key_index; i++) tmp_keys[i] = keys[i]; //kopiowanie pierwszej czesci
	for (DWORD i = (c_keys + key_index); i < this ->c_keys; i++) tmp_keys[i] = keys[i - c_keys]; //kopiowanie drugiej czesci

	delete [] keys;
	keys = tmp_keys;
}

void aAnim::deleteKeySlots(DWORD key_index, DWORD c_keys)
{
	if ((c_keys + key_index) > this ->c_keys) return;
	if (c_keys == 0) return;

	this ->c_keys -= c_keys;

	if (this ->c_keys == 0)
	{
		delete [] keys;
		keys = 0;
		return;
	}

	aAnimKey	*tmp_keys = new aAnimKey[this ->c_keys];

	for (DWORD i = 0; i < key_index; i++) tmp_keys[i] = keys[i]; //kopiowanie pierwszej czesci
	for (DWORD i = (c_keys + key_index); i < (this ->c_keys + c_keys); i++) tmp_keys[i - c_keys] = keys[i]; //kopiowanie drugiej czesci

	delete [] keys;
	keys = tmp_keys;
}

void aAnim::setKey(DWORD key_index, DWORD frame, G3DVECTOR *pos, QUAT *rotate, G3DVECTOR *scale)
{
	keys[key_index].frame = frame;
	if (pos) keys[key_index].pos		= *pos;
	if (rotate) keys[key_index].rotate	= *rotate;
	if (scale) keys[key_index].scale	= *scale;
}

void aAnim::setKey(DWORD key_index, DWORD frame, G3DVECTOR *pos, G3DVECTOR *axis, float *angle, G3DVECTOR *scale)
{
	QUAT *quat = NULL;

	if (axis && angle)
	{
		quat = new QUAT;
		quat ->RotateToQuat(axis ->x, axis ->y, axis ->z, *angle);
	}

	setKey(key_index, frame, pos, quat, scale);

	if (quat) delete quat;
}

void aAnim::get4Keys(DWORD frame, DWORD *ret_keys)
{
	ret_keys[0] = 0xFFFFFFFF;
	ret_keys[1] = 0xFFFFFFFF;
	ret_keys[2] = 0x0;
	ret_keys[3] = 0xFFFFFFFF;

	//frame jest mniejszy niz pierszy frame
	if (frame < keys[0].frame) frame = keys[0].frame;

	//frame przekroczyl max ilosc klatek
	if (frame > keys[c_keys - 1].frame) frame = keys[c_keys - 1].frame;

	while (keys[ret_keys[2]].frame < frame) ret_keys[2]++;

	if (keys[ret_keys[2]].frame == frame) return;
	if (ret_keys[2] >= 1) ret_keys[1] = ret_keys[2] - 1; else ret_keys[1] = 0xFFFFFFFF;
	if (ret_keys[2] >= 2) ret_keys[0] = ret_keys[2] - 2; else ret_keys[0] = 0xFFFFFFFF;
	if ((ret_keys[2] + 1) <= c_keys - 1) ret_keys[3] = ret_keys[2] + 1; else ret_keys[3] = 0xFFFFFFFF;
}

void aAnim::getPositionOnFrame(float time, DWORD *ret_keys, G3DVECTOR *position)
{
	G3DVECTOR v2, v3;

	//on frame
	if (ret_keys[0] == 0xFFFFFFFF && ret_keys[1] == 0xFFFFFFFF && ret_keys[3] == 0xFFFFFFFF)
	{
		(*position) = keys[ret_keys[2]].pos;
		return;
	}

	//in
	if (ret_keys[0] != 0xFFFFFFFF && ret_keys[1] != 0xFFFFFFFF && ret_keys[3] != 0xFFFFFFFF)
	{
		v2 = keys[ret_keys[2]].pos - keys[ret_keys[0]].pos;
		v2 = v2 * 0.5f;

		v3 = keys[ret_keys[3]].pos - keys[ret_keys[1]].pos;
		v3 = v3 * 0.5f;
	}

	//start
	if (ret_keys[0] == 0xFFFFFFFF && ret_keys[1] != 0xFFFFFFFF && ret_keys[3] != 0xFFFFFFFF)
	{
		v3 = keys[ret_keys[3]].pos - keys[ret_keys[1]].pos;
		v3 = v3 * 0.5f;

		v2 =  keys[ret_keys[2]].pos - keys[ret_keys[1]].pos;
		v2 = v2 * 1.5f;
		v2 = v2 - (v3 * 0.5f);
	}

	//end
	if (ret_keys[0] != 0xFFFFFFFF && ret_keys[1] != 0xFFFFFFFF && ret_keys[3] == 0xFFFFFFFF)
	{
		v2 = keys[ret_keys[2]].pos - keys[ret_keys[0]].pos;
		v2 = v2 * 0.5f;

		v3 = keys[ret_keys[2]].pos - keys[ret_keys[1]].pos;
		v3 = v3 * 1.5f;
		v3 = v3 - (v2 * 0.5f);
	}

	//only 2 keys
	if (ret_keys[0] == 0xFFFFFFFF && ret_keys[1] != 0xFFFFFFFF && ret_keys[3] == 0xFFFFFFFF)
	{
		v2 = keys[ret_keys[2]].pos - keys[ret_keys[1]].pos;
		v3 = v2;
	}

	(*position) = keys[ret_keys[1]].pos * (2*time*time*time - 3*time*time + 1) +
			      v2 * (time*time*time - 2*time*time + time) +
				  keys[ret_keys[2]].pos * (-2*time*time*time + 3*time*time) +
				  v3 * (time*time*time - time*time);
}

/*void aAnim::getRotateOnFrame(float time, DWORD *keys, QUAT *rotate)
{
	float dot = QUAT::DotProduct(keys[keys[1]].rotate, keys[keys[2]].rotate);
	dot = 0;

	//on frame
	if (keys[0] == 0xFFFFFFFF && keys[1] == 0xFFFFFFFF && keys[3] == 0xFFFFFFFF)
	{
		(*rotate) = keys[keys[2]].rotate;
		return;
	}

	//in
	if (keys[0] != 0xFFFFFFFF && keys[1] != 0xFFFFFFFF && keys[3] != 0xFFFFFFFF)
	{
		if ((dot < -0.95) || (dot > 0.95))
			(*rotate) = QUAT::lerp(time, keys[keys[1]].rotate, keys[keys[2]].rotate);
		else
			(*rotate) = QUAT::slerp(time, keys[keys[1]].rotate, keys[keys[2]].rotate);
			//(*rotate) = QUAT::squad(time, keys[keys[1]].rotate, keys[keys[2]].rotate, keys[keys[0]].rotate, keys[keys[3]].rotate);

		return;
	}

	//start
	if (keys[0] == 0xFFFFFFFF && keys[1] != 0xFFFFFFFF && keys[3] != 0xFFFFFFFF)
	{
		if ((dot < -0.95) || (dot > 0.95))
			(*rotate) = QUAT::lerp(time, keys[keys[1]].rotate, keys[keys[2]].rotate);
		else
			(*rotate) = QUAT::slerp(time, keys[keys[1]].rotate, keys[keys[2]].rotate);

		return;
	}

	//end
	if (keys[0] != 0xFFFFFFFF && keys[1] != 0xFFFFFFFF && keys[3] == 0xFFFFFFFF)
	{
		if ((dot < -0.95) || (dot > 0.95))
			(*rotate) = QUAT::lerp(time, keys[keys[1]].rotate, keys[keys[2]].rotate);
		else
			(*rotate) = QUAT::slerp(time, keys[keys[1]].rotate, keys[keys[2]].rotate);

		return;
	}

	//only 2 keys
	if (keys[0] == 0xFFFFFFFF && keys[1] != 0xFFFFFFFF && keys[3] == 0xFFFFFFFF)
	{
		if ((dot < -0.95) || (dot > 0.95))
			(*rotate) = QUAT::lerp(time, keys[keys[1]].rotate, keys[keys[2]].rotate);
		else
			(*rotate) = QUAT::slerp(time, keys[keys[1]].rotate, keys[keys[2]].rotate);

		return;
	}
}*/

void aAnim::getRotateOnFrame(float time, DWORD *ret_keys, QUAT *quat)
{
	QUAT q2, q3;

	//on frame
	if (ret_keys[0] == 0xFFFFFFFF && ret_keys[1] == 0xFFFFFFFF && ret_keys[3] == 0xFFFFFFFF)
	{
		(*quat) = keys[ret_keys[2]].rotate;
		return;
	}

	//in
	if (ret_keys[0] != 0xFFFFFFFF && ret_keys[1] != 0xFFFFFFFF && ret_keys[3] != 0xFFFFFFFF)
	{
		q2 = keys[ret_keys[2]].rotate - keys[ret_keys[0]].rotate;
		q2 = q2 * 0.5f;

		q3 = keys[ret_keys[3]].rotate - keys[ret_keys[1]].rotate;
		q3 = q3 * 0.5f;
	}

	//start
	if (ret_keys[0] == 0xFFFFFFFF && ret_keys[1] != 0xFFFFFFFF && ret_keys[3] != 0xFFFFFFFF)
	{
		q3 = keys[ret_keys[3]].rotate - keys[ret_keys[1]].rotate;
		q3 = q3 * 0.5f;

		q2 =  keys[ret_keys[2]].rotate - keys[ret_keys[1]].rotate;
		q2 = q2 * 1.5f;
		q2 = q2 - (q3 * 0.5f);
	}

	//end
	if (ret_keys[0] != 0xFFFFFFFF && ret_keys[1] != 0xFFFFFFFF && ret_keys[3] == 0xFFFFFFFF)
	{
		q2 = keys[ret_keys[2]].rotate - keys[ret_keys[0]].rotate;
		q2 = q2 * 0.5f;

		q3 = keys[ret_keys[2]].rotate - keys[ret_keys[1]].rotate;
		q3 = q3 * 1.5f;
		q3 = q3 - (q2 * 0.5f);
	}

	//only 2 keys
	if (ret_keys[0] == 0xFFFFFFFF && ret_keys[1] != 0xFFFFFFFF && ret_keys[3] == 0xFFFFFFFF)
	{
		q2 = keys[ret_keys[2]].rotate - keys[ret_keys[1]].rotate;
		q3 = q2;
	}

	(*quat) = (keys[ret_keys[1]].rotate * (2*time*time*time - 3*time*time + 1) +
			      q2 * (time*time*time - 2*time*time + time) +
				  keys[ret_keys[2]].rotate * (-2*time*time*time + 3*time*time) +
				  q3 * (time*time*time - time*time));

	(*quat).Normalize();
}

void aAnim::getScaleOnFrame(float time, DWORD *ret_keys, G3DVECTOR *scale)
{
	G3DVECTOR s2, s3;

	//on frame
	if (ret_keys[0] == 0xFFFFFFFF && ret_keys[1] == 0xFFFFFFFF && ret_keys[3] == 0xFFFFFFFF)
	{
		(*scale) = keys[ret_keys[2]].scale;
		return;
	}

	//in
	if (ret_keys[0] != 0xFFFFFFFF && ret_keys[1] != 0xFFFFFFFF && ret_keys[3] != 0xFFFFFFFF)
	{
		s2 = keys[ret_keys[2]].scale - keys[ret_keys[0]].scale;
		s2 = s2 * 0.5f;

		s3 = keys[ret_keys[3]].scale - keys[ret_keys[1]].scale;
		s3 = s3 * 0.5f;
	}

	//start
	if (ret_keys[0] == 0xFFFFFFFF && ret_keys[1] != 0xFFFFFFFF && ret_keys[3] != 0xFFFFFFFF)
	{
		s3 = keys[ret_keys[3]].scale - keys[ret_keys[1]].scale;
		s3 = s3 * 0.5f;

		s2 =  keys[ret_keys[2]].scale - keys[ret_keys[1]].scale;
		s2 = s2 * 1.5f;
		s2 = s2 - (s3 * 0.5f);
	}

	//end
	if (ret_keys[0] != 0xFFFFFFFF && ret_keys[1] != 0xFFFFFFFF && ret_keys[3] == 0xFFFFFFFF)
	{
		s2 = keys[ret_keys[2]].scale - keys[ret_keys[0]].scale;
		s2 = s2 * 0.5f;

		s3 = keys[ret_keys[2]].scale - keys[ret_keys[1]].scale;
		s3 = s3 * 1.5f;
		s3 = s3 - (s2 * 0.5f);
	}

	//only 2 keys
	if (ret_keys[0] == 0xFFFFFFFF && ret_keys[1] != 0xFFFFFFFF && ret_keys[3] == 0xFFFFFFFF)
	{
		s2 = keys[ret_keys[2]].scale - keys[ret_keys[1]].scale;
		s3 = s2;
	}

	(*scale) = keys[ret_keys[1]].scale * (2*time*time*time - 3*time*time + 1) +
			      s2 * (time*time*time - 2*time*time + time) +
				  keys[ret_keys[2]].scale * (-2*time*time*time + 3*time*time) +
				  s3 * (time*time*time - time*time);
}

void aAnim::getDataOnFrame(DWORD frame, G3DVECTOR *pos, QUAT *rotate, G3DVECTOR *scale)
{
	DWORD ret_keys[4];
	float time;

	get4Keys(frame, ret_keys);
	if (ret_keys[1] == 0xFFFFFFFF) time = 0;
	else time = (float) (frame - keys[ret_keys[1]].frame) / (float) (keys[ret_keys[2]].frame - keys[ret_keys[1]].frame);

	if (pos) getPositionOnFrame(time, ret_keys, pos);
	if (rotate) getRotateOnFrame(time, ret_keys, rotate);
	if (scale) getScaleOnFrame(time, ret_keys, scale);
}

void aAnim::getDataOnFrame(DWORD frame, G3DVECTOR *pos, G3DVECTOR *axis, float *angle, G3DVECTOR *scale)
{
	QUAT	quat;
	getDataOnFrame(frame, pos, &quat, scale);

	if (axis && angle) quat.QuatToRotate(axis, angle);
}

void aAnim::setMatrixOnFrame(DWORD frame, BYTE mask)
{
	G3DVECTOR	pos, axis, scale;
	G3DVECTOR	*_pos, *_axis, *_scale;
	float		angle;
	float		*_angle;

	if (mask == ANIM_ALL)
	{
		_pos = &pos;
		_axis = &axis;
		_angle = &angle;
		_scale = &scale;
	}
	else
	{
		if (mask & ANIM_MOVE) _pos = &pos; else _pos = NULL;
		if (mask & ANIM_ROTATE) {_axis = &axis; _angle = &angle;} else {_axis = NULL; _angle = NULL;}
		if (mask & ANIM_SCALE) _scale = &scale; else _scale = NULL;
	}

	getDataOnFrame(frame, _pos, _axis, _angle, _scale);

	if (_pos) glTranslatef(pos.x, pos.y, pos.z);
	if (_axis) glRotatef(deg(angle), axis.x, axis.y, axis.z);
	if (_scale) glScalef(scale.x, scale.y, scale.z);
}

DWORD aAnim::getLastFrame()
{
	return keys[c_keys - 1].frame;
}

aAnimKey * aAnim::getKeyData(DWORD key)
{
	return &keys[key];
}

DWORD aAnim::getKeysAmount()
{
	return c_keys;
}