#pragma once

#include <windows.h>
#include <gl/gl.h>
#include <gl/glu.h>

#include "aTex2D.h"

class ImageAnim
{
public:
	ImageAnim(void);
	~ImageAnim(void);

	void	loadAnim(char *filename, char *extension, int c_frames, int num_of_digits);
	void	release();
	void	setFPS(int fps);
	int		getFPS();
	void	translateAnim(float ms);

	void	setFrame(int act_frame);
	int		getFrame();

	void	bindFrame();

private:
	aTex2D	*frames;
	int		c_frames;

	int		act_frame;

	int		fps;

	float	anim_length;
    float	act_ms;
};
