#include "imageanim.h"

extern void progressGo();

ImageAnim::ImageAnim(void)
{
	frames		= NULL;
	c_frames	= 0;
	act_frame	= 0;
	fps			= 30;
	act_ms		= 0;
}

ImageAnim::~ImageAnim(void)
{
	release();
}

void ImageAnim::release()
{
	if (frames != NULL)
	{
		delete [] frames;
		frames = NULL;
		c_frames = 0;
	}
}

void alignNumber(char *num, int num_of_digits)
{
	int new_num_size = num_of_digits + 1;

	char *tmp_num = new char[new_num_size];
	memset(tmp_num, '0', new_num_size);
	tmp_num[new_num_size - 1] = 0;

	memcpy(tmp_num + num_of_digits - strlen(num), num, strlen(num));

    strcpy(num, tmp_num);
	delete [] tmp_num;
}

void ImageAnim::loadAnim(char *filename, char *extension, int c_frames, int num_of_digits)
{
	this ->c_frames = c_frames;
	frames = new aTex2D[c_frames];

	anim_length = c_frames * (1000.0f / (float)fps);

	char *path = new char[strlen(filename) + num_of_digits + 1 + strlen(extension) + 1];

	char *text_num = new char[num_of_digits + 1];

	for (int i = 0; i < c_frames; i++)
	{
		itoa(i, text_num, 10);
		alignNumber(text_num, num_of_digits);
		wsprintf(path, "%s%s.%s", filename, text_num, extension);
		frames[i].loadFromFile(path);
		progressGo();
	}
}

void ImageAnim::setFPS(int fps)
{
	this ->fps = fps;

	anim_length = c_frames * (1000.0f / (float)fps);
}

int ImageAnim::getFPS()
{
	return fps;
}

void ImageAnim::translateAnim(float ms)
{
	act_ms += ms;

	if (act_ms > anim_length)
	{
		act_ms = 0;
	}

	act_frame = (act_ms * (c_frames - 1)) / anim_length;
}

void ImageAnim::setFrame(int act_frame)
{
	this ->act_frame = act_frame;
}

int ImageAnim::getFrame()
{
	return act_frame;
}

void ImageAnim::bindFrame()
{
	frames[act_frame].bindTex();
}