struct VS_OUTPUT
{
  float4 Position: POSITION;
  float3 Tex0:     TEXCOORD0;
};

sampler Sampler = sampler_state
{
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
};


float V_Alpha : ALPHA;
float V_Intens: VAR1;

float4 HPS(VS_OUTPUT In) : COLOR0
{
  float x = In.Tex0.x + (cos((In.Tex0.y+0.23) * 1720.0) * 0.11 +
                         cos((In.Tex0.y-0.45) * 2700.0) * 0.03 +
                         cos((In.Tex0.y-0.45) * 2250.0) * 0.08) * V_Intens;
  float y = In.Tex0.y;
  float4 color = tex2D(Sampler, float3(x,y,0));
  color.a = V_Alpha * color.a;
  return color;
}

float4 VPS(VS_OUTPUT In) : COLOR0
{
  float x = In.Tex0.x;
  float y = In.Tex0.y + (cos((In.Tex0.x+0.23) * 1720.0) * 0.11 +
                         cos((In.Tex0.x-0.45) * 2700.0) * 0.03 +
                         cos((In.Tex0.x-0.45) * 2250.0) * 0.08) * V_Intens;
  float4 color = tex2D(Sampler, float3(x,y,0));
  color.a = V_Alpha * color.a;
  return color;
}

technique HDistort
{
  pass Pass1
  {
    PixelShader = compile ps_2_0 HPS();
  }
}

technique VDistort
{
  pass Pass1
  {
    PixelShader = compile ps_2_0 VPS();
  }
}
