BEGIN {
	require Program;
	OpenGL::boot_OpenGL();
	Image::boot_Image();
	InkStain::boot_InkStain();
	Model::boot_Model();
	BalTrap::boot_BalTrap();
}

# global crud
my %spiral = ( size => 512, hsize => 256, make => 0 );
my %rastar = ( size => 256, make => 1 );
my %overlay = ( size => 32, make => 1 );
my $PI = 3.1415926535;

# programs
my $tiktak = [
    [ 0000, NEW, "Model", 100,	"tiktak",	{ fname => "models/tiktak.3ds", fps => 100 }, ],
    [ 0000, NEW, "Image", 110,  "testbeeld", { image => "fm.jpg", x => 0, y => 0, size => 2.66, alignv => 1, alignh => 1, alpha => 1, rot => 0, r=> 1.0, g => 1.0, b => 1.0 } ],

	[ 3000, DEL, "testbeeld" ],
	[ 3000, NEW, "Image", 105, "tik", { image => "tik.png", x => -0.6, y => 0.4, size => 1.0, alignv => 1, alignh => 1, alpha => 0, rot => 0, r=> 1.0, g => 1.0, b => 1.0 }, ],
	[ 3000, NEW, "Image", 105, "tak", { image => "tak.png", x => 0.6, y => 0.4, size => 1.0, alignv => 1, alignh => 1, alpha => 0, rot => 0, r=> 1.0, g => 1.0, b => 1.0 }, ],

	[ 4500, SET, "tik", { alpha => 1 }, ],
	
	[ 5250, SET, "tik", { alpha => 0 }, ],
	[ 5250, SET, "tak", { alpha => 1 }, ],

	[ 6000, SET, "tak", { alpha => 0 }, ],
	[ 6000, SET, "tik", { alpha => 1 }, ],

	[ 6750, SET, "tik", { alpha => 0 }, ],
	[ 6750, SET, "tak", { alpha => 1 }, ],

	[ 7500, SET, "tak", { alpha => 0 }, ],
	[ 7500, SET, "tik", { alpha => 1 }, ],

	[ 8250, SET, "tik", { alpha => 0 }, ],
	[ 8250, SET, "tak", { alpha => 1 }, ],

	[ 9000, SET, "tak", { alpha => 0 }, ],

	
	[ 27000, FLT,	"fadeout", {} , ],
];

my %sbc = ( x => [-2.40, -1.80, -1.20, -0.60, 0, 0.60, 1.20, 1.80, 2.40], y => [-2.40, -1.80, -1.20, -0.60, 0, 0.60, 1.20, 1.80, 2.40 ] );

my $schaakbord = [
	[	0, NEW, "Model", 100, "bord", { fname => "models/schaakbord.3ds", fps => 100 } ],
	[	0, NEW, "Model", 100, "menneke1", { fname => "models/menneke.3ds", fps => 100, xoff => 0, yoff => 0 }],
	[	0, NEW, "Model", 100, "menneke2", { fname => "models/menneke.3ds", fps => 100, xoff => 0, yoff => 0 }],
	[	0, NEW, "Model", 100, "menneke3", { fname => "models/menneke.3ds", fps => 100, xoff => 0, yoff => 0 }],
	[	0, NEW, "Model", 100, "menneke4", { fname => "models/menneke.3ds", fps => 100, xoff => 0, yoff => 0 }],
	[	0, NEW, "Model", 100, "menneke5", { fname => "models/menneke.3ds", fps => 100, xoff => 0, yoff => 0 }],
	[	0, NEW, "Model", 100, "menneke6", { fname => "models/menneke.3ds", fps => 100, xoff => 0, yoff => 0 }],
	[	0, NEW, "Model", 100, "menneke7", { fname => "models/menneke.3ds", fps => 100, xoff => 0, yoff => 0 }],
	[	0, NEW, "Model", 100, "menneke8", { fname => "models/menneke.3ds", fps => 100, xoff => 0, yoff => 0 }],
	
	[   0, SET, "menneke1", { xoff => $sbc{x}->[1], yoff => $sbc{y}->[8] } ],
	[   0, SET, "menneke2", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[8] } ],
	[   0, SET, "menneke3", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[8] } ],
	[   0, SET, "menneke4", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[8] } ],
	[   0, SET, "menneke5", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[8] } ],
	[   0, SET, "menneke6", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[8] } ],
	[   0, SET, "menneke7", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[8] } ],
	[   0, SET, "menneke8", { xoff => $sbc{x}->[8], yoff => $sbc{y}->[8] } ],

	[ 375, SET, "menneke1", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[8] } ],
	[ 375, SET, "menneke2", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[8] } ],
	[ 375, SET, "menneke3", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[8] } ],
	[ 375, SET, "menneke4", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[7] } ],
	[ 375, SET, "menneke5", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[7] } ],
	[ 375, SET, "menneke6", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[8] } ],
	[ 375, SET, "menneke7", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[8] } ],
	[ 375, SET, "menneke8", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[8] } ],

	[ 750, SET, "menneke1", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[8] } ],
	[ 750, SET, "menneke2", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[8] } ],
	[ 750, SET, "menneke3", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[7] } ],
	[ 750, SET, "menneke4", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[6] } ],
	[ 750, SET, "menneke5", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[6] } ],
	[ 750, SET, "menneke6", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[7] } ],
	[ 750, SET, "menneke7", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[8] } ],
	[ 750, SET, "menneke8", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[8] } ],
	
	[1125, SET, "menneke1", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[8] } ],
	[1125, SET, "menneke2", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[7] } ],
	[1125, SET, "menneke3", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[6] } ],
	[1125, SET, "menneke4", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[5] } ],
	[1125, SET, "menneke5", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[5] } ],
	[1125, SET, "menneke6", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[6] } ],
	[1125, SET, "menneke7", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[7] } ],
	[1125, SET, "menneke8", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[8] } ],

	[1500, SET, "menneke1", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[8] } ],
	[1500, SET, "menneke2", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[7] } ],
	[1500, SET, "menneke3", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[6] } ],
	[1500, SET, "menneke4", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[5] } ],
	[1500, SET, "menneke5", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[5] } ],
	[1500, SET, "menneke6", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[6] } ],
	[1500, SET, "menneke7", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[7] } ],
	[1500, SET, "menneke8", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[8] } ],

	[1875, SET, "menneke1", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[8] } ],
	[1875, SET, "menneke2", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[7] } ],
	[1875, SET, "menneke3", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[6] } ],
	[1875, SET, "menneke4", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[5] } ],
	[1875, SET, "menneke5", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[5] } ],
	[1875, SET, "menneke6", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[6] } ],
	[1875, SET, "menneke7", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[7] } ],
	[1875, SET, "menneke8", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[8] } ],

	[2250, SET, "menneke1", { xoff => $sbc{x}->[1], yoff => $sbc{y}->[8] } ],
	[2250, SET, "menneke2", { xoff => $sbc{x}->[1], yoff => $sbc{y}->[7] } ],
	[2250, SET, "menneke3", { xoff => $sbc{x}->[1], yoff => $sbc{y}->[6] } ],
	[2250, SET, "menneke4", { xoff => $sbc{x}->[1], yoff => $sbc{y}->[5] } ],
	[2250, SET, "menneke5", { xoff => $sbc{x}->[8], yoff => $sbc{y}->[5] } ],
	[2250, SET, "menneke6", { xoff => $sbc{x}->[8], yoff => $sbc{y}->[6] } ],
	[2250, SET, "menneke7", { xoff => $sbc{x}->[8], yoff => $sbc{y}->[7] } ],
	[2250, SET, "menneke8", { xoff => $sbc{x}->[8], yoff => $sbc{y}->[8] } ],


	[3000, SET, "menneke1", { xoff => $sbc{x}->[1], yoff => $sbc{y}->[7] } ],
	[3000, SET, "menneke2", { xoff => $sbc{x}->[1], yoff => $sbc{y}->[6] } ],
	[3000, SET, "menneke3", { xoff => $sbc{x}->[1], yoff => $sbc{y}->[5] } ],
	[3000, SET, "menneke4", { xoff => $sbc{x}->[1], yoff => $sbc{y}->[4] } ],
	[3000, SET, "menneke5", { xoff => $sbc{x}->[8], yoff => $sbc{y}->[4] } ],
	[3000, SET, "menneke6", { xoff => $sbc{x}->[8], yoff => $sbc{y}->[5] } ],
	[3000, SET, "menneke7", { xoff => $sbc{x}->[8], yoff => $sbc{y}->[6] } ],
	[3000, SET, "menneke8", { xoff => $sbc{x}->[8], yoff => $sbc{y}->[7] } ],

	[3187.5, SET, "menneke1", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[6] } ],
	[3187.5, SET, "menneke2", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[5] } ],
	[3187.5, SET, "menneke3", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[4] } ],
	[3187.5, SET, "menneke4", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[3] } ],
	[3187.5, SET, "menneke5", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[3] } ],
	[3187.5, SET, "menneke6", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[4] } ],
	[3187.5, SET, "menneke7", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[5] } ],
	[3187.5, SET, "menneke8", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[6] } ],

	[3375, SET, "menneke1", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[5] } ],
	[3375, SET, "menneke2", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[4] } ],
	[3375, SET, "menneke3", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[3] } ],
	[3375, SET, "menneke4", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[2] } ],
	[3375, SET, "menneke5", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[2] } ],
	[3375, SET, "menneke6", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[3] } ],
	[3375, SET, "menneke7", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[4] } ],
	[3375, SET, "menneke8", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[5] } ],

	[3562.5, SET, "menneke1", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[4] } ],
	[3562.5, SET, "menneke2", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[3] } ],
	[3562.5, SET, "menneke3", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[2] } ],
	[3562.5, SET, "menneke4", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[1] } ],
	[3562.5, SET, "menneke5", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[1] } ],
	[3562.5, SET, "menneke6", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[2] } ],
	[3562.5, SET, "menneke7", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[3] } ],
	[3562.5, SET, "menneke8", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[4] } ],


	[3750, SET, "menneke1", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[4] } ],
	[3750, SET, "menneke2", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[3] } ],
	[3750, SET, "menneke3", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[2] } ],
	[3750, SET, "menneke4", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[1] } ],
	[3750, SET, "menneke5", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[1] } ],
	[3750, SET, "menneke6", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[2] } ],
	[3750, SET, "menneke7", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[3] } ],
	[3750, SET, "menneke8", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[4] } ],

	[4125, SET, "menneke1", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[3] } ],
	[4125, SET, "menneke2", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[3] } ],
	[4125, SET, "menneke3", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[2] } ],
	[4125, SET, "menneke4", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[2] } ],
	[4125, SET, "menneke5", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[2] } ],
	[4125, SET, "menneke6", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[2] } ],
	[4125, SET, "menneke7", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[3] } ],
	[4125, SET, "menneke8", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[3] } ],

	[4500, SET, "menneke1", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[4] } ],
	[4500, SET, "menneke2", { xoff => $sbc{x}->[1], yoff => $sbc{y}->[4] } ],
	[4500, SET, "menneke3", { xoff => $sbc{x}->[1], yoff => $sbc{y}->[1] } ],
	[4500, SET, "menneke4", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[1] } ],
	[4500, SET, "menneke5", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[1] } ],
	[4500, SET, "menneke6", { xoff => $sbc{x}->[8], yoff => $sbc{y}->[1] } ],
	[4500, SET, "menneke7", { xoff => $sbc{x}->[8], yoff => $sbc{y}->[4] } ],
	[4500, SET, "menneke8", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[4] } ],

	[4875, SET, "menneke1", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[3] } ],
	[4875, SET, "menneke2", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[3] } ],
	[4875, SET, "menneke3", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[2] } ],
	[4875, SET, "menneke4", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[2] } ],
	[4875, SET, "menneke5", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[2] } ],
	[4875, SET, "menneke6", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[2] } ],
	[4875, SET, "menneke7", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[3] } ],
	[4875, SET, "menneke8", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[3] } ],


	[5250, SET, "menneke1", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[4] } ],
	[5250, SET, "menneke2", { xoff => $sbc{x}->[1], yoff => $sbc{y}->[4] } ],
	[5250, SET, "menneke3", { xoff => $sbc{x}->[1], yoff => $sbc{y}->[1] } ],
	[5250, SET, "menneke4", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[1] } ],
	[5250, SET, "menneke5", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[1] } ],
	[5250, SET, "menneke6", { xoff => $sbc{x}->[8], yoff => $sbc{y}->[1] } ],
	[5250, SET, "menneke7", { xoff => $sbc{x}->[8], yoff => $sbc{y}->[4] } ],
	[5250, SET, "menneke8", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[4] } ],

	[6000, SET, "menneke1", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[4] } ],
	[6000, SET, "menneke2", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[4] } ],
	[6000, SET, "menneke3", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[1] } ],
	[6000, SET, "menneke4", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[1] } ],
	[6000, SET, "menneke5", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[1] } ],
	[6000, SET, "menneke6", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[1] } ],
	[6000, SET, "menneke7", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[4] } ],
	[6000, SET, "menneke8", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[4] } ],

	[6375, SET, "menneke1", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[3] } ],
	[6375, SET, "menneke2", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[3] } ],
	[6375, SET, "menneke3", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[2] } ],
	[6375, SET, "menneke4", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[2] } ],
	[6375, SET, "menneke5", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[2] } ],
	[6375, SET, "menneke6", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[2] } ],
	[6375, SET, "menneke7", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[3] } ],
	[6375, SET, "menneke8", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[3] } ],

	[6750, SET, "menneke1", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[4] } ],
	[6750, SET, "menneke2", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[4] } ],
	[6750, SET, "menneke3", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[3] } ],
	[6750, SET, "menneke4", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[3] } ],
	[6750, SET, "menneke5", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[3] } ],
	[6750, SET, "menneke6", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[3] } ],
	[6750, SET, "menneke7", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[4] } ],
	[6750, SET, "menneke8", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[4] } ],

	[7125, SET, "menneke1", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[5] } ],
	[7125, SET, "menneke2", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[5] } ],
	[7125, SET, "menneke3", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[4] } ],
	[7125, SET, "menneke4", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[4] } ],
	[7125, SET, "menneke5", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[4] } ],
	[7125, SET, "menneke6", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[4] } ],
	[7125, SET, "menneke7", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[5] } ],
	[7125, SET, "menneke8", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[5] } ],

	[7500, SET, "menneke1", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[6] } ],
	[7500, SET, "menneke2", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[5] } ],
	[7500, SET, "menneke3", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[4] } ],
	[7500, SET, "menneke4", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[3] } ],
	[7500, SET, "menneke5", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[3] } ],
	[7500, SET, "menneke6", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[4] } ],
	[7500, SET, "menneke7", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[5] } ],
	[7500, SET, "menneke8", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[6] } ],

	[7875, SET, "menneke1", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[6] } ],
	[7875, SET, "menneke2", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[5] } ],
	[7875, SET, "menneke3", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[4] } ],
	[7875, SET, "menneke4", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[3] } ],
	[7875, SET, "menneke5", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[3] } ],
	[7875, SET, "menneke6", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[4] } ],
	[7875, SET, "menneke7", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[5] } ],
	[7875, SET, "menneke8", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[6] } ],

	[8250, SET, "menneke1", { xoff => $sbc{x}->[1], yoff => $sbc{y}->[6] } ],
	[8250, SET, "menneke2", { xoff => $sbc{x}->[1], yoff => $sbc{y}->[5] } ],
	[8250, SET, "menneke3", { xoff => $sbc{x}->[1], yoff => $sbc{y}->[4] } ],
	[8250, SET, "menneke4", { xoff => $sbc{x}->[1], yoff => $sbc{y}->[3] } ],
	[8250, SET, "menneke5", { xoff => $sbc{x}->[8], yoff => $sbc{y}->[3] } ],
	[8250, SET, "menneke6", { xoff => $sbc{x}->[8], yoff => $sbc{y}->[4] } ],
	[8250, SET, "menneke7", { xoff => $sbc{x}->[8], yoff => $sbc{y}->[5] } ],
	[8250, SET, "menneke8", { xoff => $sbc{x}->[8], yoff => $sbc{y}->[6] } ],

	[9000, SET, "menneke1", { xoff => $sbc{x}->[1], yoff => $sbc{y}->[7] } ],
	[9000, SET, "menneke2", { xoff => $sbc{x}->[1], yoff => $sbc{y}->[6] } ],
	[9000, SET, "menneke3", { xoff => $sbc{x}->[1], yoff => $sbc{y}->[3] } ],
	[9000, SET, "menneke4", { xoff => $sbc{x}->[1], yoff => $sbc{y}->[2] } ],
	[9000, SET, "menneke5", { xoff => $sbc{x}->[8], yoff => $sbc{y}->[2] } ],
	[9000, SET, "menneke6", { xoff => $sbc{x}->[8], yoff => $sbc{y}->[3] } ],
	[9000, SET, "menneke7", { xoff => $sbc{x}->[8], yoff => $sbc{y}->[6] } ],
	[9000, SET, "menneke8", { xoff => $sbc{x}->[8], yoff => $sbc{y}->[7] } ],

	[9167.5, SET, "menneke1", { xoff => $sbc{x}->[1], yoff => $sbc{y}->[8] } ],
	[9167.5, SET, "menneke2", { xoff => $sbc{x}->[1], yoff => $sbc{y}->[7] } ],
	[9167.5, SET, "menneke3", { xoff => $sbc{x}->[1], yoff => $sbc{y}->[2] } ],
	[9167.5, SET, "menneke4", { xoff => $sbc{x}->[1], yoff => $sbc{y}->[1] } ],
	[9167.5, SET, "menneke5", { xoff => $sbc{x}->[8], yoff => $sbc{y}->[1] } ],
	[9167.5, SET, "menneke6", { xoff => $sbc{x}->[8], yoff => $sbc{y}->[2] } ],
	[9167.5, SET, "menneke7", { xoff => $sbc{x}->[8], yoff => $sbc{y}->[7] } ],
	[9167.5, SET, "menneke8", { xoff => $sbc{x}->[8], yoff => $sbc{y}->[8] } ],

	[9375, SET, "menneke1", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[8] } ],
	[9375, SET, "menneke2", { xoff => $sbc{x}->[1], yoff => $sbc{y}->[8] } ],
	[9375, SET, "menneke3", { xoff => $sbc{x}->[1], yoff => $sbc{y}->[1] } ],
	[9375, SET, "menneke4", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[1] } ],
	[9375, SET, "menneke5", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[1] } ],
	[9375, SET, "menneke6", { xoff => $sbc{x}->[8], yoff => $sbc{y}->[1] } ],
	[9375, SET, "menneke7", { xoff => $sbc{x}->[8], yoff => $sbc{y}->[8] } ],
	[9375, SET, "menneke8", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[8] } ],

	[9542.5, SET, "menneke1", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[8] } ],
	[9542.5, SET, "menneke2", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[8] } ],
	[9542.5, SET, "menneke3", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[1] } ],
	[9542.5, SET, "menneke4", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[1] } ],
	[9542.5, SET, "menneke5", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[1] } ],
	[9542.5, SET, "menneke6", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[1] } ],
	[9542.5, SET, "menneke7", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[8] } ],
	[9542.5, SET, "menneke8", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[8] } ],

	[9750, SET, "menneke1", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[8] } ],
	[9750, SET, "menneke2", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[8] } ],
	[9750, SET, "menneke3", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[1] } ],
	[9750, SET, "menneke4", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[1] } ],
	[9750, SET, "menneke5", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[1] } ],
	[9750, SET, "menneke6", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[1] } ],
	[9750, SET, "menneke7", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[8] } ],
	[9750, SET, "menneke8", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[8] } ],

	[10125, SET, "menneke1", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[7] } ],
	[10125, SET, "menneke2", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[7] } ],
	[10125, SET, "menneke3", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[2] } ],
	[10125, SET, "menneke4", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[2] } ],
	[10125, SET, "menneke5", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[2] } ],
	[10125, SET, "menneke6", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[2] } ],
	[10125, SET, "menneke7", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[7] } ],
	[10125, SET, "menneke8", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[7] } ],

	[10500, SET, "menneke1", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[6] } ],
	[10500, SET, "menneke2", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[6] } ],
	[10500, SET, "menneke3", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[3] } ],
	[10500, SET, "menneke4", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[3] } ],
	[10500, SET, "menneke5", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[3] } ],
	[10500, SET, "menneke6", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[3] } ],
	[10500, SET, "menneke7", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[6] } ],
	[10500, SET, "menneke8", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[6] } ],

	[10875, SET, "menneke1", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[6] } ],
	[10875, SET, "menneke2", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[5] } ],
	[10875, SET, "menneke3", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[4] } ],
	[10875, SET, "menneke4", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[3] } ],
	[10875, SET, "menneke5", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[4] } ],
	[10875, SET, "menneke6", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[3] } ],
	[10875, SET, "menneke7", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[6] } ],
	[10875, SET, "menneke8", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[5] } ],

	[11250, SET, "menneke1", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[5] } ],
	[11250, SET, "menneke2", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[5] } ],
	[11250, SET, "menneke3", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[4] } ],
	[11250, SET, "menneke4", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[4] } ],
	[11250, SET, "menneke5", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[4] } ],
	[11250, SET, "menneke6", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[4] } ],
	[11250, SET, "menneke7", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[5] } ],
	[11250, SET, "menneke8", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[5] } ],




#deel2

	[12000, SET, "menneke1", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[5] } ],
	[12000, SET, "menneke2", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[6] } ],
	[12000, SET, "menneke3", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[3] } ],
	[12000, SET, "menneke4", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[4] } ],
	[12000, SET, "menneke5", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[3] } ],
	[12000, SET, "menneke6", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[4] } ],
	[12000, SET, "menneke7", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[5] } ],
	[12000, SET, "menneke8", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[6] } ],
	
	[12750, SET, "menneke1", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[5] } ],
	[12750, SET, "menneke2", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[7] } ],
	[12750, SET, "menneke3", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[2] } ],
	[12750, SET, "menneke4", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[4] } ],
	[12750, SET, "menneke5", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[2] } ],
	[12750, SET, "menneke6", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[4] } ],
	[12750, SET, "menneke7", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[5] } ],
	[12750, SET, "menneke8", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[7] } ],

#hier
	[13500, SET, "menneke1", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[4] } ],
	[13500, SET, "menneke2", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[7] } ],
	[13500, SET, "menneke3", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[2] } ],
	[13500, SET, "menneke4", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[3] } ],
	[13500, SET, "menneke5", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[2] } ],
	[13500, SET, "menneke6", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[5] } ],
	[13500, SET, "menneke7", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[6] } ],
	[13500, SET, "menneke8", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[7] } ],


	[13687.5, SET, "menneke1", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[3] } ],
	[13687.5, SET, "menneke2", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[6] } ],
	[13687.5, SET, "menneke3", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[2] } ],
	[13687.5, SET, "menneke4", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[2] } ],
	[13687.5, SET, "menneke5", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[3] } ],
	[13687.5, SET, "menneke6", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[6] } ],
	[13687.5, SET, "menneke7", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[7] } ],
	[13687.5, SET, "menneke8", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[7] } ],
						
	[13875, SET, "menneke1", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[2] } ],
	[13875, SET, "menneke2", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[5] } ],
	[13875, SET, "menneke3", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[3] } ],
	[13875, SET, "menneke4", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[2] } ],
	[13875, SET, "menneke5", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[4] } ],
	[13875, SET, "menneke6", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[7] } ],
	[13875, SET, "menneke7", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[7] } ],
	[13875, SET, "menneke8", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[6] } ],

	[14062.5, SET, "menneke1", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[2] } ],
	[14062.5, SET, "menneke2", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[4] } ],
	[14062.5, SET, "menneke3", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[4] } ],
	[14062.5, SET, "menneke4", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[2] } ],
	[14062.5, SET, "menneke5", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[5] } ],
	[14062.5, SET, "menneke6", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[7] } ],
	[14062.5, SET, "menneke7", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[7] } ],
	[14062.5, SET, "menneke8", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[5] } ],

	[14250, SET, "menneke1", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[3] } ],
	[14250, SET, "menneke2", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[4] } ],
	[14250, SET, "menneke3", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[4] } ],
	[14250, SET, "menneke4", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[3] } ],
	[14250, SET, "menneke5", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[5] } ],
	[14250, SET, "menneke6", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[6] } ],
	[14250, SET, "menneke7", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[6] } ],
	[14250, SET, "menneke8", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[5] } ],

# pam pam

	[15000, SET, "menneke1", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[4] } ],
	[15000, SET, "menneke2", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[4] } ],
	[15000, SET, "menneke3", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[4] } ],
	[15000, SET, "menneke4", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[4] } ],
	[15000, SET, "menneke5", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[5] } ],
	[15000, SET, "menneke6", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[5] } ],
	[15000, SET, "menneke7", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[5] } ],
	[15000, SET, "menneke8", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[5] } ],

	
	[15375, SET, "menneke1", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[4] } ],
	[15375, SET, "menneke2", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[4] } ],
	[15375, SET, "menneke3", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[4] } ],
	[15375, SET, "menneke4", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[4] } ],
	[15375, SET, "menneke5", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[5] } ],
	[15375, SET, "menneke6", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[5] } ],
	[15375, SET, "menneke7", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[5] } ],
	[15375, SET, "menneke8", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[5] } ],
	
	[15750, SET, "menneke1", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[3] } ],
	[15750, SET, "menneke2", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[3] } ],
	[15750, SET, "menneke3", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[5] } ],
	[15750, SET, "menneke4", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[5] } ],
	[15750, SET, "menneke5", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[6] } ],
	[15750, SET, "menneke6", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[6] } ],
	[15750, SET, "menneke7", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[4] } ],
	[15750, SET, "menneke8", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[4] } ],
	
	[16125, SET, "menneke1", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[2] } ],
	[16125, SET, "menneke2", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[2] } ],
	[16125, SET, "menneke3", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[6] } ],
	[16125, SET, "menneke4", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[6] } ],
	[16125, SET, "menneke5", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[7] } ],
	[16125, SET, "menneke6", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[7] } ],
	[16125, SET, "menneke7", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[3] } ],
	[16125, SET, "menneke8", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[3] } ],
	
	
	[16500, SET, "menneke1", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[2] } ],
	[16500, SET, "menneke2", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[2] } ],
	[16500, SET, "menneke3", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[6] } ],
	[16500, SET, "menneke4", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[6] } ],
	[16500, SET, "menneke5", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[7] } ],
	[16500, SET, "menneke6", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[7] } ],
	[16500, SET, "menneke7", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[3] } ],
	[16500, SET, "menneke8", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[3] } ],
	
	[16875, SET, "menneke1", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[2] } ],
	[16875, SET, "menneke2", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[2] } ],
	[16875, SET, "menneke3", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[6] } ],
	[16875, SET, "menneke4", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[6] } ],
	[16875, SET, "menneke5", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[7] } ],
	[16875, SET, "menneke6", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[7] } ],
	[16875, SET, "menneke7", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[3] } ],
	[16875, SET, "menneke8", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[3] } ],
	
	[17250, SET, "menneke1", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[3] } ],
	[17250, SET, "menneke2", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[3] } ],
	[17250, SET, "menneke3", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[5] } ],
	[17250, SET, "menneke4", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[5] } ],
	[17250, SET, "menneke5", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[6] } ],
	[17250, SET, "menneke6", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[6] } ],
	[17250, SET, "menneke7", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[4] } ],
	[17250, SET, "menneke8", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[4] } ],
	
	[17250, SET, "menneke1", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[3] } ],
	[17250, SET, "menneke2", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[3] } ],
	[17250, SET, "menneke3", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[5] } ],
	[17250, SET, "menneke4", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[5] } ],
	[17250, SET, "menneke5", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[6] } ],
	[17250, SET, "menneke6", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[6] } ],
	[17250, SET, "menneke7", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[4] } ],
	[17250, SET, "menneke8", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[4] } ],
	
#herhaling
	
	[18000, SET, "menneke1", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[5] } ],
	[18000, SET, "menneke2", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[6] } ],
	[18000, SET, "menneke3", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[3] } ],
	[18000, SET, "menneke4", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[4] } ],
	[18000, SET, "menneke5", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[3] } ],
	[18000, SET, "menneke6", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[4] } ],
	[18000, SET, "menneke7", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[5] } ],
	[18000, SET, "menneke8", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[6] } ],
	
	[18750, SET, "menneke1", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[5] } ],
	[18750, SET, "menneke2", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[7] } ],
	[18750, SET, "menneke3", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[2] } ],
	[18750, SET, "menneke4", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[4] } ],
	[18750, SET, "menneke5", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[2] } ],
	[18750, SET, "menneke6", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[4] } ],
	[18750, SET, "menneke7", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[5] } ],
	[18750, SET, "menneke8", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[7] } ],

#hier
	[19500, SET, "menneke1", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[4] } ],
	[19500, SET, "menneke2", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[7] } ],
	[19500, SET, "menneke3", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[2] } ],
	[19500, SET, "menneke4", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[3] } ],
	[19500, SET, "menneke5", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[2] } ],
	[19500, SET, "menneke6", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[5] } ],
	[19500, SET, "menneke7", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[6] } ],
	[19500, SET, "menneke8", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[7] } ],


	[19687.5, SET, "menneke1", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[3] } ],
	[19687.5, SET, "menneke2", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[6] } ],
	[19687.5, SET, "menneke3", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[2] } ],
	[19687.5, SET, "menneke4", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[2] } ],
	[19687.5, SET, "menneke5", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[3] } ],
	[19687.5, SET, "menneke6", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[6] } ],
	[19687.5, SET, "menneke7", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[7] } ],
	[19687.5, SET, "menneke8", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[7] } ],
						
	[19875, SET, "menneke1", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[2] } ],
	[19875, SET, "menneke2", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[5] } ],
	[19875, SET, "menneke3", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[3] } ],
	[19875, SET, "menneke4", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[2] } ],
	[19875, SET, "menneke5", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[4] } ],
	[19875, SET, "menneke6", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[7] } ],
	[19875, SET, "menneke7", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[7] } ],
	[19875, SET, "menneke8", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[6] } ],

	[20062.5, SET, "menneke1", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[2] } ],
	[20062.5, SET, "menneke2", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[4] } ],
	[20062.5, SET, "menneke3", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[4] } ],
	[20062.5, SET, "menneke4", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[2] } ],
	[20062.5, SET, "menneke5", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[5] } ],
	[20062.5, SET, "menneke6", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[7] } ],
	[20062.5, SET, "menneke7", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[7] } ],
	[20062.5, SET, "menneke8", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[5] } ],

	[20250, SET, "menneke1", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[3] } ],
	[20250, SET, "menneke2", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[4] } ],
	[20250, SET, "menneke3", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[4] } ],
	[20250, SET, "menneke4", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[3] } ],
	[20250, SET, "menneke5", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[5] } ],
	[20250, SET, "menneke6", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[6] } ],
	[20250, SET, "menneke7", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[6] } ],
	[20250, SET, "menneke8", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[5] } ],

# pam pam

	[21000, SET, "menneke1", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[4] } ],
	[21000, SET, "menneke2", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[4] } ],
	[21000, SET, "menneke3", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[4] } ],
	[21000, SET, "menneke4", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[4] } ],
	[21000, SET, "menneke5", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[5] } ],
	[21000, SET, "menneke6", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[5] } ],
	[21000, SET, "menneke7", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[5] } ],
	[21000, SET, "menneke8", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[5] } ],

	[21187.5, SET, "menneke1", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[4] } ],
	[21187.5, SET, "menneke2", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[3] } ],
	[21187.5, SET, "menneke3", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[3] } ],
	[21187.5, SET, "menneke4", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[4] } ],
	[21187.5, SET, "menneke5", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[6] } ],
	[21187.5, SET, "menneke6", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[5] } ],
	[21187.5, SET, "menneke7", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[5] } ],
	[21187.5, SET, "menneke8", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[6] } ],

	
	[21375, SET, "menneke1", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[3] } ],
	[21375, SET, "menneke2", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[2] } ],
	[21375, SET, "menneke3", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[2] } ],
	[21375, SET, "menneke4", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[3] } ],
	[21375, SET, "menneke5", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[5] } ],
	[21375, SET, "menneke6", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[4] } ],
	[21375, SET, "menneke7", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[4] } ],
	[21375, SET, "menneke8", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[5] } ],

	[21562.5, SET, "menneke1", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[2] } ],
	[21562.5, SET, "menneke2", { xoff => $sbc{x}->[1], yoff => $sbc{y}->[1] } ],
	[21562.5, SET, "menneke3", { xoff => $sbc{x}->[8], yoff => $sbc{y}->[1] } ],
	[21562.5, SET, "menneke4", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[2] } ],
	[21562.5, SET, "menneke5", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[4] } ],
	[21562.5, SET, "menneke6", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[3] } ],
	[21562.5, SET, "menneke7", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[3] } ],
	[21562.5, SET, "menneke8", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[4] } ],
	
	[21750, SET, "menneke1", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[2] } ],
	[21750, SET, "menneke2", { xoff => $sbc{x}->[1], yoff => $sbc{y}->[1] } ],
	[21750, SET, "menneke3", { xoff => $sbc{x}->[8], yoff => $sbc{y}->[1] } ],
	[21750, SET, "menneke4", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[2] } ],
	[21750, SET, "menneke5", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[2] } ],
	[21750, SET, "menneke6", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[3] } ],
	[21750, SET, "menneke7", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[3] } ],
	[21750, SET, "menneke8", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[2] } ],
	
	[22125, SET, "menneke1", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[2] } ],
	[22125, SET, "menneke2", { xoff => $sbc{x}->[1], yoff => $sbc{y}->[1] } ],
	[22125, SET, "menneke3", { xoff => $sbc{x}->[8], yoff => $sbc{y}->[1] } ],
	[22125, SET, "menneke4", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[2] } ],
	[22125, SET, "menneke5", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[2] } ],
	[22125, SET, "menneke6", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[2] } ],
	[22125, SET, "menneke7", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[2] } ],
	[22125, SET, "menneke8", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[2] } ],
	
	
	[22500, SET, "menneke1", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[2] } ],
	[22500, SET, "menneke2", { xoff => $sbc{x}->[1], yoff => $sbc{y}->[1] } ],
	[22500, SET, "menneke3", { xoff => $sbc{x}->[8], yoff => $sbc{y}->[1] } ],
	[22500, SET, "menneke4", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[2] } ],
	[22500, SET, "menneke5", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[1] } ],
	[22500, SET, "menneke6", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[2] } ],
	[22500, SET, "menneke7", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[2] } ],
	[22500, SET, "menneke8", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[1] } ],
	
	[22875, SET, "menneke1", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[1] } ],
	[22875, SET, "menneke2", { xoff => $sbc{x}->[1], yoff => $sbc{y}->[2] } ],
	[22875, SET, "menneke3", { xoff => $sbc{x}->[8], yoff => $sbc{y}->[2] } ],
	[22875, SET, "menneke4", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[1] } ],
	[22875, SET, "menneke5", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[2] } ],
	[22875, SET, "menneke6", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[1] } ],
	[22875, SET, "menneke7", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[1] } ],
	[22875, SET, "menneke8", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[2] } ],
	
	[23250, SET, "menneke1", { xoff => $sbc{x}->[2], yoff => $sbc{y}->[3] } ],
	[23250, SET, "menneke2", { xoff => $sbc{x}->[1], yoff => $sbc{y}->[4] } ],
	[23250, SET, "menneke3", { xoff => $sbc{x}->[8], yoff => $sbc{y}->[4] } ],
	[23250, SET, "menneke4", { xoff => $sbc{x}->[7], yoff => $sbc{y}->[3] } ],
	[23250, SET, "menneke5", { xoff => $sbc{x}->[4], yoff => $sbc{y}->[1] } ],
	[23250, SET, "menneke6", { xoff => $sbc{x}->[3], yoff => $sbc{y}->[2] } ],
	[23250, SET, "menneke7", { xoff => $sbc{x}->[6], yoff => $sbc{y}->[2] } ],
	[23250, SET, "menneke8", { xoff => $sbc{x}->[5], yoff => $sbc{y}->[1] } ],
	

	[ 24000, DEL, "bord" ],

];

my $beker_init = [
	[	0, NEW, "Model", 100, "beker", { fname => "models/beker.3ds", fps => 100 } ],
	[  0, NEW, "Image", 101, "katteke1", { image => "kat1.png", wsize => -0.8, hsize => 0.8,
										   x => 0.0, y => 0.1,
										   alignv => 1, alignh => 1, rot => 0, alpha => 1,
										   r => 1.0, g => 1.0, b => 1.0 } ],
	[  0, NEW, "Image", 101, "katteke2", { image => "kat2.png", wsize => -0.8, hsize => 0.8,
										   x => 0.0, y => 0.1,
										   alignv => 1, alignh => 1, rot => 0, alpha => 0,
										   r => 1.0, g => 1.0, b => 1.0 } ],
	[  0, NEW, "Image", 101, "katteke3", { image => "kat3.png", wsize => -0.8, hsize => 0.8,
										   x => 0.0, y => 0.1,
										   alignv => 1, alignh => 1, rot => 0, alpha => 0,
										   r => 1.0, g => 1.0, b => 1.0 } ],
	   # 4 == 1
	[  0, NEW, "Image", 101, "katteke5", { image => "kat5.png", wsize => -0.8, hsize => 0.8,
										   x => 0.0, y => 0.1,
										   alignv => 1, alignh => 1, rot => 0, alpha => 0,
										   r => 1.0, g => 1.0, b => 1.0 } ],
	[  0, NEW, "Image", 101, "katteke6", { image => "kat6.png", wsize => -0.8, hsize => 0.8,
										   x => 0.0, y => 0.1,
										   alignv => 1, alignh => 1, rot => 0, alpha => 0,
										   r => 1.0, g => 1.0, b => 1.0 } ],
];
my $katteloopje = [
	[ 250, SET, "katteke1", { alpha => 0 } ], [ 250, SET, "katteke2", { alpha => 1 } ],
	[ 500, SET, "katteke2", { alpha => 0 } ], [ 500, SET, "katteke3", { alpha => 1 } ],
	[ 750, SET, "katteke3", { alpha => 0 } ], [ 750, SET, "katteke1", { alpha => 1 } ],
	[1000, SET, "katteke1", { alpha => 0 } ], [1000, SET, "katteke5", { alpha => 1 } ],
	[1250, SET, "katteke5", { alpha => 0 } ], [1250, SET, "katteke6", { alpha => 1 } ],
	[1500, SET, "katteke6", { alpha => 0 } ], [1500, SET, "katteke1", { alpha => 1 } ],
];
my $beker_deinit = [
	[ 27000, DEL, "beker" ],
	[ 27000, DEL, "katteke1" ],
	[ 27000, DEL, "katteke2" ],
	[ 27000, DEL, "katteke3" ],
	[ 27000, DEL, "katteke5" ],
	[ 27000, DEL, "katteke6" ],
];
my $beker;
foreach (@{$beker_init}) { push(@{$beker}, $_); }
for (my $loopje=0; $loopje < 27000; $loopje += 1500) {
	foreach (@{$katteloopje}) {
		my @a = @{$_};
		$a[0] += $loopje;
		push(@{$beker}, \@a);
	}
}
foreach (@{$beker_deinit}) { push(@{$beker}, $_); }

my $struisvogel = [
	[	0, NEW, "Model", 100, "struisvogel", { fname => "models/struisvogel.3ds", fps => 100} ],
	[ 36000, DEL, "struisvogel" ]
];

my $steps = [
	{ x => 0.8, y => 0.38 },
	{ x => 0.4, y => 0.19 },
	{ x => 0.0, y => 0.0 },
	{ x => -0.4, y => -0.19 },
	{ x => -0.8, y => -0.38 }
];

my $baltrap = [
    [    0, NEW, "Image", 101, "object", { image => "jil.png",
										   x => 0.0, y => 0.0, size => 1.6, alignv => 1, alignh => 1,
										   alpha => 0, rot => 0, r => 1.0, g => 1.0, b => 1.0 } ],
    [    0, NEW, "BalTrap", 102, "baltrap1", { bal => "balleke.png",
											   x => $steps->[0]{x}, y => $steps->[0]{y}, turn => 0.0,
											   zoom => 1.0, trap_alpha => 1.0 } ],

    [  375, FLT, "baltrap1", { x => $steps->[1]{x} }, FLTINOUT ],
    [  750, FLT, "baltrap1", { y => $steps->[1]{y} }, FLTINOUT ],
    [ 1125, FLT, "baltrap1", { x => $steps->[2]{x} }, FLTINOUT ],
    [ 1500, FLT, "baltrap1", { y => $steps->[2]{y} }, FLTINOUT ],
    [ 1875, FLT, "baltrap1", { turn => 180.0 } ],
    [ 1875, SET, "baltrap1", { } ],
    [ 3000, FLT, "baltrap1", { turn => 180.0 } ],
    [ 3375, FLT, "baltrap1", { x => $steps->[3]{x} }, FLTINOUT ],
    [ 3750, FLT, "baltrap1", { y => $steps->[3]{y} }, FLTINOUT ],
    [ 4150, FLT, "baltrap1", { x => $steps->[4]{x} }, FLTINOUT ],
    [ 4500, FLT, "baltrap1", { y => $steps->[4]{y} }, FLTINOUT ],
    [ 4875, FLT, "baltrap1", { turn => 0.0 } ],
    [ 4875, SET, "baltrap1", { } ],
    [ 6000, FLT, "baltrap1", { turn => 0.0 } ],

#bottom
	[ 6000, SET, "baltrap1", { y => $steps->[3]{y}, x => $steps -> [3]{x} }, FLTINOUT ],
    [ 6375, SET, "baltrap1", { y => $steps->[2]{y}, x => $steps -> [2]{x} }, FLTINOUT ],
    [ 6750, SET, "baltrap1", { y => $steps->[1]{y}, x => $steps -> [1]{x} }, FLTINOUT ],
    [ 7125, SET, "baltrap1", { y => $steps->[0]{y}, x => $steps -> [0]{x} }, FLTINOUT ],
    [ 7500, SET, "baltrap1", { turn => 0.0 } ],
	[ 7875, FLT, "baltrap1", { turn => 180.0 }  ],
	[ 9000, SET, "baltrap1", { y => $steps->[1]{y}, x => $steps -> [1]{x} }, FLTINOUT ],
    [ 9375, SET, "baltrap1", { y => $steps->[2]{y}, x => $steps -> [2]{x} }, FLTINOUT ],
    [ 9750, SET, "baltrap1", { y => $steps->[3]{y}, x => $steps -> [3]{x} }, FLTINOUT ],
    [10125, SET, "baltrap1", { y => $steps->[4]{y}, x => $steps -> [4]{x} }, FLTINOUT ],
    [10875, FLT, "baltrap1", { turn => 0.0 } ],
	[12000, SET, "baltrap1", { turn => 0.0 } ],

#bottom 
	[12375, FLT, "baltrap1", { y => $steps->[0]{y}+0.3 }, FLTINOUT ],
    [12750, FLT, "baltrap1", { x => $steps->[3]{x}, y => $steps->[3]{y} }, FLTINOUT ],
    [13125, FLT, "baltrap1", { y => $steps->[0]{y}+0.35 }, FLTINOUT ],
    [13500, FLT, "baltrap1", { x => $steps->[2]{x}, y => $steps->[2]{y} }, FLTINOUT ],
    [13875, FLT, "baltrap1", { turn => 180.0 }  ],
    [15000, FLT, "baltrap1", { turn => 180.0 }  ],
	[15375, FLT, "baltrap1", { y => $steps->[0]{y}+0.4 }, FLTINOUT ],
	[15750, FLT, "baltrap1", { x => $steps->[1]{x}, y => $steps->[1]{y} }, FLTINOUT ],
    [16125, FLT, "baltrap1", { y => $steps->[0]{y}+0.45 }, FLTINOUT ],
    [16500, FLT, "baltrap1", { x => $steps->[0]{x}, y => $steps->[0]{y} }, FLTINOUT ],	
	[16875, FLT, "baltrap1", { turn => 0.0 }  ],
#top	
	[18000, SET, "baltrap1", { y => $steps->[1]{y}, x => $steps -> [1]{x} }, FLTINOUT ],
    [18375, SET, "baltrap1", { y => $steps->[2]{y}, x => $steps -> [2]{x} }, FLTINOUT ],
    [18750, SET, "baltrap1", { y => $steps->[3]{y}, x => $steps -> [3]{x} }, FLTINOUT ],
    [19125, SET, "baltrap1", { y => $steps->[4]{y}, x => $steps -> [4]{x} }, FLTINOUT ],
    [19500, FLT, "baltrap1", { turn => 0.0 } ],
	[19875, FLT, "baltrap1", { turn => 180.0 } ],
	
	[21000, SET, "baltrap1", { y => $steps->[3]{y}, x => $steps -> [3]{x} }, FLTINOUT ],
    [21375, SET, "baltrap1", { y => $steps->[2]{y}, x => $steps -> [2]{x} }, FLTINOUT ],
    [21750, SET, "baltrap1", { y => $steps->[1]{y}, x => $steps -> [1]{x} }, FLTINOUT ],
    [22125, SET, "baltrap1", { y => $steps->[0]{y}, x => $steps -> [0]{x} }, FLTINOUT ],
  
	
	[22500, FLT, "baltrap1", { x => 0.0, y => 0.0 } ],
    [22750, FLT, "baltrap1", { zoom => 8.0, trap_alpha => 0.0 } ],
    [23000, SET, "object", { alpha => 0 } ],
    [23200, FLT, "object", { alpha => 1 } ],
	[23400, FLT, "baltrap1", { turn => 90.0 } ],
	[23600, DEL, "baltrap1" ],
    [23700, FLT, "object", { size => 2.0 } ],
    [24000, FLT, "object", { } ],
];

my @spx = ( -1, -1/3, 1/3 );	# schuifpuzzel x's
my @spy = ( 1, 1/3, -1/3 );		# schuifpuzzel y's
# starts @ 2min (120)
my $schuifpuzzel = [
	[   0, NEW, "Image", 100, "background", { image => "schaap.png",
											  x => 0, y => 0, size => 2.0, alignv => 1, alignh => 1,
											  alpha => 1, rot => 0, r => 1.0, g => 1.0, b => 1.0 } ],
    [   0, NEW, "Image", 104, "rasTAr", { image => "rastar", imagedata => \$rastar{data},
										  width => $rastar{size}, height => $rastar{size},
										  x => 0, y => 0, size => 2.0, alignv => 1, alignh => 1,
										  alpha => 0.7, rot => 0, r => 1.0, g => 1.0, b => 1.0 } ],
	# puzzelstukjes
    [   0, NEW, "Image", 103, "overlay1", { image => "linksboven", imagedata => \$overlay{data},
											width => $overlay{size}, height => $overlay{size},
											x => $spx[0], y => $spy[0], size => 2/3, alignv => 0, alignh => 0,
											alpha => 1, rot => 0, r => 0.125, g => 0.25, b => 0.78125 } ],
    [   0, NEW, "Image", 103, "overlay2", { image => "middenboven", imagedata => \$overlay{data},
											width => $overlay{size}, height => $overlay{size},
											x => $spx[1], y => $spy[0], size => 2/3, alignv => 0, alignh => 0,
											alpha => 1, rot => 0, r => 0.125, g => 0.25, b => 0.78125 } ],
    [   0, NEW, "Image", 103, "overlay3", { image => "rechtsboven", imagedata => \$overlay{data},
											width => $overlay{size}, height => $overlay{size},
											x => $spx[2], y => $spy[0], size => 2/3, alignv => 0, alignh => 0,
											alpha => 1, rot => 0, r => 0.125, g => 0.25, b => 0.78125 } ],

    [   0, NEW, "Image", 103, "overlay4", { image => "linksmidden", imagedata => \$overlay{data},
											width => $overlay{size}, height => $overlay{size},
											x => $spx[0], y => $spy[1], size => 2/3, alignv => 0, alignh => 0,
											alpha => 1, rot => 0, r => 0.125, g => 0.25, b => 0.78125 } ],
    [   0, NEW, "Image", 103, "overlay5", { image => "middenmidden", imagedata => \$overlay{data},
											width => $overlay{size}, height => $overlay{size},
											x => $spx[1], y => $spy[1], size => 2/3, alignv => 0, alignh => 0,
											alpha => 1, rot => 0, r => 0.125, g => 0.25, b => 0.78125 } ],
    [   0, NEW, "Image", 103, "overlay6", { image => "rechtsmidden", imagedata => \$overlay{data},
											width => $overlay{size}, height => $overlay{size},
											x => $spx[2], y => $spy[1], size => 2/3, alignv => 0, alignh => 0,
											alpha => 1, rot => 0, r => 0.125, g => 0.25, b => 0.78125 } ],

    [   0, NEW, "Image", 103, "overlay7", { image => "linksonder", imagedata => \$overlay{data},
											width => $overlay{size}, height => $overlay{size},
											x => $spx[0], y => $spy[2], size => 2/3, alignv => 0, alignh => 0,
											alpha => 1, rot => 0, r => 0.125, g => 0.25, b => 0.78125 } ],

    [   0, NEW, "Image", 103, "overlay8", { image => "rechtsmidden", imagedata => \$overlay{data},
											width => $overlay{size}, height => $overlay{size},
											x => $spx[2], y => $spy[2], size => 0, alignv => 0, alignh => 0,
											alpha => 1, rot => 0, r => 0.125, g => 0.25, b => 0.78125 } ], # starts invisible

    [   0, NEW, "Image", 103, "overlay9", { image => "rechtsonder", imagedata => \$overlay{data},
											width => $overlay{size}, height => $overlay{size},
											x => $spx[2], y => $spy[2], size => 2/3, alignv => 0, alignh => 0,
											alpha => 1, rot => 0, r => 0.125, g => 0.25, b => 0.78125 } ],

# SCHUIF
	# middenmidden naar middenonder [5]
    [ 500, FLT, "overlay5", { y => $spy[2] } ],
    [ 750, SET, "overlay1", { } ], [ 750, SET, "overlay2", { } ],
    [ 750, SET, "overlay3", { } ], [ 750, SET, "overlay4", { } ],
    [ 750, SET, "overlay5", { } ], [ 750, SET, "overlay6", { } ],
    [ 750, SET, "overlay7", { } ], [ 750, SET, "overlay9", { } ],

	# middenrechts naar middenmidden [6]
    [ 1000, FLT, "overlay6", { x => $spx[1] } ],
    [ 1250, SET, "overlay1", { } ], [ 1250, SET, "overlay2", { } ],
    [ 1250, SET, "overlay3", { } ], [ 1250, SET, "overlay4", { } ],
    [ 1250, SET, "overlay5", { } ], [ 1250, SET, "overlay6", { } ],
    [ 1250, SET, "overlay7", { } ], [ 1250, SET, "overlay9", { } ],

	# rechtsboven naar rechtsmidden [3]
    [ 1500, FLT, "overlay3", { y => $spy[1] } ],
    [ 1500, SET, "overlay1", { } ], [ 1500, SET, "overlay2", { } ],
    [ 1500, SET, "overlay3", { } ], [ 1500, SET, "overlay4", { } ],
    [ 1500, SET, "overlay5", { } ], [ 1500, SET, "overlay6", { } ],
    [ 1500, SET, "overlay7", { } ], [ 1500, SET, "overlay9", { } ],

	# linksboven en middenboven naar rechtsmidden en rechtsboven [1] en [2]
    [ 1625, FLT, "overlay2", { x => $spx[2] } ],
    [ 1750, FLT, "overlay1", { x => $spx[1] } ],
    [ 1750, SET, "overlay1", { } ], [ 1750, SET, "overlay2", { } ],
    [ 1750, SET, "overlay3", { } ], [ 1750, SET, "overlay4", { } ],
    [ 1750, SET, "overlay5", { } ], [ 1750, SET, "overlay6", { } ],
    [ 1750, SET, "overlay7", { } ], [ 1750, SET, "overlay9", { } ],

	# linksmidden naar linksboven [4]
    [ 2250, FLT, "overlay4", { y => $spy[0] } ],
    [ 3000, SET, "overlay1", { } ], [ 3000, SET, "overlay2", { } ],
    [ 3000, SET, "overlay3", { } ], [ 3000, SET, "overlay4", { } ],
    [ 3000, SET, "overlay5", { } ], [ 3000, SET, "overlay6", { } ],
    [ 3000, SET, "overlay7", { } ], [ 3000, SET, "overlay9", { } ],

# JUMP
	# rechtsonder naar linksmidden [8]
    [ 3500, SET, "overlay9", { x => $spx[0], y => $spy[1] } ],
    [ 3500, SET, "overlay1", { } ], [ 3500, SET, "overlay2", { } ],
    [ 3500, SET, "overlay3", { } ], [ 3500, SET, "overlay4", { } ],
    [ 3500, SET, "overlay5", { } ], [ 3500, SET, "overlay6", { } ],
    [ 3500, SET, "overlay7", { } ], [ 3500, SET, "overlay9", { } ],

	# linksonder naar rechtsonder [7]
    [ 3750, SET, "overlay7", { x => $spx[2], y => $spy[2] } ],
    [ 3750, SET, "overlay1", { } ], [ 3750, SET, "overlay2", { } ],
    [ 3750, SET, "overlay3", { } ], [ 3750, SET, "overlay4", { } ],
    [ 3750, SET, "overlay5", { } ], [ 3750, SET, "overlay6", { } ],
    [ 3750, SET, "overlay7", { } ], [ 3750, SET, "overlay9", { } ],

	# rechtsmidden naar linksonder [3]
    [ 4250, SET, "overlay3", { x => $spx[0], y => $spy[2] } ],
    [ 4250, SET, "overlay1", { } ], [ 4250, SET, "overlay2", { } ],
    [ 4250, SET, "overlay3", { } ], [ 4250, SET, "overlay4", { } ],
    [ 4250, SET, "overlay5", { } ], [ 4250, SET, "overlay6", { } ],
    [ 4250, SET, "overlay7", { } ], [ 4250, SET, "overlay9", { } ],

	# middenboven naar rechtsmidden [1]
    [ 4500, SET, "overlay1", { x => $spx[2], y => $spy[1] } ],
    [ 4500, SET, "overlay1", { } ], [ 4500, SET, "overlay2", { } ],
    [ 4500, SET, "overlay3", { } ], [ 4500, SET, "overlay4", { } ],
    [ 4500, SET, "overlay5", { } ], [ 4500, SET, "overlay6", { } ],
    [ 4500, SET, "overlay7", { } ], [ 4500, SET, "overlay9", { } ],

	# middenmidden naar 0 [6]
    [ 4625, FLT, "overlay6", { size => 0.0 } ],
    [ 4625, SET, "overlay1", { } ], [ 4625, SET, "overlay2", { } ],
    [ 4625, SET, "overlay3", { } ], [ 4625, SET, "overlay4", { } ],
    [ 4625, SET, "overlay5", { } ], [ 4625, SET, "overlay6", { } ],
    [ 4625, SET, "overlay7", { } ], [ 4625, SET, "overlay9", { } ],

	# middenonder naar 0 [5]
    [ 4750, FLT, "overlay5", { size => 0.0 } ],
    [ 4750, SET, "overlay1", { } ], [ 4750, SET, "overlay2", { } ],
    [ 4750, SET, "overlay3", { } ], [ 4750, SET, "overlay4", { } ],
    [ 4750, SET, "overlay5", { } ], [ 4750, SET, "overlay6", { } ],
    [ 4750, SET, "overlay7", { } ], [ 4750, SET, "overlay9", { } ],

	# middenmidden naar 100% [6]
    [ 5250, FLT, "overlay6", { size => 2/3 } ],
    [ 5250, SET, "overlay1", { } ], [ 5250, SET, "overlay2", { } ],
    [ 5250, SET, "overlay3", { } ], [ 5250, SET, "overlay4", { } ],
    [ 5250, SET, "overlay5", { } ], [ 5250, SET, "overlay6", { } ],
    [ 5250, SET, "overlay7", { } ], [ 5250, SET, "overlay9", { } ],

# RESET TO DEFAULT LOCATIONS and sizes
    [ 6000, SET, "overlay1", { x => $spx[0], y => $spy[0], size => 2/3 } ],
	[ 6000, SET, "overlay2", { x => $spx[1], y => $spy[0], size => 2/3 } ],
	[ 6000, SET, "overlay3", { x => $spx[2], y => $spy[0], size => 2/3 } ],
    [ 6000, SET, "overlay4", { x => $spx[0], y => $spy[1], size => 2/3 } ],
	[ 6000, SET, "overlay5", { x => $spx[1], y => $spy[1], size => 2/3 } ],
	[ 6000, SET, "overlay6", { x => $spx[2], y => $spy[1], size => 2/3 } ],
    [ 6000, SET, "overlay7", { x => $spx[0], y => $spy[2], size => 2/3 } ],
	[ 6000, SET, "overlay8", { x => $spx[1], y => $spy[2], size => 2/3 } ],
	[ 6000, SET, "overlay9", { x => $spx[2], y => $spy[2], size => 2/3 } ],

#BALKEN
	#linker lijn naar 0
    [ 6000, SET, "overlay1", { size => 0 } ],
    [ 6000, SET, "overlay4", { size => 0 } ],
    [ 6000, SET, "overlay7", { size => 0 } ],

	#rechter lijn naar 0
    [ 6500, SET, "overlay1", { size => 2/3 } ],
    [ 6500, SET, "overlay4", { size => 2/3 } ],
    [ 6500, SET, "overlay7", { size => 2/3 } ],
    [ 6500, SET, "overlay3", { size => 0 } ],
    [ 6500, SET, "overlay6", { size => 0 } ],
    [ 6500, SET, "overlay9", { size => 0 } ],

	# boven lijn naar 0, 3 is al 0
    [ 6750, SET, "overlay6", { size => 2/3 } ],
    [ 6750, SET, "overlay9", { size => 2/3 } ],
    [ 6750, SET, "overlay1", { size => 0 } ],
    [ 6750, SET, "overlay2", { size => 0 } ],

	#midden x lijn _ook_ naar 0
    [ 7250, SET, "overlay4", { size => 0 } ],
    [ 7250, SET, "overlay5", { size => 0 } ],
    [ 7250, SET, "overlay6", { size => 0 } ],

	#bovenlijn naar 100%
    [ 7500, SET, "overlay1", { size => 2/3 } ],
    [ 7500, SET, "overlay2", { size => 2/3 } ],
    [ 7500, SET, "overlay3", { size => 2/3 } ],

	#linker lijn naar 0
    [ 8000, SET, "overlay1", { size => 0 } ],
    [ 8000, SET, "overlay4", { size => 0 } ],
    [ 8000, SET, "overlay7", { size => 0 } ],
    [ 8000, SET, "overlay2", { size => 2/3 } ],
    [ 8000, SET, "overlay5", { size => 2/3 } ],
    [ 8000, SET, "overlay6", { size => 2/3 } ],

	#midden y lijn naar 0
    [ 8250, SET, "overlay2", { size => 0 } ],
    [ 8250, SET, "overlay5", { size => 0 } ],
    [ 8250, SET, "overlay8", { size => 0 } ],

	#linker lijn naar 100, middenlijn naar 100, rechter lijn naar 0
    [ 8750, SET, "overlay1", { size => 2/3 } ],
    [ 8750, SET, "overlay4", { size => 2/3 } ],
    [ 8750, SET, "overlay7", { size => 2/3 } ],
    [ 8750, SET, "overlay2", { size => 2/3 } ],
    [ 8750, SET, "overlay5", { size => 2/3 } ],
    [ 8750, SET, "overlay8", { size => 2/3 } ],
    [ 8750, SET, "overlay3", { size => 0 } ],
    [ 8750, SET, "overlay6", { size => 0 } ],
    [ 8750, SET, "overlay9", { size => 0 } ],

	#midden y lijn naar 0
    [ 9000, SET, "overlay2", { size => 0 } ],
    [ 9000, SET, "overlay5", { size => 0 } ],
    [ 9000, SET, "overlay8", { size => 0 } ],

	#onder lijn naar 0, rest naar 100
    [ 9500, SET, "overlay7", { size => 0 } ],
    [ 9500, SET, "overlay9", { size => 0 } ],
    [ 9500, SET, "overlay2", { size => 2/3 } ],
    [ 9500, SET, "overlay3", { size => 2/3 } ],
    [ 9500, SET, "overlay5", { size => 2/3 } ],
    [ 9500, SET, "overlay6", { size => 2/3 } ],
	
	#midden x lijn _ook_ naar 0
    [ 9750, SET, "overlay4", { size => 0 } ],
    [ 9750, SET, "overlay5", { size => 0 } ],
    [ 9750, SET, "overlay6", { size => 0 } ],

	# 4 blokjes over
    [10125, SET, "overlay2", { size => 2/3 } ],
    [10125, SET, "overlay4", { size => 2/3 } ],
    [10125, SET, "overlay6", { size => 2/3 } ],
    [10125, SET, "overlay8", { size => 2/3 } ],
    [10125, SET, "overlay1", { size => 0 } ],
    [10125, SET, "overlay3", { size => 0 } ],
    [10125, SET, "overlay5", { size => 0 } ],
    [10125, SET, "overlay7", { size => 0 } ],
    [10125, SET, "overlay9", { size => 0 } ],

	# 5 blokjes over
    [10250, SET, "overlay2", { size => 0 } ],
    [10250, SET, "overlay4", { size => 0 } ],
    [10250, SET, "overlay6", { size => 0 } ],
    [10250, SET, "overlay8", { size => 0 } ],
    [10250, SET, "overlay1", { size => 2/3 } ],
    [10250, SET, "overlay3", { size => 2/3 } ],
    [10250, SET, "overlay5", { size => 2/3 } ],
    [10250, SET, "overlay7", { size => 2/3 } ],
    [10250, SET, "overlay9", { size => 2/3 } ],

	# midden blokje over
    [10375, SET, "overlay5", { size => 2/3 } ],
    [10375, SET, "overlay2", { size => 0 } ],
    [10375, SET, "overlay4", { size => 0 } ],
    [10375, SET, "overlay6", { size => 0 } ],
    [10375, SET, "overlay8", { size => 0 } ],
    [10375, SET, "overlay1", { size => 0 } ],
    [10375, SET, "overlay3", { size => 0 } ],
    [10375, SET, "overlay7", { size => 0 } ],
    [10375, SET, "overlay9", { size => 0 } ],

	# leeg
    [10500, SET, "overlay5", { size => 0 } ],

	# ping
    [11125, SET, "rasTAr", { alpha => 0.0 } ],

	# pauze
    [12000, DEL, "overlay1", { } ], [12000, DEL, "overlay2", { } ],
    [12000, DEL, "overlay3", { } ], [12000, DEL, "overlay4", { } ],
    [12000, DEL, "overlay5", { } ], [12000, DEL, "overlay6", { } ],
    [12000, DEL, "overlay7", { } ], [12000, DEL, "overlay8", { } ], [12000, DEL, "overlay9", { } ],
    [12000, DEL, "rasTAr", { } ],
];

my $loading = [
# letters
	[    0, NEW, "Image", 100, "L", { image => "l.png",
									  x => -1.0, y => 0, size => 1.0, alignv => 1, alignh => 1,
									  alpha => 1, rot => 0, r => 0.4, g => 0.87, b => 0.7 } ],
	[    0, NEW, "Image", 100, "o", { image => "o.png",
									  x => -0.7, y => 0, size => 1.0, alignv => 1, alignh => 1,
									  alpha => 1, rot => 0, r => 0.8, g => 0.3, b => 0.7 } ],
	[    0, NEW, "Image", 100, "a", { image => "a.png",
									  x => -0.3, y => 0, size => 1.0, alignv => 1, alignh => 1,
									  alpha => 1, rot => 0, r => 0.8, g => 0.3, b => 0.2 } ],
	[    0, NEW, "Image", 100, "D", { image => "d.png",
									  x => 0.1, y => 0, size => 1.0, alignv => 1, alignh => 1,
									  alpha => 1, rot => 0, r => 0.8, g => 0.1, b => 0.8 } ],
	[    0, NEW, "Image", 100, "i", { image => "i.png",
									  x => 0.4, y => 0, size => 1.0, alignv => 1, alignh => 1,
									  alpha => 1, rot => 0, r => 0.2, g => 0.4, b => 0.9 } ],
	[    0, NEW, "Image", 100, "n", { image => "n.png",
									  x => 0.65, y => 0, size => 0.8, alignv => 1, alignh => 1,
									  alpha => 1, rot => 0, r => 0.2, g => 0.9, b => 0.9 } ],
	[    0, NEW, "Image", 100, "g", { image => "g.png",
									  x => 1.0, y => 0, size => 1.0, alignv => 1, alignh => 1,
									  alpha => 1, rot => 0, r => 1.0, g => 0.8, b => 0.2 } ],
	[  750, FLT, "L", { y => 0.7 }, FLTINOUT ],
	[ 1500, FLT, "L", { y => 0.0 }, FLTINOUT ],
	[ 2250, FLT, "L", { y => 0.7 }, FLTINOUT ],
	[ 3000, FLT, "L", { y => 0.0 }, FLTINOUT ],
	[ 3750, FLT, "L", { y => 0.7 }, FLTINOUT ],
	[ 4500, FLT, "L", { y => 0.0 }, FLTINOUT ],
	[ 5250, FLT, "L", { y => 0.7 }, FLTINOUT ],
	[  750+(sin($PI/7.0*1.0)*300), FLT, "o", { y => 0.7 }, FLTINOUT ],
	[ 1500+(sin($PI/7.0*1.0)*300), FLT, "o", { y => 0.0 }, FLTINOUT ],
	[ 2250+(sin($PI/7.0*1.0)*300), FLT, "o", { y => 0.7 }, FLTINOUT ],
	[ 3000+(sin($PI/7.0*1.0)*300), FLT, "o", { y => 0.0 }, FLTINOUT ],
	[ 3750+(sin($PI/7.0*1.0)*300), FLT, "o", { y => 0.7 }, FLTINOUT ],
	[ 4500+(sin($PI/7.0*1.0)*300), FLT, "o", { y => 0.0 }, FLTINOUT ],
	[ 5250+(sin($PI/7.0*1.0)*300), FLT, "o", { y => 0.7 }, FLTINOUT ],
	[  750+(sin($PI/7.0*2.0)*300), FLT, "a", { y => 0.7 }, FLTINOUT ],
	[ 1500+(sin($PI/7.0*2.0)*300), FLT, "a", { y => 0.0 }, FLTINOUT ],
	[ 2250+(sin($PI/7.0*2.0)*300), FLT, "a", { y => 0.7 }, FLTINOUT ],
	[ 3000+(sin($PI/7.0*2.0)*300), FLT, "a", { y => 0.0 }, FLTINOUT ],
	[ 3750+(sin($PI/7.0*2.0)*300), FLT, "a", { y => 0.7 }, FLTINOUT ],
	[ 4500+(sin($PI/7.0*2.0)*300), FLT, "a", { y => 0.0 }, FLTINOUT ],
	[ 5250+(sin($PI/7.0*2.0)*300), FLT, "a", { y => 0.7 }, FLTINOUT ],
	[  750+(sin($PI/7.0*3.0)*300), FLT, "D", { y => 0.7 }, FLTINOUT ],
	[ 1500+(sin($PI/7.0*3.0)*300), FLT, "D", { y => 0.0 }, FLTINOUT ],
	[ 2250+(sin($PI/7.0*3.0)*300), FLT, "D", { y => 0.7 }, FLTINOUT ],
	[ 3000+(sin($PI/7.0*3.0)*300), FLT, "D", { y => 0.0 }, FLTINOUT ],
	[ 3750+(sin($PI/7.0*3.0)*300), FLT, "D", { y => 0.7 }, FLTINOUT ],
	[ 4500+(sin($PI/7.0*3.0)*300), FLT, "D", { y => 0.0 }, FLTINOUT ],
	[ 5250+(sin($PI/7.0*3.0)*300), FLT, "D", { y => 0.7 }, FLTINOUT ],
	[  750+(sin($PI/7.0*4.0)*300), FLT, "i", { y => 0.7 }, FLTINOUT ],
	[ 1500+(sin($PI/7.0*4.0)*300), FLT, "i", { y => 0.0 }, FLTINOUT ],
	[ 2250+(sin($PI/7.0*4.0)*300), FLT, "i", { y => 0.7 }, FLTINOUT ],
	[ 3000+(sin($PI/7.0*4.0)*300), FLT, "i", { y => 0.0 }, FLTINOUT ],
	[ 3750+(sin($PI/7.0*4.0)*300), FLT, "i", { y => 0.7 }, FLTINOUT ],
	[ 4500+(sin($PI/7.0*4.0)*300), FLT, "i", { y => 0.0 }, FLTINOUT ],
	[ 5250+(sin($PI/7.0*4.0)*300), FLT, "i", { y => 0.7 }, FLTINOUT ],
	[  750+(sin($PI/7.0*5.0)*300), FLT, "n", { y => 0.7 }, FLTINOUT ],
	[ 1500+(sin($PI/7.0*5.0)*300), FLT, "n", { y => 0.0 }, FLTINOUT ],
	[ 2250+(sin($PI/7.0*5.0)*300), FLT, "n", { y => 0.7 }, FLTINOUT ],
	[ 3000+(sin($PI/7.0*5.0)*300), FLT, "n", { y => 0.0 }, FLTINOUT ],
	[ 3750+(sin($PI/7.0*5.0)*300), FLT, "n", { y => 0.7 }, FLTINOUT ],
	[ 4500+(sin($PI/7.0*5.0)*300), FLT, "n", { y => 0.0 }, FLTINOUT ],
	[ 5250+(sin($PI/7.0*5.0)*300), FLT, "n", { y => 0.7 }, FLTINOUT ],
	[  750+(sin($PI/7.0*6.0)*300), FLT, "g", { y => 0.7 }, FLTINOUT ],
	[ 1500+(sin($PI/7.0*6.0)*300), FLT, "g", { y => 0.0 }, FLTINOUT ],
	[ 2250+(sin($PI/7.0*6.0)*300), FLT, "g", { y => 0.7 }, FLTINOUT ],
	[ 3000+(sin($PI/7.0*6.0)*300), FLT, "g", { y => 0.0 }, FLTINOUT ],
	[ 3750+(sin($PI/7.0*6.0)*300), FLT, "g", { y => 0.7 }, FLTINOUT ],
	[ 4500+(sin($PI/7.0*6.0)*300), FLT, "g", { y => 0.0 }, FLTINOUT ],
	[ 5250+(sin($PI/7.0*6.0)*300), FLT, "g", { y => 0.7 }, FLTINOUT ],
# loading balkje
    [   0, NEW, "Image", 103, "balkje", { image => "balkje", imagedata => \$overlay{data},
										  width => $overlay{size}, height => $overlay{size},
										  x => 0.0, y => -0.8, wsize => 1.0, hsize => 1/4,
										  alignv => 1, alignh => 1,
										  alpha => 1, rot => 0, r => 0.7, g => 0.0, b => 0.0 } ],
	[  750, SET, "balkje", { wsize => (1.0/7.0)*2, g =>  0.1 } ],
	[ 1500, SET, "balkje", { wsize => (3.0/7.0)*2, g =>  0.2 } ],
	[ 2250, SET, "balkje", { wsize => (5.0/7.0)*2, g =>  0.3 } ],
	[ 3000, SET, "balkje", { wsize => (6.0/7.0)*2, g =>  0.4 } ],
	[ 3750, SET, "balkje", { wsize => (4.0/7.0)*2, g =>  0.5 } ],
	[ 4500, SET, "balkje", { wsize => (7.0/7.0)*2, g =>  0.6 } ],
	[ 5250, SET, "balkje", { wsize => (2.0/7.0)*2, g =>  0.7 } ],

	[ 6000, DEL, "L" ],	[ 6000, DEL, "o" ],	[ 6000, DEL, "a" ],	[ 6000, DEL, "D" ],	[ 6000, DEL, "i" ],
	[ 6000, DEL, "n" ],	[ 6000, DEL, "g" ],	[ 6000, DEL, "balkje" ]
];

my $credits = [
	[    0, NEW, "InkStain", 100, "boek", { frontimage => "bookfront.jpg", openangle => 0.0, stainsize => 0.0 } ],
	[ 1000, DEL, "boek" ],
	[ 1000, NEW, "InkStain", 100, "boek", { frontimage => "bookfrontfull.jpg", openangle => 0.0, stainsize => 0.0 } ],

	[ 2000, SET, "boek", { } ],
	[ 3000, FLT, "boek", { openangle => 180.0 } ],

	[ 3000, NEW, "Image",	101, "sjonny", { image => "models/sjonny.png",
									  x => 0, y => 0, size => 1.0, alignv => 1, alignh => 1,
									  alpha => 0, rot => 0, r => 1, g => 1, b => 1 } ],
	[ 4000, FLT, "sjonny",  {alpha => 1} ],
	[ 4000, SET, "sjonny",  {} ],
	[ 5000, SET, "sjonny",  {} ],
	[ 6000, FLT, "sjonny",  {alpha => 0} ],

	[ 7000, NEW, "Image",	101, "sjonny", { image => "models/sharky.png",
									  x => 0, y => 0, size => 1.0, alignv => 1, alignh => 1,
									  alpha => 0, rot => 0, r => 1, g => 1, b => 1 } ],
	[ 8000, FLT, "sjonny",  {alpha => 1} ],
	[ 9000, SET, "sjonny",  {} ],
	[ 10000, SET, "sjonny",  {} ],
	[ 11000, FLT, "sjonny",  {alpha => 0} ],

	[ 12000, NEW, "Image",	101, "sjonny", { image => "models/mlein.png",
									  x => 0, y => 0, size => 1.0, alignv => 1, alignh => 1,
									  alpha => 0, rot => 0, r => 1, g => 1, b => 1 } ],
	[ 13000, FLT, "sjonny",  {alpha => 1} ],
	[ 14000, SET, "sjonny",  {} ],
	[ 15000, SET, "sjonny",  {} ],
	[ 16000, FLT, "sjonny",  {alpha => 0} ],

	[ 17000, NEW, "Image",	101, "sjonny", { image => "models/roel.png",
									  x => 0, y => 0, size => 1.0, alignv => 1, alignh => 1,
									  alpha => 0, rot => 0, r => 1, g => 1, b => 1 } ],
	[ 18000, FLT, "sjonny",  {alpha => 1} ],
	[ 19000, SET, "sjonny",  {} ],
	[ 20000, SET, "sjonny",  {} ],
	[ 21000, FLT, "sjonny",  {alpha => 0} ],

	[ 22000, SET, "boek", {} ],
	[ 23000, FLT, "boek", { openangle => 0}  ],
    [ 23000, NEW, "Image", 110,  "brt", { image => "models/brt.jpg", x => -0.3, y => -0.7, size => 0.4, alignv => 1, alignh => 1, alpha => 1, rot => 0, r=> 1.0, g => 1.0, b => 1.0 } ],
    [ 25000, NEW, "Image", 110,  "testbeeld", { image => "testbeeld.gif", x => 0, y => 0, size => 2.66, alignv => 1, alignh => 1, alpha => 1, rot => 0, r=> 1.0, g => 1.0, b => 1.0 } ],
    [ 30000, DEL, "testbeeld" ]
];


my $demo = [
			[ 0, NEW, "Program", 100, "tiktak", { program => $tiktak } ],
			[ 27000, DEL, "tiktak" ],

			[ 27000, NEW, "Program", 101, "loading", { program => $loading } ],
			[ 30000, DEL, "loading" ], # te lang, maar who cares..

			[ 30000, NEW, "Program", 100, "baltrap", { program => $baltrap } ],
			[ 54000, DEL, "baltrap" ],

			[ 54000, NEW, "Program", 101, "loading", { program => $loading } ],
			[ 60000, DEL, "loading" ],

			[ 60000, NEW, "Program", 100, "schaakbord", { program => $schaakbord } ],
			[ 84000, DEL, "schaakbord" ],

			[ 84000, NEW, "Program", 101, "loading", { program => $loading } ],
			[ 90000, DEL, "loading" ],

			[ 90000, NEW, "Program", 100, "beker", { program => $beker } ],
			[ 114000, DEL, "beker" ],

			[ 114000, NEW, "Program", 101, "loading", { program => $loading } ],
			[ 120000, DEL, "loading" ],

			[ 120000, NEW, "Program", 100, "schuifpuzzel", { program => $schuifpuzzel } ],
			[ 132000, DEL, "schuifpuzzel" ],

			[ 132000, NEW, "Program", 101, "loading", { program => $loading } ],
			[ 138000, DEL, "loading" ],

			[ 138000, NEW, "Program", 100, "struisvogel", { program => $struisvogel } ],
			[ 174000, DEL, "struisvogel" ],

			[ 174000, NEW, "Program", 100, "credits", { program => $credits } ],
			[ 201000, DEL, "credits" ],
];

sub create_generated_data {
	my ($x, $y);

	if ($spiral{make}) {
		for($y=0; $y < $spiral{size}; $y++) {
			for($x=0; $x < $spiral{size}; $x++) {
				$c = atan2($y-($spiral{hsize}),$x-($spiral{hsize}));

				$c = $c / (2*$PI) + (sqrt(($x-$spiral{hsize})**2 + ($y-$spiral{hsize})**2) / 400);
				$c *= 256 * 4;

				if($c % 256 > 127) {
					$spiral{data} .= pack("CCCC",0, 255, 0, 255);
				} else {
					$spiral{data} .= pack("CCCC",0, 0, 255, 255);
				}
			}
		}
	}

	if ($rastar{make}) {
		my @data;
		# reset to all alpha values
		for ($x=0; $x<$rastar{size}**2; $x++) {
			$data[$x] = pack("CCCC", 0, 0, 0, 0);
		}

		# 4 horizontal lines, y..y+5 is line, x is offset
		my @color = ( 200, 200, 200, 255 );
		foreach (0, 1, 2, 3) {
			$y = int($rastar{size}/3) * $_;
			for ($line=0-$_; $line<5-$_; $line++) {	# niet goed, maar goed genoeg.
				for ($x=0; $x<$rastar{size}; $x++) {
					$data[(($y+$line)*$rastar{size})+$x] = pack("CCCC", @color);
				}
			}
		}
		# 4 vertical lines, x..x+5 is line, y is offset
		foreach (0, 1, 2, 3) {
			$x = int($rastar{size}/3) * $_;
			for ($line=0-$_; $line<5-$_; $line++) {	# niet goed, maar goed genoeg.
				for ($y=0; $y<$rastar{size}; $y++) {
					$data[($y*$rastar{size})+$x+$line] = pack("CCCC", @color);
				}
			}
		}
		# middel punt rood!
#		$data[$rastar{size}*($rastar{size}/2)+$rastar{size}/2] = pack("CCCC", 255, 0, 0, 255);
		# convert to buffer
		$rastar{data} = join('',@data);
	}

	if ($overlay{make}) {
		for ($x=0; $x<$overlay{size}**2; $x++) {
			$overlay{data} .= pack("CCCC", 255, 255, 255, 255);	# color is set in Image
		}
	}
}

sub main {
	my ($x, $y, $dc) = @_;
	my $msec = 0000;
	my $finished = 0;
	my $space = 0;

	print "Calculating .. shouldn't take long...\n";
	create_generated_data;

	print "Setting up main Program\n";

	my $p = new Program($dc);

	$p->SetParams({program => $demo});

	print "Starting mp3 stream ..\n";
	OpenGL::glSetSoundPos($msec);
	OpenGL::glStartSound();
	my $start = OpenGL::glGetTime(); #- OpenGL::glGetSoundPos();

	print "Starting render loop ..\n";

	while(!$finished) {
		OpenGL::glClear();

		$finished = $p->Render(OpenGL::glGetTime() - $start + $msec);

		OpenGL::SwapBuffers();

		OpenGL::glPumpEvents();
		if(OpenGL::glSpacePressed()) {
			if(!$space) {
				print "Pos: " .(OpenGL::glGetTime() - $start + $msec) . "\n";
				$space = 1;
			}
		} else {
			$space = 0;
		}
		if(OpenGL::glEscPressed()) {
			$finished = 1;
		}
		  # spoeleuh!
		if(OpenGL::glRightPressed()) {
			$msec += 50;
			OpenGL::glSetSoundPos($msec*2);	# err .. how much?
		}
		if(OpenGL::glLeftPressed()) {
			# hmm... not really wanted effect for FLT variables :D
			$msec -= 100;
			if ($msec < 0) {
				$msec = 0;
			}
			OpenGL::glSetSoundPos($msec*2);	# here too!
		}
	}

	return 0;
}
