#ifndef fx_glitch_hh
#define fx_glitch_hh

#include <commons.hh>
#include <effect.hh>
#include <mailbox.hh>
#include <SDL_mixer.h>

#include <set>
#include <vector>
using namespace std;

class fx_glitch : public AudioEffect
{
   public:
      fx_glitch(Demo* const demo,
		shared_ptr<MailBox<double> > mailbox,
		const double volume);
      void process(const double ms,
		   AudioSample& sample,
		   const int frequency);
      ~fx_glitch();
      
   private:
      bool hasEvents(const double ms);
      void playSample(const double ms,
		      AudioSample& sample);
      void startPlay(const double ms);
      void stopPlay();
      AudioSample& getSample(const int position);
      
      Mix_Chunk* sample;
      shared_ptr<MailBox<double> > mailbox;
      double lastTime;
      set<double> timings;
      bool isPlaying;
      int playPosition;
      int lenSample;
      int randPosition;
      vector<AudioSample> buffer;

      const double volume;

      static const int PLAY_SIZE = 1500;
};

#endif
