struct VS_OUTPUT
{
  float4 Position: POSITION;
  float3 Tex0:     TEXCOORD0;
};

float V_Alpha : ALPHA;
float V_InvScreenW : INVSCREENW;
float V_InvScreenH : INVSCREENH;
float V_Type: VAR1;

sampler Sampler = sampler_state
{
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
};

sampler textura : register(s0);

float4 PS(VS_OUTPUT In) : COLOR0
{
  float4 Color;
  
  //pillamos los pixeles de alrededor para hacer una guarra-convolution
  float4 _11 = tex2D(textura, In.Tex0 + float2(-V_InvScreenW, -V_InvScreenH));
  float4 _12 = tex2D(textura, In.Tex0 + float2(            0, -V_InvScreenH));
  float4 _13 = tex2D(textura, In.Tex0 + float2( V_InvScreenW, -V_InvScreenH));
  float4 _21 = tex2D(textura, In.Tex0 + float2(-V_InvScreenW,             0));
  float4 _23 = tex2D(textura, In.Tex0 + float2( V_InvScreenW,             0));
  float4 _31 = tex2D(textura, In.Tex0 + float2(-V_InvScreenW,  V_InvScreenH));
  float4 _32 = tex2D(textura, In.Tex0 + float2(            0,  V_InvScreenH));
  float4 _33 = tex2D(textura, In.Tex0 + float2( V_InvScreenW,  V_InvScreenH));
  
  // No se si es exactamente Sobel, pero tampoco es que me importe mucho... ;
  float4 x = -_11 - (2*_21) - _31 + _13 + (2*_23) + _33;
  float4 y = +_11 + (2*_12) + _13 - _31 - (2*_32) - _33;

  float c = sqrt((x*x)+(y*y));
  if (V_Type < 1)
    Color.r = Color.g = Color.b = c;
  else if (V_Type < 2)
    Color.r = Color.g = Color.b = 1-c;
  else if (V_Type < 3)
    Color = tex2D(textura, In.Tex0) + float4(c,c,c,c);
  else if (V_Type < 4)
    Color = tex2D(textura, In.Tex0) - float4(c,c,c,c);
  Color.a = V_Alpha;
 
  return Color;
}

technique Sobel
{
  pass PassSobel
  {
    PixelShader = compile ps_2_0 PS();
  }
}
