;-------------------------------------------------------------
; Tempo
;-------------------------------------------------------------

TEMPODELAY equ 3

;-------------------------------------------------------------
; Sound Attenuation Array
;-------------------------------------------------------------
; 000=square  001=bass  010=pitfall  011=noise
; 100=buzz    101=lead  110=saw      111=lowbass

soundTurnArray
	byte 8, 0, 5, 9
	byte 0, 6, 4, 0

;-------------------------------------------------------------
; Sound Type Array
;-------------------------------------------------------------

soundTypeArray
    byte 4,6,7,8
    byte 15,12,1,14

;-------------------------------------------------------------
; Auto High Hat
;-------------------------------------------------------------

hatPattern
	byte %10001000
	byte %10001000
	byte %10001000
	byte %10001010

HATSTART equ 4

HATVOLUME equ 4
HATPITCH equ 0
HATSOUND equ 8

;-------------------------------------------------------------
; Song Data
;-------------------------------------------------------------

song1
	; intro
	byte 1,1
	byte 1,8

	byte 2,3
	byte 2,3
	byte 2,3
	byte 2,9

	; arp on song2
	byte 2,3
	byte 2,4
	byte 2,3
	byte 2,4

	; arp + sqr on song2

	byte 2,3
	byte 2,4
	byte 2,3
	byte 2,4

	byte 14

	byte 2,3
	byte 2,4
	byte 2,3
	byte 2,4

	byte 2,3
	byte 2,4
	byte 2,3
	byte 2,4

	byte 2,3
	byte 2,4
	byte 2,3
	byte 2,4

	byte 20,20
	byte 20,21
	byte 20,20
	byte 20,9

	byte 2,3
	byte 2,4
	byte 2,3
	byte 2,4

	byte 2,3
	byte 2,4
	byte 2,3
	byte 2,4

	byte 20,20
	byte 20,21
	byte 20,20
	byte 20,23

	byte 0,0

	; End of song marker
	byte 255


song2
	; intro on song1
	byte 0,0
	byte 0,0
	byte 0,0
	byte 0,0
	byte 0,0
	byte 0,0

	; arp
	byte 10,11
	byte 10,12
	byte 10,11
	byte 10,12

	; arp + sqr
	byte 5,6
	byte 5,7
	byte 5,6
	byte 5,7

	byte 15

	byte 13,13
	byte 13,6
	byte 13,13
	byte 13,6

	byte 13,13
	byte 13,6
	byte 13,13
	byte 13,6

	byte 16,17
	byte 16,19
	byte 16,17
	byte 18,19

	byte 22,0
	byte 22,0
	byte 22,0
	byte 18,128

	byte 10,11
	byte 10,12
	byte 10,11
	byte 10,12

	byte 5,6
	byte 5,7
	byte 5,6
	byte 5,7

	byte 5,6
	byte 5,7
	byte 5,6
	byte 5,7

	byte 0,0

	; End of song marker
	byte 255

;-------------------------------------------------------------
; Pattern Arrays
;-------------------------------------------------------------

patternArrayH

	word mute,mute,mute,mute			;0
	word Beat1a,Beat1b,Beat1c,Beat1d		;1 beat
	word Backing1a,Backing1b,Backing1c,Backing1d	;2 beat+bass
	word Backing2a,Backing2b,Backing2c,Backing2d	;3 beat+bass
	word Backing2a,Backing2b,Backing2c,Backing2e	;4 beat+bass fill
	word Mel1a,Mel1b,Mel1a,Mel1b			;5
	word Mel1c,Mel1d,Mel1e,Mel1f			;6
	word Mel1c,Mel1d,Mel1g,Mel1h			;7
	word Beat1a,Beat1b,Beat1c,Beat1e		;8 beat+fill
	word Beat1a,mute,mute,Beat1e			;9
	word Mel2a,Mel2b,Mel2a,Mel2b			;10
	word Mel2c,Mel2d,Mel2e,Mel2f			;11
	word Mel2g,Mel2h,Mel2e,Mel2f			;12
	word Mel3a,Mel3b,Mel3a,Mel3b			;13
	word Beat2a,Beat1b,Beat1c,Beat2b		;14 beat fill
	word Bass1a,Bass1b,Bass1c,Mel1a			;15 bass fill
	word Mel4a,Mel4b,Mel4c,Mel4d			;16
	word Mel4e,Mel4f,Mel4g,Mel4h			;17
	word Mel4i,Mel4j,Mel4c,Mel4d			;18 16 var
	word Mel4e,Mel4f,Mel4g,Mel4k			;19 17 var

	word Backing3a,Backing3b,Backing3c,Backing3d	;20
	word Backing3a,Backing3b,Backing3c,Backing3e	;21
	word Mel4a,Mel4b,Mel4c,mute			;22 16 var
	word Beat1a,mute,mute,mute			;23

patternArrayL

;	word Mel4a,Mel4b,Mel4c,mute			;128
;	word Bass1c, Bass1c, Bass1b, Bass1b		;129
	
;-------------------------------------------------------------
; Pattern Data
;-------------------------------------------------------------

Backing2a
	byte %10011111, %01111110	;kick
	byte %11011010, 255		;saw d#2
	byte 255, 255
	byte %11011010, 255		;saw d#2

	byte %10000010

Backing2b
	byte %10000100, %01100100	;snare
	byte 255,255
	byte %11011010, %11011010	;saw d#2
	byte %10011110, 255		;kick

	
	byte %10001000

Backing2c
	byte 255,255
	byte %01010110, 255		;pfall f1
	byte %10011111, 255		;kick
	byte 255,255

	byte %00101000

Backing2d
	byte %10000100, %01100100	;snare
	byte %01010110, 255		;pfall f1
	byte %01010110, %01010110	;pfall f1
	byte %11010111, 255		;saw f2
	
	byte %10101000

Backing2e
	byte %10000100, %01100100	;snare
	byte %01010110, 255		;pfall f1
	byte %10000100, %01010110	;pfall f1
	byte %10000100, %01100100	;snare
	
	byte %10101010

Backing1a
	byte %10011111, %01111110	;kick
	byte %11011111, 255		;saw c2
	byte 255, 255
	byte %01011110, 255		;pfall c1

	byte %10000010

Backing1b
	byte %10000100, %01100100	;snare
	byte 255,255
	byte %11011111, %11011111	;saw c2
	byte %10011110, 255		;kick

	
	byte %10000000

Backing1c
	byte 255,255
	byte %11011111, 255		;saw c2
	byte %10011111, 255		;kick
	byte 255,255

	byte %00101000

Backing1d
	byte %10000100, %01100100	;snare
	byte %01011110, 255		;pfall c1
	byte %11011111, %11011111	;saw c2
	byte %11001111, 255		;saw c3
	
	byte %10101000

Backing3a
	byte %10011111, %01111110	;kick
	byte %11011111, 255		;saw c2
	byte 255, 255
	byte %01011110, 255		;pfall c1

	byte %10000010

Backing3b
	byte %10011111, %01111110	;kick
	byte 255,255
	byte %11011111, %11011111	;saw c2
	byte 255, 255			;

	
	byte %10000000

Backing3c
	byte %10011111, %01111110	;kick
	byte %11011111, 255		;saw c2
	byte 255, 255			;
	byte 255,255

	byte %00101000

Backing3d
	byte %10011111, %01111110	;kick
	byte %01011110, 255		;pfall c1
	byte %11011111, %11011111	;saw c2
	byte %11001111, 255		;saw c3
	
	byte %10101000

Backing3e
	byte %10011111, %01111110	;kick
	byte %01011110, 255		;pfall c1
	byte %10011111, %01111110	;kick
	byte %11001111, 255		;saw c3
	
	byte %10101000

Beat1a
	byte %10011111, %01111110
	byte 255,255
	byte 255,255
	byte 255,255

	byte %10000000

Beat1b
	byte %10000100, %01100100
	byte 255,255
	byte 255, 255
	byte %10011110, 255

	
	byte %10000000

Beat1c
	byte 255,255
	byte 255,255
	byte %10011111, %01111110
	byte 255,255

	byte %00001000

Beat1d
	byte %10000100, %01100100
	byte 255, 255
	byte 255, 255
	byte %01100001, 255
	
	byte %10000000

Beat1e					;snare fill
	byte %10000100, %01100100
	byte 255, 255
	byte %10000100, 255
	byte %10000100, %01100100
	
	byte %10000010

Beat2a
	byte %10011111, %01111110
	byte %10011111,255
	byte 255,255
	byte %10011111, %01111110

	byte %10000000

Beat2b
	byte %10000100, %01100100
	byte 255,255
	byte %10000100, %01100100
	byte %10000100,255

	byte %10000000


Mel1a
	byte %00010111, 255		; sqr e5
	byte 255, 255
	byte %10111111, %10111111	; lead e3
	byte %00010111, 255		; sqr e5

Mel1b
	byte %10110011, %10101111	; lead c4/e4
	byte %10110011, 255		; lead c4
	byte %10111111, 255		; lead e3
	byte 255, 255

Mel1c
	byte %00011010, %00011010	; sqr d5
	byte 255, 255
	byte %10110111, %10110111	; lead a3
	byte %00011010, 255		; sqr d5

Mel1d
	byte %10101110, %10101011	; lead f4/a4
	byte %10101110, 255		; lead f4
	byte %10110111, 255		; lead a3
	byte 255, 255

Mel1e
	byte %00011101, %00011101	; sqr c5
	byte 255, 255
	byte %10111101, %10111101	; lead f3
	byte %00011101, %00011101	; sqr c5

Mel1f
	byte %10110011, %10101110]	; lead c4/f4
	byte %10110011, 255		; lead c4
	byte %10111101, 255		; lead f3
	byte %10111101, 255		; lead f3

Mel1g
	byte %00010011, 255		; sqr g5
	byte 255, 255
	byte %10110011, %10110011	; lead c4
	byte %00010011, %00010011	; sqr g5

Mel1h
	byte %10101110, %10101001	; lead f4/c5
	byte %10101110, 255		; lead f4
	byte %00001110, 255		; sqr c6
	byte %10110011, 255		; lead c4


Mel2a
	byte 255, 255
	byte 255, 255
	byte %10111111, %10111111	; lead e3
	byte 255, 255

Mel2b
	byte %10110011, %10101111	; lead c4/e4
	byte %10110011, 255		; lead c4
	byte %10111111, 255		; lead e3
	byte 255, 255

Mel2c
	byte 255, 255
	byte 255, 255
	byte %10110111, %10110111	; lead a3
	byte 255, 255

Mel2d
	byte %10101110, %10101011	; lead f4/a4
	byte %10101110, 255		; lead f4
	byte %10110111, 255		; lead a3
	byte 255, 255

Mel2e
	byte 255, 255
	byte 255, 255
	byte %10111101, %10111101	; lead f3
	byte 255, 255

Mel2f
	byte %10110011, %10101110]	; lead c4/f4
	byte %10110011, 255		; lead c4
	byte %10111101, 255		; lead f3
	byte %10111101, 255		; lead f3

Mel2g
	byte 255, 255
	byte 255, 255
	byte %10110011, %10110011	; lead c4
	byte 255, 255

Mel2h
	byte %10101110, %10101001	; lead f4/c5
	byte %10101110, 255		; lead f4
	byte %10110011, 255		; lead c4
	byte 255, 255

Mel3a
	byte %00010111, 255		; sqr arp
	byte %00011101, 255
	byte %00010011, 255		; 
	byte %00011101, 255

Mel3b
	byte %00001011, 255		;
	byte %00001110, 255		;
	byte %00010011, 255		;
	byte %00011101, 255


Mel4a
	byte %10111111,%10111111
	byte %10111111,%10111111
	byte 255,255
	byte %10111101,%10111101

	byte 00000000

Mel4b
	byte %10111101,%10111101
	byte 255,255
	byte %10111010,%10111010
	byte %10111010,%10111010

	byte 00000000

Mel4c
	byte %10110011,%10110011
	byte %10110011,255
	byte %10110001,255
	byte %10101111,%10101111

	byte 00000000

Mel4d
	byte %10101111,255
	byte 255,255
	byte %10111010,255
	byte %10110001,255

	byte 00000010

Mel4e
	byte 255,255
	byte %10111010,255
	byte %10110001,255
	byte %10111010,255

	byte 00000010

Mel4f
	byte %10110001,%10110001
	byte 255,255
	byte %10111010,255
	byte %10111010,255

	byte 00000010

Mel4g
	byte %10110011,%10110011
	byte 255,255
	byte %10111010,255
	byte %10110011,255

	byte 10001000

Mel4h
	byte 255,255
	byte %10111010,255
	byte %10110011,255
	byte %10101110,255

	byte 00100010

Mel4i
	byte %10101111,%10101111
	byte %10101111,255
	byte 255,255
	byte %10110011,%10110011

	byte 00000000

Mel4j
	byte %10110011,%10110011
	byte 255,255
	byte %10111010,%10111010
	byte %10111010,%10111010

	byte 00000000

Mel4k
	byte 255,255
	byte %10101001,255
	byte %10101000,255
	byte %10101001,255

	byte 00101010

KickMel1a
	byte %10011110, %01111110
	byte %10101100, 255
	byte %10110110, 255
	byte %10111110, 255

	byte %10000000

KickMel1b
	byte %10011110, 255
	byte %10111110, 255
	byte %10110110, 255
	byte %10011110, 255

	byte %10000000


KickMel1c
	byte %10011110, %01111110
	byte %00010110, 255
	byte %00011001, 255
	byte %00011100, 255

	byte %10000000

KickMel1d
	byte %10011110, 255
	byte %11011110, 255
	byte %10110110, 255
	byte %11011011, 255

	byte %10000000

KickMel1e
	byte %10011110, 255
	byte %01000100, 255
	byte %01000010, 255
	byte %01000100, 255

	byte %10000000


Snare1a
	byte %10000100, %01100100
;	byte %01100101, %01100101
	byte 255, 255
	byte 255, 255
	byte %10011111,255
	
	byte %10000010

Snare1b
	byte %10000100, %01100100
	byte %01100101, %01100101
	byte %10011110, 255
	byte 255, 255
	
	byte %11000000

Snare1c
	byte %10000100, %01100100
	byte %01100101, %01100101
	byte %10000100, %01100100
	byte %10000100, %01100101
	
	byte %11000000


Bass1a
	byte %11011111, 255
	byte %11011111, 255
	byte %00001110, 255		;sqr c6
	byte %11001111, 255

	byte %11000000

Bass1b
	byte %11001111,%11001111
	byte %00010011,255		;sqr g5
	byte %11011111,255
	byte %00001110,%00001110	;sqr c6

	byte %10000000

Bass1c
	byte %00011101,%00011101	;sqr c5
	byte %11011111,255
	byte %11011111,255
	byte %11011111,255

	byte %10001010


mute
	byte 255,255,255,255
	byte 255,255,255,255

	byte 255