BEGIN {
	require Mixer;
	require OpenGL;
	require Program;
	require Square;
	require Spline;
	require Image;
	require Particle;
	require Model;
	QGrid::boot_QGrid();
	Orbit::boot_Orbit();
}

my $paths2 = [			
		"M82.25,149.75V79.5h-62.5v70.25H0V4.5h19.75v58.25h62.5V4.5H102v145.25H82.25z
		M218.625,98.5h-75.766c0,12.469,3.371,22.051,10.117,28.746c5.953,5.836,13.625,8.754,23.016,8.754c10.645,0,19.539-3.164,26.68-9.5l7.938,13.5c-2.914,2.922-7.352,5.445-13.309,7.566c-7.484,2.789-15.824,4.184-25.027,4.184
			c-13.242,0-24.5-4.531-33.77-13.594c-10.266-9.988-15.395-23.418-15.395-40.289c0-17.531,5.254-31.59,15.77-42.176c9.453-9.461,20.629-14.191,33.523-14.191c15.008,0,26.777,4.27,35.309,12.809c8.266,8.211,12.398,19.102,12.398,32.672
			c0,4.172-0.496,8.012-1.484,11.52z M173.176,57.25c-8.336,0-15.316,2.727-20.938,8.172c-5.359,5.18-8.402,11.625-9.129,19.328h58.25c0-7.637-2.352-14.012-7.047-19.129c-5.16-5.578-12.207-8.371-21.137-8.371z
		M241.316,119.715V0h18.75v116.637c0,5.695,1.629,10.18,4.887,13.453s7.543,4.91,12.863,4.91v16.75c-24.336,0-36.5-10.676-36.5-32.035z
		M300.639,119.715V0h18.75v116.637c0,5.695,1.629,10.18,4.887,13.453s7.543,4.91,12.863,4.91v16.75c-24.336,0-36.5-10.676-36.5-32.035z
		M351.461,96.375c0-16.406,4.363-29.652,13.098-39.742c8.73-10.086,20.238-15.133,34.527-15.133c15.078,0,26.785,4.848,35.121,14.539s12.504,23.137,12.504,40.336c0,17.137-4.27,30.648-12.801,40.539s-20.141,14.836-34.824,14.836
			c-14.949,0-26.625-4.992-35.023-14.984c-8.402-9.988-12.602-23.453-12.602-40.391z M371.211,96.375c0,26.75,9.289,40.125,27.875,40.125c8.695,0,15.516-3.582,20.461-10.75c4.941-7.168,7.414-16.961,7.414-29.375c0-26.414-9.293-39.625-27.875-39.625
			c-8.438,0-15.191,3.52-20.266,10.555s-7.609,16.727-7.609,29.07z"
];

my $paths = [ "M5.228,6.459v1.626H3.389v12.813H1.565V8.086H0V6.459h1.565V2.842c0-0.578,0.03-1.019,0.091-1.322C1.717,1.247,1.818,1.003,1.96,0.791c0.203-0.264,0.501-0.466,0.897-0.608C3.242,0.061,3.729,0,4.316,0c0.709,0,1.246,0.081,1.611,0.243
				s0.633,0.446,0.806,0.851C6.885,1.5,6.961,2.083,6.961,2.842v2.006H5.228V1.672H3.389v4.788h1.839z",
			"M7.913,20.903V0.156h1.839v20.747H7.913z",
			"M16.97,9.307v11.597h-1.824V20.22c-0.679,0.557-1.348,0.835-2.006,0.835c-0.547,0-0.953-0.152-1.216-0.456c-0.273-0.304-0.41-0.755-0.41-1.353v-0.563v-0.639v-2.827v-0.639v-0.395c0-0.577,0.056-0.978,0.167-1.201c0.263-0.517,0.75-0.775,1.459-0.775
				c0.689,0,1.358,0.279,2.006,0.836V7.984h-1.839v2.538h-1.824V9.307V8.684c0-0.892,0.203-1.51,0.608-1.854c0.385-0.344,1.089-0.517,2.112-0.517c0.689,0,1.236,0.076,1.642,0.228c0.415,0.172,0.704,0.426,0.866,0.76c0.172,0.365,0.259,0.841,0.259,1.429v0.578z
				 M13.307,19.384h1.839v-5.502h-1.839v5.502z",
			"M26.031,7.984h-1.824v12.919h-1.839V7.984h-1.824v12.919h-1.839V6.464h1.839v0.684c0.557-0.557,1.231-0.836,2.021-0.836c0.375,0,0.699,0.076,0.973,0.228c0.273,0.172,0.445,0.375,0.517,0.608c0.557-0.557,1.246-0.836,2.067-0.836
				c0.608,0,1.054,0.142,1.338,0.425c0.273,0.284,0.41,0.74,0.41,1.368v0.563v0.653v11.582h-1.839V7.984z",
			"M29.587,2.193V0.156h1.839v2.037h-1.839z M29.587,20.903V6.464h1.839v14.439h-1.839z",
			"M33.25,6.464h1.839v0.684c0.557-0.557,1.231-0.836,2.021-0.836c1.084,0,1.631,0.598,1.641,1.793v0.563v0.653v11.582h-1.839V7.984h-1.824v12.919H33.25V6.464z",
			"M44.039,6.464h1.824V23.35v0.608c0,0.871-0.208,1.484-0.624,1.839c-0.405,0.364-1.109,0.547-2.112,0.547c-1.003,0-1.713-0.183-2.128-0.547c-0.416-0.355-0.624-0.978-0.624-1.87V23.35v-1.337H42.2v2.66h1.839V20.22c-0.709,0.557-1.383,0.835-2.021,0.835
				c-0.567,0-0.983-0.147-1.246-0.44c-0.264-0.294-0.396-0.75-0.396-1.368v-0.563v-0.639V9.322V8.668v-0.38c0-0.577,0.056-0.978,0.167-1.201c0.263-0.517,0.76-0.775,1.489-0.775c0.74,0,1.409,0.279,2.006,0.836V6.464z M44.039,19.384V7.984H42.2v11.399h1.839z",
			"M58.724,7.984h-1.824v12.919h-1.839V7.984h-1.824v12.919h-1.839V6.464h1.839v0.684c0.557-0.557,1.231-0.836,2.021-0.836c0.375,0,0.699,0.076,0.973,0.228c0.273,0.172,0.445,0.375,0.517,0.608c0.557-0.557,1.246-0.836,2.067-0.836
				c0.608,0,1.054,0.142,1.338,0.425c0.273,0.284,0.41,0.74,0.41,1.368v0.563v0.653v11.582h-1.839V7.984z",
			"M67.674,9.307v11.597H65.85V20.22c-0.679,0.557-1.348,0.835-2.006,0.835c-0.547,0-0.953-0.152-1.216-0.456c-0.273-0.304-0.41-0.755-0.41-1.353v-0.563v-0.639v-2.827v-0.639v-0.395c0-0.577,0.056-0.978,0.167-1.201c0.263-0.517,0.75-0.775,1.459-0.775
				c0.689,0,1.358,0.279,2.006,0.836V7.984h-1.839v2.538h-1.824V9.307V8.684c0-0.892,0.203-1.51,0.608-1.854c0.385-0.344,1.089-0.517,2.112-0.517c0.689,0,1.236,0.076,1.642,0.228c0.415,0.172,0.704,0.426,0.866,0.76c0.172,0.365,0.259,0.841,0.259,1.429v0.578z
				 M64.011,19.384h1.839v-5.502h-1.839v5.502z",
			"M69.409,6.464h1.839v0.684c0.557-0.557,1.231-0.836,2.021-0.836c1.084,0,1.631,0.598,1.641,1.793v0.563v0.653v1.201h-1.839V7.984h-1.824v12.919h-1.839V6.464z",
			"M81.52,9.307v1.216h-1.824V7.984h-1.839v4.377h1.201h0.456c0.709,0,1.221,0.157,1.535,0.471c0.314,0.314,0.471,0.806,0.471,1.474v0.623v3.131v0.623c0,0.861-0.198,1.469-0.593,1.824c-0.406,0.365-1.12,0.547-2.143,0.547c-1.003,0-1.713-0.182-2.128-0.547
				c-0.416-0.354-0.624-0.978-0.624-1.87v-0.577v-2.037h1.824v3.359h1.839v-5.396H78.45h-0.411c-0.477,0-0.861-0.061-1.155-0.182c-0.284-0.122-0.497-0.314-0.639-0.578c-0.142-0.263-0.213-0.613-0.213-1.049v-0.578V9.307V8.684c0-0.892,0.203-1.51,0.608-1.854
				c0.385-0.344,1.089-0.517,2.112-0.517c0.689,0,1.236,0.076,1.642,0.228c0.415,0.172,0.704,0.426,0.866,0.76c0.172,0.365,0.259,0.841,0.259,1.429v0.578z",
			"M83.255,0.156h1.839v6.992c0.557-0.557,1.231-0.836,2.021-0.836c1.084,0,1.631,0.598,1.641,1.793v0.563v0.653v11.582h-1.839V7.984h-1.824v12.919h-1.839V0.156z",
			"M97.801,7.984h-1.824v12.919h-1.839V7.984h-1.824v12.919h-1.839V6.464h1.839v0.684c0.557-0.557,1.231-0.836,2.021-0.836c0.375,0,0.699,0.076,0.973,0.228c0.273,0.172,0.445,0.375,0.517,0.608c0.557-0.557,1.246-0.836,2.067-0.836
				c0.608,0,1.054,0.142,1.338,0.425c0.273,0.284,0.41,0.74,0.41,1.368v0.563v0.653v11.582h-1.839V7.984z",
			"M104.926,16.025h1.824v2.037v0.623c0,0.861-0.198,1.469-0.593,1.824c-0.406,0.365-1.12,0.547-2.143,0.547c-1.003,0-1.713-0.182-2.128-0.547c-0.416-0.354-0.624-0.978-0.624-1.87v-0.577V9.307V8.684c0-0.892,0.203-1.51,0.608-1.854
				c0.385-0.344,1.089-0.517,2.112-0.517c0.689,0,1.236,0.076,1.642,0.228c0.415,0.172,0.704,0.426,0.866,0.76c0.172,0.365,0.259,0.841,0.259,1.429v0.578v4.681h-3.663v5.396h1.839v-3.359z M104.926,7.984h-1.839v4.377h1.839V7.984z",
			"M108.485,20.903V0.156h1.839v20.747h-1.839z",
			"M112.148,20.903V0.156h1.839v20.747h-1.839z",
			"M121.205,8.714v0.593v8.755v0.623c0,0.872-0.203,1.479-0.608,1.824c-0.405,0.365-1.115,0.547-2.127,0.547c-1.034,0-1.749-0.182-2.143-0.547c-0.406-0.344-0.608-0.967-0.608-1.87v-0.577V9.307V8.714c0-0.517,0.045-0.912,0.137-1.186
				c0.07-0.253,0.232-0.481,0.486-0.684c0.476-0.354,1.18-0.532,2.112-0.532c1.023,0,1.738,0.172,2.143,0.517c0.405,0.345,0.608,0.973,0.608,1.885z M119.381,7.984h-1.839v11.399h1.839V7.984z",
			"M130.157,6.469h1.839v11.612v0.638c-0.01,0.791-0.223,1.378-0.638,1.763c-0.416,0.385-1.054,0.577-1.915,0.577c-0.852,0-1.535-0.228-2.052-0.684c-0.527,0.456-1.206,0.684-2.037,0.684c-1.672,0-2.508-0.78-2.508-2.34v-0.638V6.469h1.824v12.919h1.839
				V6.469h1.824v12.919h1.824V6.469z",
			"M139.125,9.307v1.216H137.3V7.984h-1.839v4.377h1.201h0.456c0.709,0,1.221,0.157,1.535,0.471c0.314,0.314,0.471,0.806,0.471,1.474v0.623v3.131v0.623c0,0.861-0.198,1.469-0.593,1.824c-0.406,0.365-1.12,0.547-2.143,0.547
				c-1.003,0-1.713-0.182-2.128-0.547c-0.416-0.354-0.624-0.978-0.624-1.87v-0.577v-2.037h1.824v3.359h1.839v-5.396h-1.246h-0.411c-0.477,0-0.861-0.061-1.155-0.182c-0.284-0.122-0.497-0.314-0.639-0.578c-0.142-0.263-0.213-0.613-0.213-1.049v-0.578V9.307V8.684
				c0-0.892,0.203-1.51,0.608-1.854c0.385-0.344,1.089-0.517,2.112-0.517c0.689,0,1.236,0.076,1.642,0.228c0.415,0.172,0.704,0.426,0.866,0.76c0.172,0.365,0.259,0.841,0.259,1.429v0.578z"
			];


my $scene1 = [
	[    0, NEW, 102,	"spline1",	{ paths => $paths, trails => 0, alpha => 0.5, x => -0.8, y => 0.2, size => 0.012 }	,					"Spline"	],
	[ 1000,	FLT, 100,	"spline1",	{ trails => 400, alpha => 1, x => -1, size => 0.014 }			],
];

my $data;
my $size = 512;
my $hsize = 256;
my ($x, $y);
my $PI = 3.1415926535;

for($y=0; $y < $size; $y++) {
	for($x=0; $x < $size; $x++) {
		$c = atan2($y-($hsize),$x-($hsize));

		$c = $c / (2*$PI) + (sqrt(($x-$hsize)**2 + ($y-$hsize)**2) / 400);
		$c *= 256 * 4;

		if($c % 256 > 127) {
			$data .= pack("CCCC",0, 255, 0, 255);
		} else {
			$data .= pack("CCCC",0, 0, 255, 255);
		}
	}
} 

my $scene2 = [
#	[    0, NEW, 102,	"im1",	{ image => "image.jpg", x => 0, y => 0, size => 1, alignv => 0, alignh => 0, alpha => 0.5, rot => 0 },	"Image"	],
	[    0, NEW, 105,	"im3",	{ image => "flower1.png", x => .2, y => .1, size => 1, alignv => 1, alignh => 1, alpha => 1, rot => 0 },	"Image"	],
#	[    0, NEW, 105,	"im4",	{ image => "flower2.png", x => .3, y => .5, size => 1, alignv => 1, alignh => 1, alpha => .5, rot => 0 },	"Image"	],
#	[    0, NEW, 102,	"im2",	{ imagedata => $data, width => $size, height => $size, x => 0, y => 0, size => 3.33, alignv => 1, alignh => 1, alpha => 0.5, rot => 0 },	"Image"	],
#	[ 5000,	FLT, 100,	"im1",	{ size => 1, x => -1, y => 1, alpha => 1, rot => 180 }			],
	[ 5000,	FLT, 100,	"im3",	{ rot => 360, size => 2 }			],
#	[ 5000,	FLT, 100,	"im4",	{ rot => -360 }			],
	[ 10000, FLT, 100,	"im3",	{ rot => 360, size => 1 }			],
];

my $scene3 = [
	[     0, NEW, 102, "part1",	{ angle => 90, randomness => 0, speed => 90 }, "Particle" ],
	[  1000, NEW, 100, "im2",	{ image => "spiral", imagedata => $data, width => $size, height => $size, x => 0, y => 0, size => 3.33, alignv => 1, alignh => 1, alpha => 0.5, rot => 0 }, "Image" ],
	[     0, NEW, 102, "spline1",	{ paths => $paths, trails => 0, alpha => 0.5, x => -0.8, y => 0.2, size => 0.012 } , "Spline" ],
	[  1000, FLT, 100, "spline1",	{ trails => 400, alpha => 1, x => -1, size => 0.014 } ],
	[ 15000, FLT, 102, "part1",	{ angle => 15, randomness => 30, speed => 20 } ],
	[ 25000, FLT, 102, "part1",	{ angle => 30, randomness => 0, speed => 10 } ],
	[ 15000, FLT, 100, "im2",	{ rot => 360*4 } ],
];

my $scene4 = [
	[     0, NEW, 102, "part1",	{ angle => 90, randomness => 0, speed => 90 }, "Particle" ],
	[     0,    NEW, 102,	"qgrid1",	{ r1 => 1, g1=> 0, b1=> 1, r2 => 1, g2 => 1, b2 => 0, speed => 4 },	"QGrid"	],
	[  5000,	FLT, 102,	"qgrid1",	{ r1 => 1, g1=> 0, b1=> 0, r2 => 0, g2 => 0, b2 => 1, speed => 0 }			],
	[  10000,	FLT, 102,	"qgrid1",	{ r1 => 1, g1=> 1, b1=> 0, r2 => 0, g2 => 1, b2 => 1, speed => 4 }			],
	[  15000,	FLT, 102,	"qgrid1",	{ r1 => 0, g1=> 1, b1=> 1, r2 => 1, g2 => 0, b2 => 1, speed => 0 }			],
];

my $scene5 = [
	[     0,    NEW, 100, "model1",	{ fname => "models/eek.3ds", px => .0, py => -2.0, pz => 0.0, rx => 0.0, ry => 0.0, rz => 0.0, cx => 0, cy => 0, cz => -8.0 }, "Model" ],
	[     0,	NEW, 102,	"part1",	{ angle => 90, randomness => 0, speed => 90 }, "Particle" ],
	[     0,    NEW, 102,	"qgrid1",	{ r1 => 1, g1=> 0, b1=> 1, r2 => 1, g2 => 1, b2 => 0, speed => 10 },	"QGrid"	],
	[  5000,	FLT, 102,	"qgrid1",	{ r1 => 1, g1=> 0, b1=> 0, r2 => 0, g2 => 0, b2 => 1, speed => 20 }			],
	[   5000,   NEW, 105,	"im1",	{ image => "squirrel.png", x => 0, y => 0, size => 2, alignv => 1, alignh => 1, alpha => 0, rot => 0 },	"Image"	],
	[   5500,   SET, 105,	"im1",	{ alpha => 1 }	],
	[   6000,   FLT, 105,	"im1",	{ alpha => 0 }	],
	[   6500,   FLT, 105,	"im1",	{ alpha => 1 }	],
	[   7000,   FLT, 105,	"im1",	{ alpha => 0 }	],
	[   7500,   FLT, 105,	"im1",	{ alpha => 1 }	],
	[   8000,   FLT, 105,	"im1",	{ alpha => 0 }	],
	[   8500,   FLT, 105,	"im1",	{ alpha => 1 }	],
	[   9000,   FLT, 105,	"im1",	{ alpha => 0 }	],
	[   9500,   FLT, 105,	"im1",	{ alpha => 1 }	],
	[  10000,   FLT, 105,	"im1",	{ alpha => 0 }	],
	[  10000,	FLT, 102,	"qgrid1",	{ r1 => 1, g1=> 1, b1=> 0, r2 => 0, g2 => 1, b2 => 1, speed => 10 }			],
	[  16000,	FLT, 102,	"qgrid1",	{ r1 => 0, g1=> 1, b1=> 1, r2 => 1, g2 => 0, b2 => 1, speed => 20 }			],
	[ 16000,	FLT, 102, "part1",	{ angle => 15, randomness => 30, speed => 20 } ],
	[ 16000,    FLT, 100, "model1", { ry => 360.0, rz => 253 }, ],
];

my $scene6 = [
	[     0,    NEW, 100, "orbit1",	{  }, "Orbit" ],
	[ 25000,    FLT, 100, "orbit1", {  } ],
];

my $intro = [
	[     0, NEW, 102, "spline1",	{ paths => $paths, trails => 0, alpha => 0.5, x => -0.8, y => 0.2, size => 0.012 } , "Spline" ],
	[  2000, FLT, 100, "spline1",	{ trails => 600, alpha => 1, x => -0.85, size => 0.0125 } ],
	[  4500, FLT, 100, "spline1",	{ } ],
	[  5000, FLT, 100, "spline1",	{ alpha => 0 } ],
];

my $gridfast = [
	[     0,    NEW, 102,	"qgrid1",	{ r1 => 1, g1=> 0, b1=> 1, r2 => 1, g2 => 1, b2 => 0, speed => 15 },	"QGrid"	],
	[  5000,	FLT, 102,	"qgrid1",	{ r1 => 1, g1=> 0, b1=> 0, r2 => 0, g2 => 0, b2 => 1, speed => 15 }			],
];

my $partfast = [
	[     0, NEW, 102, "part1",	{ angle => 90, randomness => 0, speed => 90 }, "Particle" ],
	[  3000, FLT, 102, "part1",	{ angle => 15, randomness => 30, speed => 40 } ],
];

my $spiralfast = [
	[  0000, NEW, 100, "im1",	{ image => "spiral", imagedata => \$data, width => $size, height => $size, x => 0, y => 0, size => 3.33, alignv => 1, alignh => 1, alpha => 1, rot => 0 }, "Image" ],
	[  0000, NEW, 101, "im2",	{ image => "spiral2", imagedata => \$data, width => $size, height => $size, x => 0, y => 0, size => 3.33, alignv => 1, alignh => 1, alpha => 0.5, rot => 0 }, "Image" ],
	[  5000, FLT, 100, "im1",	{ rot => 360*2 } ],
	[  5000, FLT, 100, "im2",	{ rot => -360*2 } ]
];

my $modelfast = [
	[  0,		NEW, 100, "model1",	{ fname => "models/eek.3ds", px => 1, py => -2.0, pz => 0, rx => 0.0, ry => 0.0, rz => 0.0, cx => 5, cy => 5, cz => -1.0 }, "Model" ],
	[  5000,    FLT, 100, "model1", { ry => 360.0 }, ],
];

my $orbitfast = [
	[     0,    NEW, 100, "orbit1",	{  }, "Orbit" ],
	[ 25000,    FLT, 100, "orbit1", {  } ],
];

my $credits = [
	[     0, NEW, 102,	"im2",	{ image => "spiral", imagedata => \$data, width => $size, height => $size, x => 0, y => 0, size => 3.33, alignv => 1, alignh => 1, alpha => 0, rot => 0 },	"Image"	],
	[   500, FLT, 102,	"im2",	{ alpha => 1, rot => 40 }	],
	[  1000, NEW, 200, "flowers", { alpha => 0, image => "corso.png", size => 1, x => -.7, y => -.2, alignv => 1, alignh => 1 }, "Image" ],
	[  1500, FLT, 200, "flowers", { alpha => 1} ],
	[  3000, NEW ,205, "code", { alpha => 0, image => "code.png", size => 1, x => -.4, y => 0, alignv => 1, alignh => 0 }, "Image" ],
	[  3300, FLT ,205, "code", { alpha => 1 } ],
	[  4000, NEW ,205, "sjonny", { alpha => 0, image => "sjonny.png", size => 1, x => .1, y => 0, alignv => 1, alignh => 0 }, "Image" ],
	[  4300, FLT ,205, "sjonny", { alpha => 1 } ],
	[  5300, FLT ,205, "sjonny", { alpha => 1 } ],
	[  5600, FLT ,205, "sjonny", { alpha => 0 } ],
	[  6000, NEW ,205, "sharky", { alpha => 0, image => "sharky.png", size => 1, x => .1, y => 0, alignv => 1, alignh => 0 }, "Image" ],
	[  6300, FLT ,205, "sharky", { alpha => 1 } ],
	[  7300, FLT ,205, "sharky", { alpha => 1 } ],
	[  7600, FLT ,205, "sharky", { alpha => 0 } ],
	[  7300, FLT ,205, "code", { alpha => 1 } ],
	[  7600, FLT ,205, "code", { alpha => 0 } ],
	[  8000, NEW ,205, "music", { alpha => 0, image => "music.png", size => 1, x => -.4, y => 0, alignv => 1, alignh => 0 }, "Image" ],
	[  8300, FLT ,205, "music", { alpha => 1 } ],
	[  9000, NEW ,205, "mlein", { alpha => 0, image => "mlein.png", size => 1, x => .2, y => 0, alignv => 1, alignh => 0 }, "Image" ],
	[  9300, FLT ,205, "mlein", { alpha => 1 } ],
	[ 10300, FLT ,205, "mlein", { alpha => 1 } ],
	[ 10600, FLT ,205, "mlein", { alpha => 0 } ],
	[ 10300, FLT ,205, "music", { alpha => 1 } ],
	[ 10600, FLT ,205, "music", { alpha => 0 } ],
	[ 11000, NEW ,205, "choreo", { alpha => 0, image => "choreo.png", size => 1, x => -.4, y => 0, alignv => 1, alignh => 0 }, "Image" ],
	[ 11300, FLT ,205, "choreo", { alpha => 1 } ],
	[ 12000, NEW ,205, "thomas", { alpha => 0, image => "thomas.png", size => 1, x => .6, y => 0, alignv => 1, alignh => 0 }, "Image" ],
	[ 12300, FLT ,205, "thomas", { alpha => 1 } ],
	[ 13300, FLT ,205, "thomas", { alpha => 1 } ],
	[ 13600, FLT ,205, "thomas", { alpha => 0 } ],
	[ 13300, FLT ,205, "choreo", { alpha => 1 } ],
	[ 13600, FLT ,205, "choreo", { alpha => 0 } ],
	[ 13300, FLT ,205, "flowers", { alpha => 1 } ],
	[ 13600, FLT ,205, "flowers", { alpha => 0 } ],
	[ 14000, FLT, 102,	"im2",	{ rot => 360 * 4 }],
];

my $orbit = [
	[     0,    NEW, 100, "orbit1",	{  }, "Orbit" ],
	[ 36000,    FLT, 100, "orbit1", {  } ],
];

my $model = [
	[  0000, NEW, 100, "im1",	{ image => "spiral", imagedata => \$data, width => $size, height => $size, x => 0, y => 0, size => 3.33, alignv => 1, alignh => 1, alpha => 1, rot => 0 }, "Image" ],
	[     0,    NEW, 100, "model1",	{ fname => "models/paddop.3ds", px => 1, py => -2.0, pz => -.4, rx => 0.0, ry => 0.0, rz => 0.0, cx => 0, cy => 5, cz => -5.0 }, "Model" ],
	[     0,    NEW, 100, "model2",	{ fname => "models/paddop.3ds", px => .8, py => -2.0, pz => .9, rx => 0.0, ry => 0.0, rz => 0.0, cx => 0, cy => 5, cz => -5.0 }, "Model" ],
	[     0,    NEW, 100, "model3",	{ fname => "models/paddop.3ds", px => -.9, py => -2.0, pz => -1.2, rx => 0.0, ry => 0.0, rz => 0.0, cx => 0, cy => 5, cz => -5.0 }, "Model" ],
	[     0,    NEW, 100, "model4",	{ fname => "models/paddorood.3ds", px => -1.1, py => -2.0, pz => .2, rx => 0.0, ry => 0.0, rz => 0.0, cx => 0, cy => 5, cz => -5.0 }, "Model" ],
	[  11000,    FLT, 100, "model1", { ry => 360.0*2 }, ],
	[  11000,    FLT, 100, "model2", { ry => 360.0*2 }, ],
	[  11000,    FLT, 100, "model3", { ry => 360.0*2 }, ],
	[  11000,    FLT, 100, "model4", { ry => 360.0*2 }, ],
	[  11000,    NEW, 100, "model1",	{ fname => "models/zonnebloem.stap4.3ds", px => 1, py => -2.0, pz => -.4, rx => 0.0, ry => 0.0, rz => 0.0, cx => 0, cy => 5, cz => -5.0 }, "Model" ],
	[  11000,    NEW, 100, "model2",	{ fname => "models/plantje.3ds", px => .8, py => -2.0, pz => .9, rx => 0.0, ry => 0.0, rz => 0.0, cx => 0, cy => 5, cz => -5.0 }, "Model" ],
	[  11000,    NEW, 100, "model3",	{ fname => "models/eend.stap3.3ds", px => -.9, py => 0, pz => -1.2, rx => 0.0, ry => 0.0, rz => 0.0, cx => 0, cy => 5, cz => -5.0 }, "Model" ],
	[  11000,    NEW, 100, "model4",	{ fname => "models/plantje.3ds", px => -1.1, py => -2.0, pz => .2, rx => 0.0, ry => 0.0, rz => 0.0, cx => 0, cy => 5, cz => -5.0 }, "Model" ],
	[  22000,    FLT, 100, "model1", { ry => 360.0*2 }, ],
	[  22000,    FLT, 100, "model2", { ry => 360.0*2 }, ],
	[  22000,    FLT, 100, "model3", { ry => 360.0*2 }, ],
	[  22000,    FLT, 100, "model4", { ry => 360.0*2 }, ],
	[  22000, FLT, 100, "im1",	{ rot => -360*5 } ]
];

my $model2 = [
	[  0000, NEW, 100, "im1",	{ image => "spiral", imagedata => \$data, width => $size, height => $size, x => 0, y => 0, size => 3.33, alignv => 1, alignh => 1, alpha => 1, rot => 0 }, "Image" ],
	[     0,    NEW, 100, "model1",	{ fname => "models/castle.step4.3ds", px => 1, py => -2.0, pz => -.4, rx => 0.0, ry => 0.0, rz => 0.0, cx => 50, cy => 5, cz => -5.0 }, "Model" ],
	[  15000,    FLT, 100, "model1", {  cx => -50}, ],
	[  15000,    NEW, 100, "model1",	{ fname => "models/fee.stap2.3ds", px => 1, py => -2.0, pz => -.4, rx => 0.0, ry => 0.0, rz => 0.0, cx => 50, cy => 5, cz => -5.0 }, "Model" ],
	[  30000,    FLT, 100, "model1", {  ry => 720, cx => -50}, ],
	[  30000, FLT, 100, "im1",	{ rot => -360*5 } ]
];

my $model3 = [
	[     0,    NEW, 100, "model1",	{ fname => "models/fish.3ds", px => 1, py => -2.0, pz => -.4, rx => 0.0, ry => 0.0, rz => 0.0, cx => 50, cy => 5, cz => -5.0 }, "Model" ],
	[  15000,    FLT, 100, "model1", {  cx => -50}, ],
];

my $bloemetjes = [
	[    0, NEW, 100,	"im01",	{ image => "flower1.png", x => .7, y => .8, size => .8, alignv => 1, alignh => 1, alpha => 1, rot => 0 },	"Image"	],
	[ 1000, NEW, 101,	"im02",	{ image => "flower2.png", x => -.5, y => .3, size => .6, alignv => 1, alignh => 1, alpha => 1, rot => 100 },	"Image"	],
	[ 2000, NEW, 102,	"im03",	{ image => "flower1.png", x => .1, y => -.5, size => 1, alignv => 1, alignh => 1, alpha => 1, rot => 160 },	"Image"	],
	[ 3000, NEW, 103,	"im04",	{ image => "flower2.png", x => -.8, y => -.2, size => .7, alignv => 1, alignh => 1, alpha => 1, rot => 40 },	"Image"	],
	[ 4000, NEW, 104,	"im05",	{ image => "flower1.png", x => .4, y => .1, size => .6, alignv => 1, alignh => 1, alpha => 1, rot => 190 },	"Image"	],
	[ 5000, NEW, 105,	"im06",	{ image => "flower2.png", x => -.6, y => .9, size => 1, alignv => 1, alignh => 1, alpha => 1, rot => 80 },	"Image"	],
	[ 5500, NEW, 106,	"im07",	{ image => "flower1.png", x => .8, y => -.4, size => .8, alignv => 1, alignh => 1, alpha => 1, rot => 20 },	"Image"	],
	[ 6000, NEW, 107,	"im08",	{ image => "flower2.png", x => -.9, y => -.7, size => .6, alignv => 1, alignh => 1, alpha => 1, rot => 240 },	"Image"	],
	[ 6500, NEW, 108,	"im09",	{ image => "flower1.png", x => .7, y => .3, size => .9, alignv => 1, alignh => 1, alpha => 1, rot => 140 },	"Image"	],
	[ 7000, NEW, 109,	"im10",	{ image => "flower2.png", x => -.1, y => .4, size => .8, alignv => 1, alignh => 1, alpha => 1, rot => 200 },	"Image"	],
	[ 7200, NEW, 110,	"im11",	{ image => "flower1.png", x => .7, y => -.6, size => .7, alignv => 1, alignh => 1, alpha => 1, rot => 280 },	"Image"	],
	[ 7400, NEW, 111,	"im12",	{ image => "flower2.png", x => -.6, y => .9, size => .6, alignv => 1, alignh => 1, alpha => 1, rot => 60 },	"Image"	],
	[ 7600, NEW, 112,	"im13",	{ image => "flower1.png", x => .2, y => -.2, size => .6, alignv => 1, alignh => 1, alpha => 1, rot => 180 },	"Image"	],
	[ 7800, NEW, 113,	"im14",	{ image => "flower2.png", x => -.3, y => -.5, size => .9, alignv => 1, alignh => 1, alpha => 1, rot => 260 },	"Image"	],
	[ 8000, NEW, 114,	"im15",	{ image => "flower1.png", x => .2, y => .9, size => .5, alignv => 1, alignh => 1, alpha => 1, rot => 120 },	"Image"	],

	[   9000,   NEW, 109,	"im1",	{ image => "happy.png", x => 0, y => 0, size => 2, alignv => 1, alignh => 1, alpha => 0, rot => 0 },	"Image"	],
	[   9500,   SET, 109,	"im1",	{ alpha => 1 }	],
	[  10000,   FLT, 109,	"im1",	{ alpha => 0 }	],
	[  10500,   FLT, 109,	"im1",	{ alpha => 1 }	],
	[  11000,   FLT, 109,	"im1",	{ alpha => 0 }	],
	[  11500,   FLT, 109,	"im1",	{ alpha => 1 }	],
	[  12000,   FLT, 109,	"im1",	{ alpha => 0 }	],
	[  12500,   FLT, 109,	"im1",	{ alpha => 1 }	],
	[  13000,   FLT, 109,	"im1",	{ alpha => 0 }	],
	[  13500,   FLT, 109,	"im1",	{ alpha => 1 }	],
	[  14000,   FLT, 109,	"im1",	{ alpha => 0 }	],

	[ 20000,	FLT, 100,	"im01",	{ rot => 360 }			],
	[ 20000,	FLT, 100,	"im02",	{ rot => -360, size => .8 }			],
	[ 20000,	FLT, 100,	"im03",	{ rot => 360 }			],
	[ 20000,	FLT, 100,	"im04",	{ rot => -360, size => .8 }			],
	[ 20000,	FLT, 100,	"im05",	{ rot => 360 }			],
	[ 20000,	FLT, 100,	"im06",	{ rot => -360, size => .8 }			],
	[ 20000,	FLT, 100,	"im07",	{ rot => 360 }			],
	[ 20000,	FLT, 100,	"im08",	{ rot => -360, size => .8 }			],
	[ 20000,	FLT, 100,	"im09",	{ rot => 360 }			],
	[ 20000,	FLT, 100,	"im10",	{ rot => -360, size => .8 }			],
	[ 20000,	FLT, 100,	"im11",	{ rot => 360 }			],
	[ 20000,	FLT, 100,	"im12",	{ rot => -360, size => .8 }			],
	[ 20000,	FLT, 100,	"im13",	{ rot => 360 }			],
	[ 20000,	FLT, 100,	"im14",	{ rot => -360, size => .8 }			],
	[ 20000,	FLT, 100,	"im15",	{ rot => 360 }			],
	[ 20000, NEW, 100, "im1",	{ size => 5 }, "Image" ],
];

my $particles = [
	[     0, NEW, 102, "part1",	{ angle => 90, randomness => 0, speed => 90 }, "Particle" ],
	[     0, NEW, 102, "spline1",	{ paths => $paths, trails => 0, alpha => 0.5, x => -0.8, y => 0.2, size => 0.012 } , "Spline" ],
	[  1000, FLT, 100, "spline1",	{ trails => 400, alpha => 1, x => -1, size => 0.014 } ],
	[ 15000, FLT, 102, "part1",	{ angle => 15, randomness => 30, speed => 20 } ],
	[ 30000, FLT, 102, "part1",	{ angle => 30, randomness => 0, speed => 10 } ],
];

my $end = [
	[  0, NEW, 200, "im1", { alpha => 0, image => "fm.jpg", size => 3, x => 0, y => 0, alignv => 1, alignh => 1 }, "Image" ],
	[ 1000, FLT, 200, "im1", { alpha => 1} ],
	[ 4000, FLT, 200, "im1", { alpha => 1} ],
];

my $main = [
	[	0,		NEW, 100,	"p1",		{ program => $intro } , "Program" ],
	[ 5500,		NEW, 100,	"p1",		{ program => $gridfast }, "Program" ],
	[ 7000,		NEW, 100,	"p1",		{ program => $partfast }, "Program" ],
	[ 8700,		NEW, 100,	"p1",		{ program => $spiralfast }, "Program" ],
	[ 10400,	NEW, 100,	"p1",		{ program => $modelfast }, "Program" ],
	[ 12000,	NEW, 100,	"p1",		{ program => $orbitfast }, "Program" ],
	[ 13251,	NEW, 100,	"p1",		{ program => $partfast }, "Program" ],
	[ 14303,	NEW, 100,	"p1",		{ program => $spiralfast }, "Program" ],
	[ 15248,	NEW, 100,	"p1",		{ program => $gridfast }, "Program" ],
	[ 16000,	DEL, 100,	"p1",		{ } ],
	[ 16300,	NEW, 100,	"p1",		{ program => $credits }, "Program" ],
	[ 30500,	NEW, 100,	"p1",		{ program => $orbit }, "Program" ],
	[ 43200,	NEW, 100,	"p1",		{ program => $model }, "Program" ],
	[ 65500,	NEW, 100,	"p1",		{ program => $model2 }, "Program" ],
	[ 95500,	NEW, 100,	"p1",		{ program => $scene5 }, "Program" ],
	[ 111500,	NEW, 100,	"p1",		{ program => $bloemetjes }, "Program" ],
	[ 131000,	NEW, 100,	"p1",		{ program => $particles}, "Program" ],
	[ 160000,	NEW, 100,	"p1",		{ program => $end}, "Program" ],
	[ 163000,	FLT, 100, "dummy", {} , ],
];
 
sub main {
	my ($x, $y, $dc) = @_;
	my $msec = 0;
	my $finished = 0;
	my $space = 0;

	print "Setting up main Program\n";

	my $p = new Program($dc);

	$p->SetParams({program => $main});

	print "Starting mp3 stream ..\n";
	OpenGL::glStartSound();

	print "Starting render loop with ..\n";

	while(!$finished) {
		OpenGL::glClear();

		$finished = $p->Render(OpenGL::glGetSoundPos()+0);

		OpenGL::SwapBuffers();

		OpenGL::glPumpEvents();
		if(OpenGL::glSpacePressed()) {
			if(!$space) {
				print "Pos: " . OpenGL::glGetSoundPos() . "\n";
				$space = 1;
			}
		} else {
			$space = 0;
		}
		if(OpenGL::glEscPressed()) {
			$finished = 1;
		}
	}
	
	return 0;
}
