// Description: Test shareds for learning purposes
// Author: Isaac Lascasas

float4x4	matWorldViewProj;
float4x4	matWorld;
float4x4	matInvTransposeWorld;
float4		vecLightDir;
texture		txScene;

struct VS_OUTPUT
	{
	float4 Pos: POSITION;
	};
	
struct VS_OUTPUT2
	{
    float4 Pos		: POSITION;
    float3 Light	: TEXCOORD0;
    float3 Norm		: TEXCOORD1;
	};

////////////////////////
// GLOBAL ILUMINATION //
////////////////////////

VS_OUTPUT VS_GlobalIlumination( float4 Pos: POSITION )
	{
	VS_OUTPUT Out = (VS_OUTPUT) 0;
	Out.Pos = mul(Pos, matWorldViewProj); // transform Position
	return Out;
	}

float4 PS_GlobalIlumination() : COLOR
	{
	return float4(0.5, 0.075, 0.075, 1.0);
	}

//////////////////////////////
// SIMPLE DIFFUSE LIGHTNING //
//////////////////////////////

VS_OUTPUT2 VS_DiffuseLightning(float4 Pos : POSITION, float3 Normal : NORMAL)
	{
	VS_OUTPUT2 Out = (VS_OUTPUT2)0;
	Out.Pos = mul(Pos, matWorldViewProj);           // transform Position
	Out.Light = vecLightDir;                        // output light vector
	Out.Norm = normalize(mul(matInvTransposeWorld, Normal));    // transform Normal and normalize it
	return Out;
	}

float4 PS_DiffuseLightning(float3 Light: TEXCOORD0, float3 Norm : TEXCOORD1) : COLOR
	{
	float4 diffuse = { 1.0f, 0.0f, 0.0f, 1.0f};
	float4 ambient = {0.1, 0.0, 0.0, 1.0};
	return ambient + diffuse * saturate(dot(Light, Norm));
	}

//////////////////////////
// DIFFUSE WITH TEXTURE //
//////////////////////////

sampler  g_samScene =
sampler_state
{
    Texture = <txScene>;
    MinFilter = Linear;
    MagFilter = Linear;
    MipFilter = Point;
};

struct VS_OUTPUT3
	{
    float4 Pos		: POSITION;
    float3 Light	: TEXCOORD2;
    float3 Norm		: TEXCOORD1;
	float2 Tex		: TEXCOORD0;
	};

VS_OUTPUT3 VS_DiffuseWithTexture(float4 Pos : POSITION, float3 Normal : NORMAL,float2 Tex : TEXCOORD0)
	{
	VS_OUTPUT3 Out = (VS_OUTPUT3)0;
    Out.Tex = Tex;	
	Out.Pos = mul(Pos, matWorldViewProj);           // transform Position
	Out.Light = vecLightDir;                        // output light vector
	Out.Norm = normalize(mul(Normal, matInvTransposeWorld));    // transform Normal and normalize it
	return Out;
	}

float4 PS_DiffuseWithTexture(float3 Light: TEXCOORD0, float3 Norm : TEXCOORD1, float2 Tex : TEXCOORD0) : COLOR
	{
	float4 diffuse = { 1.0f, 1.0f, 1.0f, 1.0f};
	float4 ambient = {0.0, 0.0, 0.0, 0.0};
	return ambient + tex2D( g_samScene, Tex );//saturate(dot(Light, Norm)) * tex2D( g_samScene, Tex );
	}

////////////////
// TECHNIQUES //
////////////////

technique GlobalIlumination
	{
    pass P0
		{          
        VertexShader = compile vs_1_1 VS_GlobalIlumination();
        PixelShader = compile ps_1_1 PS_GlobalIlumination();
		}
	}

technique DiffuseLightning
	{
    pass P0
		{          
        VertexShader = compile vs_1_1 VS_DiffuseLightning();
        PixelShader = compile ps_1_4 PS_DiffuseLightning();
		}	
	}
	
technique DiffuseWithTexture
	{
    pass P0
		{          
        VertexShader = compile vs_1_1 VS_DiffuseWithTexture();
        PixelShader = compile ps_1_4 PS_DiffuseWithTexture();
		}	
	}	