/*  Tools
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#ifndef PSYS_H
#define PSYS_H

#include "common.h"

namespace Tools
{
	class Particle {
	public:
		Particle();
		
		bool active;
		float life;
		float fade;
		float r, g, b;		// Color
		float sx, sy, sz;	// Starting position
		float x, y, z;		// Current position
		float oldx[256];
		float oldy[256];
		float oldz[256];
		float xd, yd, zd;	// Direction/Speed
		float xg, yg, zg;	// Gravity
	};
	
	class PSys { 
	public:
		PSys();
	protected:
		void Update(bool xd, bool yd, bool zd, float move, float distance, float dlife);
		int m_nParticles;
		Particle* m_pParticles;
		int m_nOld;
	};
}

#endif
