/*  xa-004: Beatbox invitro 
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */ 

#include "scene4.h"
#include <vector>

using namespace std;

// Scene end time
#define END 41000

namespace Scene
{			
	Scene4::~Scene4()
	{

	}
	
	void Scene4::EnterScene()
	{	
		glShadeModel(GL_SMOOTH);
		glEnable(GL_DEPTH_TEST);
		glDepthFunc(GL_LEQUAL);
		
		glClearDepth(1);
		glClearColor(0.0, 0.0, 0.0, 0);
		glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE);
		
		GLfloat ratio = (GLfloat)4/3;
		glViewport(0, 0, m_pMVideo->GetWidth(), m_pMVideo->GetHeight());
		
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		gluPerspective(45, ratio, 1, 100);
    
    	glMatrixMode(GL_MODELVIEW);
    	glLoadIdentity();
		
		GLfloat m_LightAmbient[4];
		GLfloat m_LightDiffuse[4];
		GLfloat m_LightPosition[4];
		m_LightAmbient[0] = 0;
		m_LightAmbient[1] = 0;
		m_LightAmbient[2] = 0;
		m_LightAmbient[3] = 0;
		
		m_LightDiffuse[0] = 0;
		m_LightDiffuse[1] = 0;
		m_LightDiffuse[2] = 0;
		m_LightDiffuse[3] = 0;
		
		m_LightPosition[0] = 0;
		m_LightPosition[1] = 0;
		m_LightPosition[2] = 1;
		m_LightPosition[3] = 1;
		
		glLightfv(GL_LIGHT1, GL_AMBIENT, m_LightAmbient);
		glLightfv(GL_LIGHT1, GL_DIFFUSE, m_LightDiffuse);
		glLightfv(GL_LIGHT1, GL_POSITION, m_LightPosition);
		glLightModelfv(GL_LIGHT_MODEL_AMBIENT, m_LightAmbient);
		
		/*GLfloat ambient2[] = { 0, 0, 0.00, 0};
		GLfloat diffuse2[] = { 0, 0, 0.08, 0};
		glLightfv(GL_LIGHT2, GL_AMBIENT, ambient2);
		glLightfv(GL_LIGHT2, GL_DIFFUSE, diffuse2);
		glLightfv(GL_LIGHT2, GL_POSITION, m_LightPosition);*/
				
		glEnable(GL_FOG);
		GLfloat fogcolor[4] = {0, 0, 0, 0};
		glFogi(GL_FOG_MODE, GL_EXP);
		glFogfv(GL_FOG_COLOR, fogcolor);
		glFogf(GL_FOG_DENSITY, 0.01);
		glHint(GL_FOG_HINT, GL_DONT_CARE);
		glFogf(GL_FOG_START, 1.0);
		glFogf(GL_FOG_END, 10.0);
		
	} 
	
	void Scene4::ExitScene()
	{
		glDisable(GL_FOG);
	}
	
	int Scene4::LoadScene()
	{	
#ifdef DEBUG
		m_identity = "Demo";
#endif
		
		return 0;
	} 
	
	int Scene4::DrawFrame(long time, float move)
	{
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
		glLoadIdentity();
		
		static DS::Model* pThroneRoom = DS::MModel::GetPointer()->GetModel("throneroom_v2");
		
		static float blackout = 1;
		EVENT(END-1000, END)
		{
			if(blackout > 0)
				Change(blackout, move, -1);
			else
				blackout = 0;
			
			GLfloat diffuse[] = { blackout*0.05, blackout*0.03, blackout*0.03, 0 };
			glLightfv(GL_LIGHT1, GL_DIFFUSE, diffuse);
			GLfloat ambient[] = { blackout*0.2, blackout*0.2, blackout*0.2, 1 };
			glLightModelfv(GL_LIGHT_MODEL_AMBIENT, ambient);
			GLfloat fogcolor[4] = {blackout*1, blackout*.5, blackout*0.1, 1.0};
			glFogfv(GL_FOG_COLOR, fogcolor);	
		}
		
		//glTranslatef(0, 0, -5);
		static int timepos = 0;
		static int total = 47;
		static float scenerot[] = { 30, 20,
								30, 30, 30, 30, 30, 30, 30, 30,
							  	30, 30, 30, 30, 30, 30,
								20, 20, 20, 20, 20, 20, 20, 20,
								20,
								-30, -30, -30, -30, -30, -30, -30, -30,
								-30, -30, -30, -30, -30, -30,
								20, 20, 20, 20, 20, 20, 20, 20,
								20, 20, 20*blackout };
		static float yangle[] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
							  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
							  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
							  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
							  0, 0, 0, 0, 0, 0, 0, 0 };
		static float xv[] = { 0, 0,
								0, 0, 0, 0, 0, 0, 0, 0,
							  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
							  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
							  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
							  0, 0, 0, 0, 0, 0, 0, 0 };
		static float yv[] = { 0, 0,
								-2, -2, -2, -2, -2, -2, -2, -2,
							  	-2, -2, -2, -2, -2, -2,
								0, 0, 0, 0, 0, 0, 0, 0,
								0,
								-2, -2, -2, -2, -2, -2, -2, -2,
								-2, -2, -2, -2, -2, -2,
								0, 0, 0, 0, 0, 0, 0, 0,
								0, 0, 0 };
		static float zv[] = { -10, -20,
							-7, -7, -7, -7, -7, -7, -7, -7,
							-7, -7, -7, -7, -7, -7,
							-20, -20, -20, -20, -20, -20, -20, -20,
							-20, 
							-7, -7, -7, -7, -7, -7, -7, -7,
							-7, -7, -7, -7, -7, -7,
							-20, -20, -20, -20, -20, -20, -20, -20,
							-20,-20, -20
							};
		/*static float zv[] = { -10, -20,
							-16, -14, -12, -10, -8, -6, -4, -2,
							-4, -6, -8, -10, -12,
							-16, -14, -12, -10, -8, -6, -4, -2,
							-10, 
							-16, -14, -12, -10, -8, -6, -4, -2,
							-4, -6, -8, -10, -12,
							-16, -14, -12, -10, -8, -6, -4, -2,
							-10,-10
							};*/
		static float jumptimes[] =
				{ 0, 5000,
				13721, 14284, 14717, 15151, 15584, 15984, 16416, 16850, 18781, 
				19415, 19880, 20113, 20280, 20515, 21079, 21547,
				21979, 22379, 22845, 23278, 23711, 23911, 25644, 27376,
					27975, 28442, 28843, 29275, 29709,
				30141, 30574, 32406, 33105, 33572, 33772, 33971, 34204, 34771, 35238,
				35704, 36103, 36537, 36969, 37369, 37569, END }; //, 39368
		
		if(jumptimes[timepos+1] < time && timepos != total-1)
			timepos++;
											
		static float rotate_room = 390;	
		
		glEnable(GL_TEXTURE_2D);	
				
		EVENT(0, 5000)
		{
			static float whitein = 0;
			if(whitein < 1)
				Change(whitein, move, 0.5);
			else {
				whitein = 1;
			}
			
			GLfloat diffuse[] = { whitein*0.05, whitein*0.03, whitein*0.03, 0 };
			glLightfv(GL_LIGHT1, GL_DIFFUSE, diffuse);
			GLfloat ambient[] = { whitein*0.2, whitein*0.2, whitein*0.2, 1 };
			glLightModelfv(GL_LIGHT_MODEL_AMBIENT, ambient);
			GLfloat fogcolor[4] = {whitein*1, whitein*.5, whitein*0.1, 1.0};
			glFogfv(GL_FOG_COLOR, fogcolor);	
		}
		
		glTranslatef(xv[timepos], yv[timepos], zv[timepos]);
		Change(rotate_room, move, scenerot[timepos]);
		glRotatef(rotate_room, 0, 1, 0);
		glRotatef(yangle[timepos], 0, 1, 0);
		glTranslatef(0, -5, 0);
		glScalef(0.1, 0.1, 0.1);
		
		glEnable(GL_LIGHT1);
		glEnable(GL_LIGHTING);
		pThroneRoom->Draw();
		glDisable(GL_LIGHT1);
		glDisable(GL_LIGHTING);
		
		glEnable(GL_TEXTURE_2D);
		glEnable(GL_BLEND);
		glPushMatrix();
		static Tools::PFire* pFire = new Tools::PFire(1000);
		glPushMatrix();
			glTranslatef(-37, 68, 88);
			glScalef(5, 5, 5);
			glRotatef(-rotate_room, 0, 1, 0);
			pFire->Draw(move, 1);
		glPopMatrix();
		glPushMatrix();
			glTranslatef(-37, 68, -89);
			glScalef(5, 5, 5);
			glRotatef(-rotate_room, 0, 1, 0);
			pFire->Draw(move, 1);
		glPopMatrix();
		glPushMatrix();
			glTranslatef(95, 68, 88);
			glScalef(5, 5, 5);
			glRotatef(-rotate_room, 0, 1, 0);
			pFire->Draw(move, 1);
		glPopMatrix();
		glPushMatrix();
			glTranslatef(95, 68, -89);
			glScalef(5, 5, 5);
			glRotatef(-rotate_room, 0, 1, 0);
			pFire->Draw(move, 1);
		glPopMatrix();
		glDisable(GL_BLEND);
		glPopMatrix();
		
		static float model = 0;
		if(model < 1)
			Change(model, move, 4);
		else
			Change(model, move, 10);
		
		if(model >= 2)
			model = 0;
		
		glPushMatrix();
				static DS::Model* pModels[] = {
					DS::MModel::GetPointer()->GetModel("bbox01"),
					DS::MModel::GetPointer()->GetModel("bbox02")};
				glEnable(GL_TEXTURE_2D);			
			
				glColor3f(blackout, blackout, blackout);
				glPushMatrix();
					glTranslatef(-330, 70, 0);
					glRotatef(-20, 0, 1, 0);
					glRotatef(rotate_room*2, 1, 1, 1);
					glScalef(0.5, 0.5, 0.5);
					pModels[(int)model]->Draw();
				glPopMatrix();
		glPopMatrix();
		glDisable(GL_TEXTURE_2D);
	
		if(time >= END)
			return END_SCENE;
		else
			return CONTINUE;
	}
}
