/*  DS
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#ifndef MVIDEO_H
#define MVIDEO_H

#include "common.h"

namespace DS
{
	class MVideo {
	public:
		~MVideo();
		static void Instance();
		static MVideo* GetPointer();
		void Init(int Width, int Height, int Bpp, bool Fullscreen, const char *Title);
		void Reset(int Width, int Height, bool Fullscreen);
		int GetWidth() { return m_Width; }
		int GetHeight() { return m_Height; }
		void Update();
	protected:
		MVideo();
	private:
		void OpenWindow();
		int m_Width, m_Height, m_Bpp;
		bool m_Fullscreen;
		std::string m_Title;
		static MVideo* m_pInstance;
		SDL_Surface* m_pScreen;
	};
}

#endif
