/*  DS
 *  Copyright (C) Anders Asplund and Joakim Kolsjö 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#include "mtimer.h"

using namespace std;

namespace DS
{
	MTimer::MTimer()
	{
		Starttime = -1;
	}
	
	void MTimer::Instance()
	{
		if(!m_pInstance)
			m_pInstance = new MTimer();
	}
	
	MTimer* MTimer::GetPointer()
	{
		return m_pInstance;
	}
	
	void MTimer::Start()
	{
		Starttime = SDL_GetTicks();
	}
		
	long MTimer::Gettime()
	{
		if(Starttime == -1)
			throw domain_error("You must start the Timer before using it!");
		return (long)(SDL_GetTicks() - Starttime);
	}
	
	void MTimer::Delay(long time)
	{
		SDL_Delay(time);
	}
}
