/*  DS
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#ifndef MSCENE_H
#define MSCENE_H

#include "common.h"
#include "scene.h"
#include "mvideo.h"
#include "mtimer.h"

namespace DS
{	
	class MScene {
	public:
		~MScene();
		static void Instance();
		static MScene* GetPointer();
		int Run(LoadStates* pLoadStates, bool &bThreadActive, bool loop, int loopstart);
		int Load(float &state, bool &active);
		void AddScene(Scene* pScene);
		Scene* GetScene(int number);
	protected:
		MScene();
	private:	
		int Update(bool frames);		
		long m_SceneStart, m_Frametime, m_FpsUpdate, m_Demotime, m_NextScenetime;
		float m_move;
		int m_Frames;
#ifdef DEBUG
		int m_FpsCount;
		int m_TotalFps;
		bool m_SkipScene;
#endif	
		DS::MTimer* m_pMTimer;
		DS::MVideo* m_pMVideo;
		SDL_Event m_SDLEvent;
	
		static MScene *m_pInstance;
	
		// Scene pointers
		std::map <int, Scene *> m_Scene;
	};
}
  
#endif
