/*  Launcher GUI
 *  Copyright (C) Joakim Kolsjö 2004-2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#include "launcher.h"

#if USE_GUI

#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Check_Button.H>
#include <FL/Fl_Menu_Item.H>
#include <FL/Fl_Choice.H>

using namespace std;

namespace DS
{
	// Workaround to make it possible to access window->hide() in cbRun
	Fl_Window* pWindow;
	
	// Workaround for settings
	LauncherConfig* pC;
	
	// Temp escape fix
	bool brun = false;
	
	void cbRun(Fl_Widget *w, void *data)
	{
		pWindow->hide();
		Fl::flush();
		brun = true;
	}
	
	void cbExit(Fl_Widget *w, void *data)
	{
		exit(0);
	}
	
	void cbSound(Fl_Widget *w, void *data)
	{
		if(pC->Sound)
			pC->Sound = false;
		else
			pC->Sound = true;
	}
	
	void cbWindowed(Fl_Widget *w, void *data)
	{
		if(pC->Fullscreen)
			pC->Fullscreen = false;
		else
			pC->Fullscreen = true;
	}
	
	void cbLoop(Fl_Widget *w, void *data)
	{
		if(pC->Loop)
			pC->Loop = false;
		else
			pC->Loop = true;
	}
	
	Launcher::Launcher()
	{
		
	}
	
	Launcher::~Launcher()
	{
		
	}

	void Launcher::Instance()
	{
		if(!m_pInstance)
			m_pInstance = new Launcher();
	}
	
	Launcher* Launcher::GetPointer()
	{
		return m_pInstance;
	}
	
	void cb640(Fl_Widget* muff, void *data)
	{
		pC->width = 640;
		pC->height = 480;
	}
	
	void cb800(Fl_Widget* muff, void *data)
	{
		pC->width = 800;
		pC->height = 600;
	}
	
	void cb1024(Fl_Widget* muff, void *data)
	{
		pC->width = 1024;
		pC->height = 768;
	}
	
	void cb1152(Fl_Widget* muff, void *data)
	{
		pC->width = 1152;
		pC->height = 864;
	}
	
	void Launcher::Run(int argc, char **argv, const char* pWindowTitle, const char* pInfoText, LauncherConfig* pConfig)
	{
		pC = pConfig;
		
		// Create pWindow
		pWindow = new Fl_Window(320, 130);
		pWindow->label(pWindowTitle);
		Fl_Box* pBox = new Fl_Box(0, 0 , 130, 100, pInfoText);
		pBox->labelsize(12); 
		
		// Add choice menu
		Fl_Menu_Item res[] = {
		  {"640x480", 0, cb640},
		  {"800x600", 0, cb800},
		  {"1024x768", 0, cb1024},
		  {"1152x864", 0, cb1152},
		  {0},
		};

		// Add checkboxes
		Fl_Check_Button* pCheckBoxWindow = new Fl_Check_Button(150, 35, 93, 18, "Windowed"); 
		Fl_Check_Button* pCheckBoxSound = new Fl_Check_Button(250, 35, 66, 18, "Music");
		//Fl_Check_Button* pCheckBoxLoop = new Fl_Check_Button(150, 35, 75, 18, "Looping");
	
		// Add menu
		Fl_Choice* pChoiceMenuRes = new Fl_Choice(222, 10, 85, 20, "Resolution");		
		pChoiceMenuRes->copy(res, pWindow);

		// Set values after config
		if(pConfig->Sound)
			pCheckBoxSound->value(1);
		if(!pConfig->Fullscreen)
			pCheckBoxWindow->value(1);
//		if(pConfig->Loop)
//			pCheckBoxLoop->value(1);
		
		// Add buttons
		Fl_Button* pButtonExit = new Fl_Button(150, 90, 60, 30, "Exit");
		Fl_Button* bButtonRun = new Fl_Button(150+60+10, 90, 90, 30, "Run");		
		
		// Set callbacks to be called when clicking
		bButtonRun->when(FL_WHEN_RELEASE);
		pButtonExit->when(FL_WHEN_RELEASE);
		pCheckBoxSound->when(FL_WHEN_RELEASE);
		pCheckBoxWindow->when(FL_WHEN_RELEASE);
		//pCheckBoxLoop->when(FL_WHEN_RELEASE);
		
		// Callbacks
		bButtonRun->callback(cbRun);
		pButtonExit->callback(cbExit);
		pCheckBoxSound->callback(cbSound);
		pCheckBoxWindow->callback(cbWindowed);
		//pCheckBoxLoop->callback(cbLoop);
		
		// Open pWindow
		pWindow->end();
		pWindow->show(argc, argv);
		Fl::run();
		
		// If not "Run" then exit app (temp escape fix)
		if(!brun)
			exit(0);
	}
}

#endif
