#vertexshader

varying vec4 pos;
varying vec3 normal;
varying vec4 color;

void main()
{
	gl_Position = ftransform();
	gl_TexCoord[0] = gl_MultiTexCoord0;
	normal = gl_Normal;
	color = gl_Color;
}

#fragmentshader

varying vec4 pos;
varying vec3 normal;
varying vec4 color;
uniform sampler2D Texture0;

void main()
{

	vec3 lightdir = normalize(vec3(1.0,1.0,1.0));
	vec3 c = (dot(lightdir, normal)+0.5)/1.5 * color.xyz;
	gl_FragColor = vec4(c,1);
}
