// global effect as used by the framework

#include "_shared.fx"

technique tec0 {
	pass P0 {
		ViewTransform = (mView);
		ProjectionTransform = (mProjection);

		// material
        MaterialAmbient   = {1.0, 1.0, 1.0, 1.0}; 
        MaterialDiffuse   = {1.0, 1.0, 1.0, 1.0}; 
        MaterialSpecular  = {1.0, 1.0, 1.0, 1.0}; 
        MaterialPower     = 40.0;
        
        // set up one directional light
        LightType[0]      = DIRECTIONAL;
        LightAmbient[0]   = <vLightAmbient>;
        LightDiffuse[0]   = <vLightDiffuse>;
        LightSpecular[0]  = {0.2, 0.2, 0.2, 1.0}; 
        LightDirection[0] = <vLightDir>;
        LightRange[0]     = 100000.0f;

		LightEnable[0] = True;
        SpecularEnable = False;
		NormalizeNormals = False;

		Lighting = False;

		CullMode = <iCull>;

		// Texture params
		MinFilter[0] = Linear;
		MagFilter[0] = Linear;
		MipFilter[0] = Linear;
		MinFilter[1] = Linear;
		MagFilter[1] = Linear;
		MipFilter[1] = Linear;
	}
}
