      #include "_shared.fx"

// texture
texture tBase;

// world transform
matrix mWorld;

float4 vDiffuse;

float3 vDelta;

struct VS_INPUT {
	float4	pos		: POSITION;
	float3	normal	: NORMAL;
	float2	uv		: TEXCOORD0;
};

struct VS_OUTPUT {
	float4	pos 	: POSITION;
	float2	uv		: TEXCOORD0;
};

VS_OUTPUT vsMain( VS_INPUT i ) {
	VS_OUTPUT	o;

	o.pos = mul( i.pos, mWorld );

	o.pos.y = o.pos.z;
	o.pos.z = 0;
	
	o.pos.y = -o.pos.y * 1.275;

	o.pos.x += vDelta.x;
	o.pos.y += vDelta.y;
	
	o.pos.w = vDelta.z;	

	o.uv = i.uv;

	return o;
}

technique tec0
{
	pass P0
	{
		CullMode = CW;
		
		VertexShader = compile vs_1_1 vsMain();

		//Clipping = False;

		ZEnable = False;
		ZWriteEnable = True;

		AlphaBlendEnable = True;	
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;

		Lighting = False;

		Texture[0] = <tBase>;

		TextureFactor = <vDiffuse>;

		ColorOp[0]	 = Modulate;
		ColorArg1[0] = TFactor;
		ColorArg2[0] = Texture;
		AlphaOp[0]	 = Modulate;
		AlphaArg1[0] = TFactor;
		AlphaArg2[0] = Texture;
		
		ColorOp[1] = Disable;
	}

	pass PLast
	{
		VertexShader = NULL;

		CullMode = CW;

		ZWriteEnable = True;
		ZEnable = True;

		//Clipping = True;

		AlphaBlendEnable = False;	
	}
}
