#include "_shared.fx"

// environment texture
texture tEnv;

// world transform
matrix mWorld;

struct VS_INPUT {
	float4	pos		: POSITION;
	float3	normal	: NORMAL;
	float2	uv		: TEXCOORD0;
};

struct VS_OUTPUT_ENV {
	float4	pos 	: POSITION;
	float2	uvEnv	: TEXCOORD0;
	float2	uv		: TEXCOORD1;
};

VS_OUTPUT_ENV vsMain( VS_INPUT i ) {
	VS_OUTPUT_ENV	o;

	float3 normal = mul( i.normal, mWorld );
	normal = normalize( mul( normal, mSphereMap ) );
	o.uvEnv.x = normal.x;
	o.uvEnv.y = normal.y;
	o.pos = mul( i.pos, mWorld );
	o.pos = mul( o.pos, mViewProj );
	o.uv = i.uv;

	return o;
}


technique tec0
{
	pass P0
	{
		CullMode = CW;

		VertexShader = compile vs_1_1 vsMain();

		ZEnable = True;
		ZWriteEnable = True;

		AlphaBlendEnable = False;	

		Lighting = False;

		Texture[0] = <tEnv>;

		TexCoordIndex[0] = 0;
		TextureTransformFlags[0] = Disable;

		ColorOp[0]	 = SelectArg1;
		ColorArg1[0] = Texture;
		AlphaOp[0]	 = SelectArg1;
		AlphaArg1[0] = Texture;
		
		/*TextureFactor = 0xff000000;

		ColorOp[0]	 = SelectArg1;
		ColorArg1[0] = TFactor;
		AlphaOp[0]	 = SelectArg1;
		AlphaArg1[0] = TFactor;*/
		
		ColorOp[1] = Disable;
	}

	pass PLast
	{
		NormalizeNormals = false;

		VertexShader = NULL;

		AlphaBlendEnable = False;	
	}
}
