            #include "_shared.fx"

// world transform
matrix mWorld;

float4 vLight;

float4 vDiffuse;

texture tBase;

float fDeltaU;

// vertex definition
//vertexshader vs = decl { fvf xyz | normal; };


struct VS_INPUT {
	float4	pos		: POSITION;
	float3	normal	: NORMAL;
};

struct VS_OUTPUT {
	float4	pos 	: POSITION;
	float4	diffuse	: COLOR0;
	float2	uv		: TEXCOORD0;
};

VS_OUTPUT vsMain( VS_INPUT i ) {
	VS_OUTPUT o;

	float4 normal = mul( i.normal, mWorld );
	normal.w = 0;
	
	o.pos = mul( i.pos, mWorld );
	
	//vLight = float4( 0, 0, 0, 0 );

	float radius = 150;

	if( dot( normal, o.pos - vLight ) > 0 ) {
		float4 delta;
		delta = float4( o.pos - vLight );
		//delta.y = delta.y * 2;

		
		
		float a = delta.x * delta.x + delta.z * delta.z;
		float b = 2 * ( delta.x * o.pos.x + delta.z * o.pos.z );
		float c = o.pos.x * o.pos.x + o.pos.z * o.pos.z - radius * radius;

		float f = ( -b + sqrt( b * b - 4 * a * c ) ) / 2 / a;
			
		o.pos = o.pos + delta * f;
		//o.pos.y = 0;

		//o.pos = o.pos + delta * 3;
		o.pos.w = 1;
		
		//o.diffuse = float4( 0, 0, 0, 1 );
		//o.diffuse = float4( 0.2, 0.2, 0.2, 1 );		
		o.diffuse = vDiffuse;

		//if( length( o.pos ) < 98 ) o.diffuse = float4( 0, 0, 0.5, 1 );		
		//else if( o.pos.x * o.pos.x + o.pos.z * o.pos.z > 102 * 102 ) o.diffuse = float4( 0, 0.5, 0, 1 );		
	} else {
		o.pos = o.pos + normal * 2;
		//o.diffuse = float4( 0.2, 0.2, 0.2, 1 );
		o.diffuse = float4( 0, 0, 0, 0 );
		//o.diffuse = vDiffuse * 0.1;
	}

	o.uv.x = fDeltaU;
	o.uv.y = sqrt( o.pos.x * o.pos.x + o.pos.z * o.pos.z ) / radius * 3;

	o.pos = mul( o.pos, mViewProj );
	
	
	return o;
}

// Single pass
technique tec0
{
	pass P0
	{
		CullMode = None;

		VertexShader = compile vs_1_1 vsMain();

		Lighting = False;

		ZWriteEnable = False;

		AlphaBlendEnable = True;
		SrcBlend = SrcAlpha;
		DestBlend = One;

		/*//MinFilter[0] = Point;
        //MagFilter[0] = Point;
		MinFilter[0] = Linear;
        MagFilter[0] = Linear;
		MipFilter[0] = None;*/

		Texture[0] = <tBase>;

		ColorOp[0]	 = Modulate;
		ColorArg1[0] = Texture;
		ColorArg2[0] = Diffuse;
		AlphaOp[0]	 = Modulate;
		AlphaArg1[0] = Texture;
		AlphaArg2[0] = Diffuse;
		ColorOp[1] = Disable;
	}

	pass PLast
	{
		VertexShader = NULL;

		ZWriteEnable = True;

		CullMode = CW;

		AlphaBlendEnable = False;	
	}
}
