#ifndef __MARAST_GLOBAL_HEADER__
#define __MARAST_GLOBAL_HEADER__

#include <iostream>
#include <fstream>
#include <string>
#include <vector>
#include <list>
#include <GL/glfw.h>
#include <GL/glext.h>
#include <bass.h>
#include "glModel.h"
#include "algebra.h"
#include "demoFX.h"
#include "texture.h"
#include "timeLine.h"
#include "music.h"
#include "glText.h"

#define PURE_WHITE 0
#define RECYCLED_WHITE 1
#define WHITEWASH 2
#define TILE_GREEN 3
#define SLATE_BLUE 4
#define CEMENT_GREEN 5
#define STEEL_BLUE 6
#define FACTORY_GREEN 7
#define FUSE_GREEN 8
#define SAFETY_ORANGE 9
#define BRICK_RED 10
#define CHARCOAL_BROWN 11

static float col[12][3] = 
	{
        {249.0/255, 246.0/255, 255.0/255}, //pure white
        {238.0/255, 235.0/255, 236.0/255}, //recycled white
        {231.0/255, 227.0/255, 208.0/255}, //whitewash
        {219.0/255, 222.0/255, 206.0/255}, //tile green
        {206.0/255, 213.0/255, 210.0/255}, //slate blue
        {197.0/255, 181.0/255, 146.0/255}, //cement green
        {94.0/255, 116.0/255, 117.0/255},  //steel blue
        {138.0/255, 126.0/255, 77.0/255},  //factory green
        {173.0/255, 144.0/255, 73.0/255},  //fuse green
        {165.0/255, 114.0/255, 64.0/255},  //safety orange
        {139.0/255, 69.0/255, 63.0/255},   //brick red
        {76.0/255, 71.0/255, 64.0/255}      //charcoal brown
    };

extern HSTREAM music;
extern float* FFT; //[256] - filled before each frame
extern glText* font;

const int LOG_LOOKUP[256] = { 
	  0,   0,  32,  51,  64,  74,  82,  90,
	 96, 101, 106, 110, 114, 118, 121, 125,
	128, 130, 133, 135, 138, 140, 142, 144,
	146, 148, 150, 152, 153, 155, 157, 158,
	159, 161, 162, 164, 165, 166, 167, 169,
	170, 171, 172, 173, 174, 175, 176, 177,
	178, 179, 180, 181, 182, 183, 184, 184,
	185, 186, 187, 188, 188, 189, 190, 191,
	191, 192, 193, 193, 194, 195, 196, 196,
	197, 197, 198, 199, 199, 200, 200, 201,
	202, 202, 203, 203, 204, 204, 205, 206,
	206, 207, 207, 208, 208, 209, 209, 210,
	210, 211, 211, 211, 212, 212, 213, 213,
	214, 214, 215, 215, 215, 216, 216, 217,
	217, 218, 218, 218, 219, 219, 220, 220,
	220, 221, 221, 221, 222, 222, 223, 223,
	223, 224, 224, 224, 225, 225, 225, 226,
	226, 226, 227, 227, 227, 228, 228, 228,
	229, 229, 229, 230, 230, 230, 231, 231,
	231, 231, 232, 232, 232, 233, 233, 233,
	234, 234, 234, 234, 235, 235, 235, 236,
	236, 236, 236, 237, 237, 237, 237, 238,
	238, 238, 238, 239, 239, 239, 239, 240,
	240, 240, 240, 241, 241, 241, 241, 242,
	242, 242, 242, 243, 243, 243, 243, 244,
	244, 244, 244, 245, 245, 245, 245, 245,
	246, 246, 246, 246, 247, 247, 247, 247,
	247, 248, 248, 248, 248, 248, 249, 249,
	249, 249, 249, 250, 250, 250, 250, 250,
	251, 251, 251, 251, 251, 252, 252, 252,
	252, 252, 253, 253, 253, 253, 253, 254,
	254, 254, 254, 254, 254, 255, 255, 255};

#endif
