#ifndef __DATA_3D_LOADER_HEADER__
#define __DATA_3D_LOADER_HEADER__

#include <iostream>
#include <fstream>
#include <vector>
#include <string>
#include <GL/gl.h>
#include "algebra.h"

// no openGL optimizations!

using namespace std;

class glModelGroup
{
    public:
        string name;
        struct Triangle { int f[3]; };
        vector<vec3> vtx;
        vector<vec3> norm;
        vector<Triangle> tri;
        float color[4];
        
        glModelGroup() { color[0]=color[1]=color[2]=0.6; color[3]=1.0; }
        ~glModelGroup() { vtx.clear(); norm.clear(); tri.clear(); }
        void draw();
        void setColor (float r, float g, float b, float a) { color[0]=r; color[1]=g; color[2]=b; color[3]=a; }
        void setAlpha (float a) { color[3]=a; }
};
        

class glModel
{
    public:
        vector<glModelGroup> group;
        
        glModel(const char* fileName);
        ~glModel() { group.clear(); }
        void draw() { for (unsigned int i=0; i<group.size(); i++) group[i].draw(); }
};

#endif

