float4 up;
float4 right;
float4x4 worldViewProjMatrix;

struct VS_INPUT{
	float4 position: POSITION;
	float4 color: COLOR0;
	float4 particle: TEXCOORD0;
};

struct VS_OUTPUT{
	float4 position: POSITION;
	float2 tex: TEXCOORD0;
	float4 color: COLOR0;
};

VS_OUTPUT main(VS_INPUT input)
{
	VS_OUTPUT Out;

	//uv
	Out.tex.x = sign(input.position.x)*0.5+0.5;
	Out.tex.y = sign(input.position.y)*0.5+0.5;

	//posio
	float2 uv = sign(input.position.xy);
	float4 inPos = (float4(input.particle.xyz,1) + ((uv.x*right + uv.y*up)*input.particle.w));
	inPos.w = 1;
	Out.position = mul(inPos, worldViewProjMatrix);

	//cor
	Out.color = input.color;

	return Out;
}