// VERTEX SHADER //

float blur;
bool hdir;
float2 offset;	//offset de acerto para centrar o glow  imagem

struct VS_OUTPUT 
{
	float4 Pos: POSITION;

	float2 tex1: TEXCOORD0;		//centro

	float2 tex2: TEXCOORD1;		//lado 1
	float2 tex3: TEXCOORD2;
	float2 tex4: TEXCOORD3;

	float2 tex5: TEXCOORD4;		//lado 2
	float2 tex6: TEXCOORD5;
	float2 tex7: TEXCOORD6;
};

VS_OUTPUT main(float4 inPos: POSITION, float2 tex: TEXCOORD0)
{
	VS_OUTPUT Out;

	Out.Pos.xy = sign(inPos.xy);
	Out.Pos.z = 0;
	Out.Pos.w = 1;

	float2 t;
	t.x = Out.Pos.x*0.5+0.5;
	t.y =-Out.Pos.y*0.5+0.5;

	if(hdir){

		Out.tex1 = t + offset;

		Out.tex2 = t + float2(blur*0.33,0) + offset;
		Out.tex3 = t + float2(blur*0.66,0) + offset;
		Out.tex4 = t + float2(blur*1.0,0) + offset;

		Out.tex5 = t - float2(blur*0.33,0) + offset;
		Out.tex6 = t - float2(blur*0.66,0) + offset;
		Out.tex7 = t - float2(blur*1.0,0) + offset;

	}
	else{

		Out.tex1 = t + offset;

		Out.tex2 = t + float2(0,blur*0.33) + offset;
		Out.tex3 = t + float2(0,blur*0.66) + offset;
		Out.tex4 = t + float2(0,blur*1.0) + offset;

		Out.tex5 = t - float2(0,blur*0.33) + offset;
		Out.tex6 = t - float2(0,blur*0.66) + offset;
		Out.tex7 = t - float2(0,blur*1.0) + offset;
	}

	return Out;
}