unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, AppEvnts, StdCtrls, OvcLabel,
  Splash
;

type
  Tball = class
  public
    x: Integer;
    y: Integer;
    xSpeed: Integer;
    ySpeed: Integer;
    xAccel: Integer;
    yAccel: Integer;
    parent: TImage;
    bm: TBitmap;
    procedure Draw;
    procedure Move;
  end;


  TRaquette = class
  public
    bm: TBitmap;
    x: Integer;
    y: Integer;
    parent: TImage;
    procedure Draw;
    procedure Up;
    procedure down;
  end;


  TForm1 = class(TForm)
    pCourt: TPanel;
    pScore: TPanel;
    iCourt: TImage;
    ApplicationEvents1: TApplicationEvents;
    iraq1: TImage;
    iRaq2: TImage;
    OvcLabel1: TOvcLabel;
    OvcLabel2: TOvcLabel;
    ovclscore1: TOvcLabel;
    ovclscore2: TOvcLabel;
    iBalle: TImage;
    procedure FormCreate(Sender: TObject);
    procedure ApplicationEvents1Idle(Sender: TObject; var Done: Boolean);
    procedure ApplicationEvents1Message(var Msg: tagMSG;
      var Handled: Boolean);
  private
    playing: boolean;
    Score_p1: Integer;
    Score_p2: Integer;
    Up_p1: Boolean;
    Down_p1: Boolean;
    Up_p2: Boolean;
    Down_p2: Boolean;
  protected
    procedure WndProc(var Message: TMessage); override;
  public
    balle: TBall;
    raquette1: TRaquette;
    raquette2: TRaquette;
    procedure Draw;
    procedure Start(sens: Integer);
    procedure DebutPartie;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

const
  MARGE_FOND = 40;
  START_SPEED_DELTA = 0;
  MIN_START_SPEED = 1;
  RAQ_TOP = -26;
  RAQ_BOTTOM = 26;
  RAQ_Y_BOTTOM = 64;
  X_ACCEL = 0;
  RAQ_Y_SPEED = 20;
  BALL_RAYON = 7;

procedure TForm1.Draw;
begin
  iCourt.Canvas.FillRect(Rect(0,0,iCourt.Width,iCourt.Height));
  raquette1.Draw;
//  raquette2.Draw;
  balle.Draw;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Randomize;
  pCourt.DoubleBuffered := true;
  balle := TBall.Create;
  balle.parent := iCourt;
  balle.bm := iBalle.Picture.Bitmap;
  raquette1 := TRaquette.Create;
  raquette1.bm := iRaq1.Picture.Bitmap;
  raquette1.parent := iCourt;
  raquette2 := TRaquette.Create;
  raquette2.bm := iRaq2.Picture.Bitmap;
  raquette2.parent := iCourt;

  raquette1.x := MARGE_FOND;
  raquette1.y := iCourt.Height div 2;
  raquette2.x := iCourt.Width - MARGE_FOND;
  raquette2.y := iCourt.Height div 2;
  balle.x := iCourt.Width div 2;
  balle.y := iCourt.Height div 2;

//  iCourt.Canvas.Brush.Color := clgreen;
  SplashScreen.Update;
  Application.ProcessMessages;
  Sleep(10000);
  SplashScreen.FinSplash(nil);
end;

procedure TForm1.WndProc(var Message: TMessage);
begin
  case Message.Msg of
    WM_KEYDOWN:
    begin
      case Message.wParam of
        VK_F1:
        begin
          DebutPartie;
        end;

        VK_ESCAPE:
        begin
          Application.Terminate;
        end;
      end;
    end;
    else
      inherited WndProc(Message);
  end;
end;

{ TRaquette }

procedure TRaquette.Down;
begin
  y := y + RAQ_Y_SPEED;
  if((y + RAQ_Y_BOTTOM) > (parent.Height - 1)) then
  begin
    y := parent.Height - RAQ_Y_BOTTOM - 1;
  end;
end;

procedure TRaquette.Draw;
begin
//  parent.Canvas.Rectangle(x - (5), y + RAQ_TOP, x + (5), y + RAQ_Y_BOTTOM);
  parent.Canvas.Draw(x - (bm.Width div 2), y + RAQ_TOP, bm);
end;

procedure TRaquette.Up;
begin
  y := y - RAQ_Y_SPEED;
  if((y + RAQ_TOP) < 0) then
  begin
    y := -RAQ_TOP;
  end;
end;

procedure TForm1.ApplicationEvents1Idle(Sender: TObject;
  var Done: Boolean);
begin
  if(playing) then
  begin
    if(Up_p1) then
    begin
      raquette1.Up;
      Up_p1 := false;
    end;
    if(Down_p1) then
    begin
      raquette1.Down;
      Down_p1 := false;
    end;
    if(Up_p2) then
    begin
      raquette2.Up;
      Up_p2 := false;
    end;
    if(Down_p2) then
    begin
      raquette2.Down;
      Down_p2 := false;
    end;


    balle.Move;

    if(balle.xSpeed > 0) then
    begin  // va vers la droite
    (*
      if(balle.x >= (raquette2.x - (raquette2.bm.Width div 2))) and (balle.x < raquette2.x) and
        (balle.y <= (raquette2.y + RAQ_TOP)) and (balle.y >= (raquette2.y + RAQ_BOTTOM)) then
      begin
        balle.x := raquette2.x;
        balle.xAccel := balle.xAccel + X_ACCEL;
        balle.xSpeed := -balle.xAccel;
      end
      else
      *)
      begin
        if((balle.x + BALL_RAYON) > (iCourt.Width - 1)) then
        begin
          balle.x := iCourt.Width - BALL_RAYON - 1;
          balle.xAccel := balle.xAccel + X_ACCEL;
          balle.xSpeed := -balle.xAccel;
          // point
          Inc(Score_p2);
          ovclScore2.Caption := IntToStr(Score_p2);

        end;
      end;
    end
    else
    begin  // va vers la gauche
      if(balle.x >= (raquette1.x - (raquette1.bm.Width div 2))) and  (balle.x <= (raquette1.x + (raquette1.bm.Width div 2))) and
        (balle.y >= (raquette1.y + RAQ_TOP)) and (balle.y <= (raquette1.y + RAQ_BOTTOM)) then
      begin
//        balle.x := raquette1.x;
        balle.xAccel := balle.xAccel + X_ACCEL;
        balle.xSpeed := balle.xAccel;
      end
      else
      begin
        if(balle.x < 0) then
        begin
          // perdu
          if(Score_p2 > Score_P1) then
          begin
            Score_p1 := Score_p2;
            ovclScore1.Caption := IntToStr(Score_p1);
            Score_p2 := 0;
            ovclScore2.Caption := IntToStr(Score_p2);
          end;
          Start(1);
        end;
      end;
    end;
    Draw;
  end;
end;

procedure TForm1.Start(sens: Integer);
begin
  raquette1.x := MARGE_FOND;
  raquette1.y := iCourt.Height div 2;
  raquette2.x := iCourt.Width - MARGE_FOND;
  raquette2.y := iCourt.Height div 2;
  balle.x := iCourt.Width div 2;
  balle.y := iCourt.Height div 2;
  balle.xAccel := MIN_START_SPEED + Round(Random(START_SPEED_DELTA));
  if(Sens > 0) then
    balle.xSpeed := balle.xAccel
  else
    balle.xSpeed := -balle.xAccel;

  balle.yAccel := (MIN_START_SPEED + Round(Random(START_SPEED_DELTA)));
  if(Random(2) < 1) then
    balle.ySpeed := balle.yAccel
  else
    balle.ySpeed := -balle.yAccel;
  Playing := true;
end;

procedure TForm1.DebutPartie;
begin
  Score_p1 := 0;
  Score_p2 := 0;
  ovclScore1.Caption := IntToStr(Score_p1);
  ovclScore2.Caption := IntToStr(Score_p2);
  Playing := true;
  if(Random(2) < 1) then
    Start(-1)
  else
    Start(1);
end;

{ Tball }

procedure Tball.Draw;
begin
  parent.Canvas.Draw(x - (bm.Width div 2), y - BALL_RAYON, bm);
end;

procedure Tball.Move;
begin
  x := x + xSpeed;
  y := y + ySpeed;
  if(y - BALL_RAYON) < 0 then
  begin
    y := BALL_RAYON;
    ySpeed := -ySpeed;
  end
  else if(y + BALL_RAYON > (parent.Height - 1)) then
  begin
    y := parent.Height - BALL_RAYON - 1;
    ySpeed := -ySpeed;
  end;
end;

procedure TForm1.ApplicationEvents1Message(var Msg: tagMSG;
  var Handled: Boolean);
begin
  if(Playing) then
  begin
    case Msg.message of
      WM_KEYDOWN:
      begin
        case Msg.wParam of
          Ord('Q'):
          begin
            Up_p1 := true;
          end;

          Ord('W'):
          begin
            Down_p1 := true;
          end;

          VK_DOWN:
          begin
//            Up_p2 := true;
          end;

          VK_UP:
          begin
//            Down_p2 := true;
          end;
        end;
      end;
    end;
  end;
end;

end.
