
// Copyright (c) Jacobo Tarro Barreiro.
// All rights reserved.

// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither Jacobo Tarro Barreiro's name nor the names of his contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.

// THIS SOFTWARE IS PROVIDED BY JACOBO TARRO BARREIRO AND THE CONTRIBUTORS
// ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL JACOBO TARRO BARREIRO OR THE
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
// OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
// WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
// OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
// ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#include "consts.hpp"
#include "robot.hpp"
#include <string>
#include <iostream>
#include <iomanip>
#include <signal.h>

namespace rtb {
  void Robot::RobotOption (Consts::robot_option_type option, int value) {
    std::cout << "RobotOption " << option << " " << value << std::endl << std::flush;
  }

  void Robot::Name (std::string name) {
    std::cout << "Name " << name << std::endl << std::flush;
  }

  void Robot::Colour (int colour, int away_colour) {
    std::cout << "Colour " << std::hex << std::setw(6) << std::setfill ('0') << colour << " " << std::setw(6) << away_colour << std::dec << std::endl << std::flush;
  }

  void Robot::Rotate (Consts::rotate_type what, double angular) {
    std::cout << "Rotate " << what << " " << angular << std::endl << std::flush;
  }
  
  void Robot::RotateTo (Consts::rotate_type what, double angular, double end) {
    std::cout << "RotateTo " << what << " " << angular << " " << end << std::endl << std::flush;
  }

  void Robot::RotateAmount (Consts::rotate_type what, double angular, double angle) {
    std::cout << "RotateAmount " << what << " " << angular << " " << angle << std::endl << std::flush;
  }

  void Robot::Sweep (Consts::rotate_type what, double angular, double left, double right) {
    std::cout << "Sweep " << what << " " << angular << " " << left << " " << right << std::endl << std::flush;
  }

  void Robot::Accelerate(double value) {
    std::cout << "Accelerate " << value << std::endl << std::flush;
  }

  void Robot::Brake(double portion) {
    std::cout << "Brake " << portion << std::endl << std::flush;
  }

  void Robot::Shoot(double energy) {
    std::cout << "Shoot " << energy << std::endl << std::flush;
  }

  void Robot::Print(std::string message) {
    std::cout << "Print " << message << std::endl << std::flush;
  }

  void Robot::Debug(std::string message) {
    std::cout << "Debug " << message << std::endl << std::flush;
  }

  void Robot::DebugLine(double angle1, double radius1, double angle2, double radius2) {
    std::cout << "DebugLine " << angle1 << " " << radius1 << " " << angle2 << " " << radius2 << std::endl << std::flush;
  }

  void Robot::DebugCircle(double center_angle, double center_radius, double circle_radius) {
    std::cout << "DebugCircle " << center_angle << " " << center_radius << " " << circle_radius << std::endl << std::flush;
  }

  void Robot::OptimizedParser (void) {
    std::string command = "";

    std::cin >> command;
    if (command == "")
      return;

    if (command == "Initialize") {
      int i;
      std::cin >> i;
      Initialize (i);
    } else if (command == "YourName") {
      std::string name;
      std::getline (std::cin, name);
      YourName (name);
    } else if (command == "YourColour") {
      int i;
      std::cin >> std::hex >> i >> std::dec;
      YourColour (i);
    } else if (command == "GameOption") {
      Consts::game_option_type i;
      double f;
      std::cin >> (int) i >> f;
      GameOption (i, f);
    } else if (command == "GameStarts") {
      GameStarts ();
    } else if (command == "Radar") {
      Consts::object_type i;
      double a, b;
      std::cin >> a >> (int) i >> b;
      Radar (a, i, b);
    } else if (command == "Info") {
      double a, b, c;
      std::cin >> a >> b >> c;
      Info (a, b, c);
    } else if (command == "Coordinates") {
      double a, b, c;
      std::cin >> a >> b >> c;
      Coordinates (a, b, c);
    } else if (command == "RobotInfo") {
      int i;
      double f;
      std::cin >> f >> i;
      RobotInfo (f, i);
    } else if (command == "RotationReached") {
      Consts::rotate_type i;
      std::cin >> (int) i;
      RotationReached (i);
    } else if (command == "Energy") {
      double f;
      std::cin >> f;
      Energy (f);
    } else if (command == "RobotsLeft") {
      int i;
      std::cin >> i;
      RobotsLeft (i);
    } else if (command == "Collision") {
      Consts::object_type i;
      double f;
      std::cin >> (int) i >> f;
      Collision (i, f);
    } else if (command == "Warning") {
      std::string s;
      Consts::warning_type i;
      std::cin >> (int) i;
      std::getline (std::cin, s);
      Warning (i, s);
    } else if (command == "Dead") {
      Dead ();
    } else if (command == "GameFinishes") {
      GameFinishes ();
    } else if (command == "ExitRobot") {
      ExitRobot ();
    } else {
      std::cerr << "WARNING: unknown command [" << command << "]" << std::endl << std::flush;
    }
      
}

  Robot::Robot (std::string name, int colour, int away_colour) {
    _name = name;
    _colour = colour;
    _away_colour = away_colour;
  }

  void Robot::Scanner () {
    RobotOption(Consts::SIGNAL, 0);
    RobotOption(Consts::SEND_ROTATION_REACHED, 1);
    RobotOption(Consts::USE_NON_BLOCKING, 0);
    
    for (;;OptimizedParser ());
  }

}

