//
// Fast coding by rgba!!
//

#include <windows.h>
#include <assert.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glext.h>
#include <malloc.h>
#include <glt.h>
#include <tds.h>

#define RES_X 640
#define RES_Y 480

/*
1. Rotozoom cambiando colores textura
   incrementando velocidad hasta infinito :)
2. Deformador de fondo
   (flahses)
3. circulos concentricos hacia dentro y hacia fuera
4. Rotozoom con texturas de lineas?
5. Logo Cocacola
6. Tunel
7. Texto estilo guerra de las galaxias (greets)
   fregona
8. Deformador forma agua
9. Un cubo flat/textura/cada cara con diferente plasma/fuego
10. Terreno (voxel) con lupa --> movimiento tipo agua --> bandera finlandia
11. Creditos con plasma de fondo
*/

TTexture *TEX_Xor (int w, int h)
{
    unsigned char *data;
    int i, j;

    data = (unsigned char *) malloc (w * h);
    assert (data != NULL);

    for (i=0; i<w; i++)
        for (j=0; j<h; j++)
            data[i+w*j] = (unsigned char) (i^j);

    return TEX_New (w, h, 8, data, TEX_BUILD_MIPMAPS);
}

void GL_Set2D (double x0, double y0, double x1, double y1)
{
    glMatrixMode (GL_PROJECTION);
    glLoadIdentity ( );
    glMatrixMode (GL_MODELVIEW);
    glLoadIdentity ( );
    gluOrtho2D (x0, x1, y0, y1);
}

static TTexture *texture_xor;
static TTexture *texture_rgba;
static TTexture *texture_cola;

void ROTOZOOM_Do (float angle, float zoom)
{
    GL_Set2D (-1.0, 1.0, -1.0, 1.0);

    glEnable (GL_TEXTURE_2D);
    TEX_Bind (texture_xor);
    TEX_SetFilter (GL_LINEAR_MIPMAP_LINEAR, GL_LINEAR);
    TEX_SetWrap   (GL_REPEAT, GL_REPEAT);

    glScalef (zoom, zoom, 1.0f);
    glRotatef (angle, 0, 0, 1.0f);

    glColor4f (cos (angle*zoom/71.0f)*0.4f+0.6f,
               cos (angle*zoom/401.0f)*0.4f+0.6f,
               cos (angle*zoom/151.0f)*0.4f+0.6f,
               1.0f);

    glBegin (GL_QUADS);
     glTexCoord2d ( 0.0f,  0.0f); glVertex2f (-10.0f, -10.0f);
     glTexCoord2d (10.0f,  0.0f); glVertex2f (+10.0f, -10.0f);
     glTexCoord2d (10.0f, 10.0f); glVertex2f (+10.0f, +10.0f);
     glTexCoord2d ( 0.0f, 10.0f); glVertex2f (-10.0f, +10.0f);
    glEnd ( );

    glDisable (GL_TEXTURE_2D);
}

void GREETS_Do (float t)
{
    glMatrixMode (GL_PROJECTION);
    glLoadIdentity ( );
    gluPerspective (45.0f, (GLfloat)RES_X/(GLfloat)RES_Y, 0.1f, 100.0f);
    glMatrixMode (GL_MODELVIEW);

    glClearDepth (1.0f);
    glEnable (GL_DEPTH_TEST);
    glEnable (GL_TEXTURE_2D);
    glEnable (GL_BLEND);

    TEX_Bind (texture_rgba);
    TEX_SetFilter (GL_LINEAR_MIPMAP_LINEAR, GL_LINEAR);
    TEX_SetWrap (GL_REPEAT, GL_REPEAT);

    glColor4f (1.0f, 1.0f, 1.0f, 1.0f);
    glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

    glLoadIdentity ( );
    glScalef (1.0f, 1.0f, .7f);
    glTranslatef (-0.3f, 0.0f, -3.0f);
    glRotatef (30.0f, 0.0f, 1.0f, 0.0f);

    glBegin (GL_QUADS);
     glTexCoord2f (0.0f+t, 0.0f);
     glVertex3f(-1.0f, -1.0f, +1.0f);

     glTexCoord2f (0.1f+t, 0.0f);
     glVertex3f( 1.0f, -1.0f, +1.0f);

     glTexCoord2f (0.1f+t, 1.0f);
     glVertex3f( 1.0f,  1.0f, +1.0f);

     glTexCoord2f (0.0f+t,   1.0f);
     glVertex3f(-1.0f,  1.0f, +1.0f);
    glEnd ( );

    glDisable (GL_BLEND);
    glDisable (GL_DEPTH_TEST);
    glDisable (GL_TEXTURE_2D);
}

/*
void CIRCLES_Do (float t)
{
    GLUquadric g;

    glMatrixMode (GL_PROJECTION);
    glLoadIdentity ( );
    gluPerspective (45.0f, (GLfloat)RES_X/(GLfloat)RES_Y, 0.1f, 100.0f);
    glMatrixMode (GL_MODELVIEW);

    glClearDepth (1.0f);
    glEnable (GL_DEPTH_TEST);

    glLoadIdentify ( );
    glRotatef (t, 0, 0, t);
    glTranslatef (0.0f, 0.0f, -4.0f);

    gluDisk (&g, 1.0, 10.0f, 10, 2);
}
*/

void COLA_Do (float t)
{
    GL_Set2D (0.0, 0.0, 1.0, 1.0);
    glLoadIdentity ( );

    glEnable (GL_TEXTURE_2D);
    TEX_Bind (texture_cola);
    TEX_SetFilter (GL_LINEAR_MIPMAP_LINEAR, GL_LINEAR);
    TEX_SetWrap   (GL_REPEAT, GL_REPEAT);

    glMatrixMode (GL_PROJECTION);
    glLoadIdentity ( );
    glMatrixMode (GL_MODELVIEW);
    glLoadIdentity();
    gluOrtho2D (0.0f, 1.0f, 0.0f, 1.0f);

    glEnable (GL_BLEND);
    glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    glColor4f (1.0f, 1.0f, 1.0f, t);

    glBegin (GL_QUADS);
     glTexCoord2f (0, 0); glVertex2f (0.0f, 1.0f);
     glTexCoord2f (0, 1); glVertex2f (0.0f, 0.0f);
     glTexCoord2f (1, 1); glVertex2f (1.0f, 0.0f);
     glTexCoord2f (1, 0); glVertex2f (1.0f, 1.0f);
    glEnd ( );

    glDisable (GL_TEXTURE_2D);
    glDisable (GL_BLEND);
}

//int main (void)
int WINAPI WinMain (HINSTANCE hInstance,
                    HINSTANCE hPrevInstance,
                    LPSTR     lpCmdLine,
                    int       nCmdShow)
{
    float t;
    DWORD t0 = GetTickCount ( );

    //if (!TDS_Init (RES_X, RES_Y, "the real thing...", TDS_WINDOWED))
    if (!TDS_Init (RES_X, RES_Y, "the real thing...", TDS_FULLSCREEN))
    {
        MessageBox (0, TDS_GetLastError ( ), "Error", MB_OK);
        ExitProcess (0);
    }

    //texture_xor  = TEX_Xor (256, 256);
    texture_xor  = TEX_Load ("clouds.png", TEX_BUILD_MIPMAPS);
    texture_rgba = TEX_Load ("rgba.png", TEX_BUILD_MIPMAPS);
    texture_cola = TEX_Load ("rgbacola.jpg", TEX_BUILD_MIPMAPS);

    glViewport (0, 0, RES_X, RES_Y);

    t = 0;
    while (t < 400.0f)
    {
        t = (float) (GetTickCount ( ) - t0) / 100.0f;

        glClearColor (0.0, 0.0, 0.0, 1.0);
        glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

        if (t < 100.0f)
            ROTOZOOM_Do (t*10.0f, 0.5f + (0.5f * cos (t / 5.0f) + 0.5f));

        if (t >= 100.0f && t < 200.0f)
            GREETS_Do (t*0.01f);

        if (t >= 200.0f && t < 250.0f)
            COLA_Do (1.0f);

        if (t >= 250.0f && t < 350.0f)
        {
            ROTOZOOM_Do (t*10.0f, 0.5f + (0.5f * cos (t / 5.0f) + 0.5f));
            GREETS_Do (t*0.01f);
            COLA_Do (0.5f * cos (t / 5.0f) + 0.5f);
        }

        TDS_Update ( );
    }

    TDS_Close ( );
}
