	SECTION "boll-skruv", HOME

skruv	START_MUSIC_INT

	ROMBANK	data5

	ld	hl, tiles
	ld	de, _VRAM
	ld	bc, 22*16
	call	vmemcopy

	ld	b, 8*8
	ld	hl, bgpal
	call	setbgpal
	ld	b, 1*8
	ld	hl, obpal
	call	setobpal

	ROMBANK mathb
	ld	hl, font
	ld	de, _VRAM+$20*16
	ld	bc, 64*16
	call	vmemcopy
	ROMBANK	data5

	ld	hl, _SCRN0+18*32
	ld	bc, 32*4
	ld	a, 16
	call	vmemset

	ld	de, map
	ld	hl, _SCRN0+18*32
	ld	bc, 4<<8+4
	call	drawmap
	ld	de, greets
	ld	hl, _SCRN0
	ld	bc, 12<<8+18
	call	drawmap
	ld	a, 1
	ldio	[rVBK], a
	ld	hl, _SCRN0
	ld	bc, 32*18
	call	vmemset
	xor	a
	ldio	[rVBK], a

	xor	a
	ld	[rWY], a
	ld	a, 71
	ld	[rWX], a
	ld	a, 64
	ld	[rSCX], a

	di
	ld	de, skruvirq
	call	setlcdcirq
	ld	a, %00100000
	ldio	[rSTAT], a
	ei
	
	ld	a, %10110111
	ldio	[rLCDC], a

skruv_main
	waitVBL
	ld	a, oambuf>>8
	call	oamdma
	MusicUpdate musicb
	ROMBANK	mathb

	xor	a
	ldio	[rLYC], a

	call	render_slime

	ldh	a, [counth]
	cp	time+0
	call	z, fadein
	ldh	a, [counth]
	cp	time+1
	call	z, fadeout
	
	ldh	a, [counth]
	cp	time+0
	call	z, movein
	ldh	a, [counth]
	cp	time+2
	call	z, moveout
	jr	nz, .skip
	ldh	a, [countl]
	cp	128
	call	nc, moveout
.skip

	ld	a, [counth]
	cp	time+0
	jr	c, .noballs
	cp	time+2
	jr	nc, .noballs
	ROMBANK	mathb
	call	create_balls
	ld	a, [counth]
	cp	time+0
	call	z, hide_balls1
	ld	a, [counth]
	cp	time+1
	call	z, hide_balls2
	;ld	a, oambuf >> 8
	;call	oamdma
.noballs

	ld	hl, count3
	inc	[hl]
	inc	[hl]
	inc	[hl]

	ldh	a, [counth]
	cp	time+3
	jr	nz, skruv_main
	
	ret

hide_balls1
	ld	hl, oambuf
	ldh	a, [countl]
	cpl
	add	%00001000
	and	%11111000
	ld	b, a
	xor	a
.loop	ld	[hl+], a
	djnz	.loop
	ret

hide_balls2
	ld	h, oambuf>>8
	ldh	a, [countl]
	cpl
	add	%00001000
	and	%11111000
	ret	z
	ld	l, a
.loop	ld	[hl], 0
	inc	l
	jr	nz, .loop
	ret


movein	;ldh	a, [countl]
	;and	1
	;ret	z
	ldio	a, [rSCX]
	cp	-32
	ret	z
	dec	a
	ldio	[rSCX], a
	ret

moveout	ld	a, %10010111
	ldio	[rLCDC], a
	;ldh	a, [countl]
	;and	1
	;ret	z
	ldio	a, [rSCX]
	cp	256-128-32
	ret	z
	dec	a
	ldio	[rSCX], a
	ret	

fadein	ld	a, [countl]
	and	3
	ret	nz
	ld	a, 1
	ldio	[rVBK], a
	ld	hl, _SCRN0+32*17
	VRWAIT
	ld	a, [hl]
	cp	7
	jr	nc, .skip
	inc	a
	rept	12
	ld	[hl+], a
	endr
.skip	ld	hl, _SCRN0+32
	ld	de, _SCRN0
	ld	bc, 32*17
	call	vmemcopy
	xor	a
	ldio	[rVBK], a
	ret

fadeout	ld	a, [countl]
	cp	128
	ret	c
	and	3
	ret	nz
	ld	a, 1
	ldio	[rVBK], a
	ld	hl, _SCRN0+32*17
	VRWAIT
	ld	a, [hl]
	cp	1
	jr	z, .skip
	dec	a
	rept	12
	ld	[hl+], a
	endr
.skip	ld	hl, _SCRN0+32
	ld	de, _SCRN0
	ld	bc, 32*17
	call	vmemcopy
	xor	a
	ldio	[rVBK], a
	ret

render_slime
	ldh	a, [countl]
	ld	l, a
	ld	h, sintab>>8
	ld	de, ylist
	ld	b, 144
.loop	ldh	a, [countl]
	add	a, b
	ld	l, a
	ld	a, [hl]
	ld	c, a
	ldh	a, [count3]
	add	a, a
	sub	a, b
	ld	l, a
	ld	a, [hl]
	sub	c
	add	a, 128
	srl	a
	srl	a
	srl	a
	add	a, 145
	ld	[de], a
	inc	e
	djnz	.loop
	ret

create_balls
	ld	hl, oambuf
	ld	d, sintab >> 8
	ldh	a, [countl]
	add	a, a
	ld	e, a
	ld	c, 4
	ld	b, 20
.loop	ld	a, [de]
	sra	a
	add	a, 40+8
	ldh	[beta], a
	ld	a, c
	ldh	[alpha], a
	ld	a, e
	add	a, 64
	ld	e, a
	ld	a, [de]
	add	a, 64
	sra	a
	sra	a
	sra	a
	and	%00001110
	ldh	[gamma], a
	ld	a, [de]
	and	%01000000
	xor	%01000000
	add	a, a
	ldh	[delta], a
	ldh	a, [alpha]
	ld	[hl+], a
	ldh	a, [beta]
	ld	[hl+], a
	ldh	a, [gamma]
	ld	[hl+], a
	ldh	a, [delta]
	ld	[hl+], a
	ldh	a, [alpha]
	ld	[hl+], a
	ldh	a, [beta]
	add	a, 8
	ld	[hl+], a
	ldh	a, [gamma]
	ld	[hl+], a
	ldh	a, [delta]
	xor	%00100000
	ld	[hl+], a
	ld	a, e
	add	a, 16-64
	ld	e, a
	ld	a, c
	add	a, 8
	ld	c, a
	dec	b
	jr	nz, .loop
	ret

skruvirq
	push	af
	push	hl
	ldh	a, [rLYC]
	inc	a
	ldh	[rLYC], a
	dec	a
	ld	l, a
	ld	h, ylist >> 8
	sub	[hl]
	cpl
	ldio	[rSCY], a
	pop	hl
	pop	af
	reti

	SECTION	"skruvdata", DATA, BANK[data5]

tiles	INCBIN	"balls2.tls"
	DB	$00,$00,$00,$00,$00,$00,$00,$00
	DB	$00,$00,$00,$00,$00,$00,$00,$00
	DB	$00,$FF,$00,$FF,$00,$FF,$00,$FF
	DB	$00,$FF,$00,$FF,$00,$FF,$00,$FF
	DB	$01,$00,$00,$01,$02,$01,$00,$03
	DB	$04,$03,$00,$07,$08,$07,$00,$0F
	DB	$10,$0F,$00,$1F,$20,$1F,$00,$3F
	DB	$40,$3F,$00,$7F,$80,$7F,$00,$FF
	DB	$80,$00,$00,$80,$40,$80,$00,$C0
	DB	$20,$C0,$00,$E0,$10,$E0,$00,$F0
	DB	$08,$F0,$00,$F8,$04,$F8,$00,$FC
	DB	$02,$FC,$00,$FE,$01,$FE,$00,$FF

map	db	16,18,20,16
	db	16,19,21,16
	db	18,17,17,20
	db	19,17,17,21

greets	db "            "
	db "      ELCREW"
	db "    CREATORS"
	db "     TRAKTOR"
	db "    PHANTASY"
	db "      NATURE"
	db "       TULOU"
	db "     LOONIES"
	db "        KESO"
	db "     SILENTS"
	db "     SCOOPEX"
	db "         DXM"
	db "        CNCD"
	db "      BIALIT"
	db "  CS BUSTRIP"
	db "  #CYBERPUNK"
	db "  UNDERSCORE"
	db "            "
	
bgpal	DW_RGB	$00, $00, $07
	DW_RGB	$07, $07, $07
	DW_RGB	$1f, $1f, $07
	DW_RGB	$00, $00, $00

	DW_RGB	$00, $00, $07
	DW_RGB	$00, $00, $07
	DW_RGB	$00, $00, $07
	DW_RGB	$00, $00, $07

	DW_RGB	$00, $00, $07
	DW_RGB	$00, $00, $06
	DW_RGB	$01, $01, $07
	DW_RGB	$02, $02, $09

	DW_RGB	$00, $00, $07
	DW_RGB	$00, $00, $05
	DW_RGB	$02, $02, $07
	DW_RGB	$04, $04, $0b

	DW_RGB	$00, $00, $07
	DW_RGB	$00, $00, $04
	DW_RGB	$03, $03, $07
	DW_RGB	$06, $06, $0d

	DW_RGB	$00, $00, $07
	DW_RGB	$00, $00, $03
	DW_RGB	$04, $04, $07
	DW_RGB	$09, $09, $14

	DW_RGB	$00, $00, $07
	DW_RGB	$00, $00, $02
	DW_RGB	$05, $05, $07
	DW_RGB	$12, $12, $1f

	DW_RGB	$00, $00, $07
	DW_RGB	$00, $00, $00
	DW_RGB	$07, $07, $07
	DW_RGB	$1f, $1f, $1f
	
obpal	DW_RGB	$00, $00, $00
	DW_RGB	$07, $07, $07
	DW_RGB	$0f, $0f, $0f
	DW_RGB	$1f, $1f, $1f
	
time	set	time+3
