; input:  c - start value
;        hl - source
;	 de - destination
; map format:
;
; DB A(=129-255)		write A-128 bytes increasing counter
; DB A(=1-127),B(=0-255)	write A bytes of value B
; DB 128,A			set counter to A
; DB 0				end of map

decodemap::
.loop	ld	a, [hl+]
	or	a
	ret	z
	bit	7, a
	jr	z, .block
	and	127
	jr	nz, .iblock
.setcnt	ld	a, [hl+]
	ld	c, a
	jr	.loop
.iblock	ld	b, a
	ld	a, c
.cloop	ldh	[alpha], a
.w1	ldio	a, [rSTAT]
	and	2
	jr	nz, .w1
	ldh	a, [alpha]
	ld	[de], a
	inc	de
	inc	a
	dec	b
	jr	nz, .cloop	
	ld	c, a
	jr	.loop
.block	ld	b, a
	ld	a, [hl+]
.bloop	ldh	[alpha], a
.w2	ldio	a, [rSTAT]
	and	2
	jr	nz, .w2
	ldh	a, [alpha]
	ld	[de], a
	inc	de
	dec	b
	jr	nz, .bloop
	jr	.loop

; input: de - source
;	 hl - destination
;	  b - bredd
;	  c - hjd

draw20x18
	ld	b, 20
	ld	c, 18
drawmap	ld	a, 32
	sub	b
	ldh	[alpha], a
.loop1	push	bc
.loop2	ld	a, [de]
	ld	c, a
	inc	de
	VRWAIT
	ld	[hl], c
	inc	hl
	dec	b
	jr	nz, .loop2
	push	de
	ld	d, 0
	ldh	a, [alpha]
	ld	e, a
	add	hl, de
	pop	de
	pop	bc
	dec	c
	jr	nz, .loop1
	ret

; input: hl - destination
;	  b - bredd
;	  c - hjd
;	  a - startvalue

makemap	ld	d, a
	ld	a, 32
	sub	b
	ld	e, a
	ld	a, d
	ld	d, 0
.loop1	push	bc
.loop2	ld	c, a
	VRWAIT
	ld	[hl], c
	ld	a, c
	inc	hl
	inc	a
	dec	b
	jr	nz, .loop2
	add	hl, de
	pop	bc
	dec	c
	jr	nz, .loop1
	ret
	
; input: hl - map
;	  c - hjd	
mirrormap::
	push	bc
	push	hl
.loop1	ld	d, h
	ld	a, l
	add	a, 32
	ld	e, a
	ld	b, 16
.iloop1	dec	e
	VRWAIT
	ld	a, [hl+]
	push	hl
	ld	hl, rSTAT
.w1	bit	1, [hl]
	jr	nz, .w1
	ld	[de], a
	pop	hl
	djnz	.iloop1
	ld	de, 16
	add	hl, de
	dec	c
	jr	nz, .loop1
	pop	hl
	pop	bc
	ld	a, 1
	ld	[rVBK], a
.loop2	ld	d, h
	ld	a, l
	add	a, 32
	ld	e, a
	ld	b, 16
.iloop2	dec	e
	ld	a, [hl+]
	xor	%00100000
	SAFE_VRWAIT alpha
	ld	[de], a
	djnz	.iloop2
	ld	de, 16
	add	hl, de
	dec	c
	jr	nz, .loop2
	xor	a
	ld	[rVBK], a
	ret

; input: hl - map
makeapamap::
	ld	de, 16
	xor	a
	ld	c, 16
.yloop	ld	b, 16
.xloop	SAFE_VRWAIT alpha
	ld	[hl+], a
	add	a, $10
	djnz	.xloop
	add	hl, de
	inc	a
	dec	c
	jr	nz, .yloop
	ret

; input: hl - map
makedistmap::
	ld	e, 16
	xor	a
	ld	c, 16
.yloop	ld	b, 8
.xloop	ld	d, a
	VRWAIT
	ld	[hl], d
	inc	hl
	VRWAIT
	ld	[hl], d
	inc	hl
	ld	a, d
	add	a, $10
	djnz	.xloop
	sub	$80
	ld	d, 0
	add	hl, de

	ld	a, 17
	sub	c
	sra	a

	;inc	a
	dec	c
	jr	nz, .yloop
	ret

	; in: hl=destination de=source
make_shifted_tiles
	ld	c, 32
.loop3	ld	b, 16
.loop2	push	bc
	push	de
	push	hl
	ld	h, d
	ld	l, e
	ld	c, [hl]
	ld	de, 16
	add	hl, de
	ld	a, l
	and	%01110000
	jr	nz, .ok
	ld	h,  $3f ;(tiles+512)>>8 ; dr finns bara nollor
.ok	ld	a, [hl]
	pop	hl
	ld	b, 8
.loop1	ld	[hl], c
	rla
	rl	c
	add	hl, de
	dec	b
	jr	nz, .loop1
	ld	de, -16*8+1
	add	hl, de
	pop	de
	inc	de
	pop	bc
	dec	b
	jr	nz, .loop2
	push	de
	ld	de, 16*7
	add	hl, de
	pop	de
	dec	c
	jr	nz, .loop3
	ret
