;-------------------------------------------------
;       in: a, d (both 6-bit)
;      out: hl=a*d
; destroys: af,bc,e,hl
fastmul	ld	e, a
	sub	d
	ld	h, multab >> 8
	ld	l, a
	ld	c, [hl]
	inc	h
	ld	b, [hl]
	ld	a, e
	add	a, d
	ld	l, a
	ld	e, [hl]
	dec	h
	ld	a, [hl]
	sub	c
	ld	l, a
	ld	a, e
	sbc	a, b
	ld	h, a
	ret

;-------------------------------------------------
;       in: h, e
;      out: hl=h*e
; destroys: f,b,d,hl
mulu88	ld	d, 0
	ld	l, d
	sla	h
	jr	nz, @+2
	ld	l, e
	REPT	7
	add	hl, hl
	jr	nc, @+2
	add	hl, de
	ENDR
	ret

;-------------------------------------------------
;       in: d, e
;      out: d=d/e rest a
; destroys: af,d
;divu88	REPT	8
;	xor	a
;	sll	d
;	rla
;	sub	e
;	jr	nc, @+3
;	add	a, e
;	dec	d
;	ENDR
;	ret

;-------------------------------------------------
;       in: hl, c
;      out: hl=hl/c
divs168	ld	a, h
	xor	c
	add	a, a
	jr	nc, .same
	bit	7, h
	jr	z, .do_c
	NEG_HL
	jr	.ok
.do_c	ld	a, c
	neg
	ld	c, a
.ok	call	divu168
	NEG_HL
	ret
.same	bit	7, h
	jp	z, divu168	; if they're positive
	NEG_HL
	ld	a, c
	neg
	ld	c, a
	call	divu168
	NEG_HL
	ret

;-------------------------------------------------
sdiv168	bit	7, h
	jr	z, divu168
	NEG_HL
	call	divu168
	NEG_HL
	ret

;-------------------------------------------------
;       in: hl, c
;      out: hl=hl/c, a=remainder
divu168	xor	a
	rept	16
	add	hl, hl
	rla
	cp	c
	jr	c, @+4
	sub	c
	inc	l
	endr
	ret
	