#include "Demo.inc"

.org demo_exec_ram

    
    call _clrLCD
    
    call enable_planes
    
    ld hl,disable_planes
    push hl
    
    
    call reset_int_counter

main_loop:    
    ld b,4
    
draw_boxes_loop2:
    push bc
    
boxes_start_address = $ + 1
    ld hl,boxes
    ld a,4
    sub b
    add a,a     ;2
    add a,a     ;4
    ld d,0
    ld e,a
    add hl,de
       
;    push hl
num_squares_byte = $ + 1
    ld b,1
    
draw_boxes_loop1:
    push bc
    call draw_box
    ld de,16
    add hl,de
    pop bc
    djnz draw_boxes_loop1
    
    
    call draw_screen
    call clear_buffer
    
    ld a,15
    
;    call pause
    call int_pause
    
    
;    pop hl
    pop bc
    djnz draw_boxes_loop2

exit_sequence_start:
    ld hl,num_squares_byte
    ld a,NUM_BOXES
    cp (hl)
    jp z,start_exit
    inc (hl)
    jp main_loop    


start_exit:
    ld hl,counter
    dec (hl)
    jp nz,main_loop

    ld a,$c3
    ld (exit_sequence_start),a
    ld hl,exit_sequence
    ld (exit_sequence_start+1),hl
    jp main_loop
    
    
counter:
    .db 25
    
exit_sequence:
    ld hl,num_squares_byte
    dec (hl)
    ret z
    ld hl,(boxes_start_address)
    ld de,16
    add hl,de
    ld (boxes_start_address),hl
    jp main_loop
    

    
    
         
boxes:
    .db 61,31,65,33
    .db 61,31,68,34
    .db 61,31,70,35
    .db 61,31,72,36
    .db 60,30,75,37
    .db 60,30,77,38
    .db 60,30,79,40
    .db 59,29,81,41
    .db 58,29,83,42
    .db 58,29,85,43
    .db 57,29,87,44
    .db 57,28,89,45
    .db 56,28,91,46
    .db 55,28,93,47
    .db 54,27,95,47
    .db 53,27,97,48
    .db 53,26,98,49
    .db 52,26,100,50
    .db 51,25,102,51
    .db 50,25,103,52
    .db 48,24,105,52
    .db 47,24,106,53
    .db 46,23,107,54
    .db 45,22,109,54
    .db 43,22,110,55
    .db 42,21,111,56
    .db 41,20,112,56
    .db 39,20,114,57
    .db 38,19,115,57
    .db 36,18,116,58
    .db 34,17,117,58
    .db 33,16,117,59
    .db 31,15,118,59
    .db 29,15,119,60
    .db 27,14,120,60
    .db 25,13,121,60
    .db 23,12,121,61
    .db 21,11,122,61
    .db 19,10,122,61
    .db 17,9,123,61
    .db 15,8,123,62
    .db 13,6,124,62
    .db 11,5,124,62
    .db 8,4,124,62
    .db 6,3,125,63
    .db 4,2,125,63
    .db 1,1,125,63
    .db 0,0,126,63



left = 0
up = 1
right = 2
down = 3
 
boxes_end:


NUM_BOXES = (boxes_end - boxes)/16

draw_box:
    push hl
    
    push hl
    pop ix
    
    ld d,(ix+left)
    ld e,(ix+up)
    ld h,(ix+left)
    ld l,(ix+down)
    dec l
    call Line
    
    ld d,(ix+left)
    ld e,(ix+up)
    ld h,(ix+right)
    dec h
    ld l,(ix+up)
    call Line
    
    ld d,(ix+right)
    ld e,(ix+up)
    ld h,(ix+right)
    ld l,(ix+down)
    dec l
    call Line
    
    
    ld d,(ix+left)
    ld e,(ix+down)
    dec e
    ld h,(ix+right)
    ld l,(ix+down)
    dec l
    call Line
    

    pop hl
    ret


   
    
    

.end
