add_hl_4a:
    add a,a
add_hl_2a:
    add a,a
add_hl_a
    add a,l
    ld l,a
    ret nc
    inc h
    ret
    

 
pause:
    ld b,a
pause_loop:
    halt
    djnz pause_loop
    ret
    
white_screen:
    xor a
    out (2),a
    ld (_contrast),a
    ret
    
fade_in:
    ld c,a
    ld hl,_contrast
fade_in_loop:
    inc (hl)
    ld a,(hl)
    cp normal_contrast
    ret z
    out (2),a
    ld a,c
    call pause
    jr fade_in_loop
    
    
    
int_pause:
    push hl
    ld hl,int_counter
int_pause_loop:
    halt
    cp (hl)
    jr nz,int_pause_loop
    pop hl
reset_int_counter:
    xor a
    ld (int_counter),a
    ret
    
    
;$37 which will be memory $F700->$FB00
enable_planes:
    call clear_screen
    call clear_buffer
    ld a,$37
    out (0),a
    ld hl,disable_planes    
    ret
    
disable_planes:
    call clear_buffer
    ld a,$3c
    out (0),a
    ret
    
draw_screen:
    ld hl,$fc00
    ld de,$f700
    ld bc,1024
    ldir
    ret
    
    
clear_screen:
    ld hl,$f700
    ld (hl),l
    ld de,$f700+1
    ld bc,1023
    ldir
    ret
    
clear_buffer:
    ld hl,$fc00
    ld (hl),l
    ld de,$fc00+1
    ld bc,1023
    ldir
    ret






;----------------------------------------------------------------------
; FIND PIXEL by CLEM  (117 cycles 34 bytes)
;
;  Input: x->b
;            y->c
;
;  Output: hl : byte in LCD memory
;               a  : bitmask for (hl)
;
; Destroyes : bc
;----------------------------------------------------------------------

FindPixel:
     ld h,63
     ld a,c
     add a,a
     add a,a
     ld l,a
     ld a,b
     rra
     add hl,hl
     rra
     add hl,hl
     rra
     or l
     ld l,a
     ld a,b
     and 7
     ld bc,FP_Bits
     add a,c
     ld c,a
     adc a,b
     sub c
     ld b,a
     ld a,(bc)
     ret

FP_Bits:     .db $80,$40,$20,$10,$08,$04,$02,$01


Line:
        ld a,d
        cp h
        jp c,LineOrdered
        ex de,hl
LineOrdered:  
        ld b,d
        ld c,e
        push hl
        push bc
        call FindPixel
        pop bc
        pop de
ConnectedLine:
        push hl
        ld h,c
        ld c,a
        ld a,d
        sub b
        ld b,a
        ld a,e
        jp nz,LineNotPoint
        cp h
        jp nz,LineNotPoint
        pop hl
        ld a,(hl)
        or c
        ld (hl),a
        ret
LineNotPoint:
        sub h
        ld de,16
        jp nc,LinePositiveY
        neg
        ld de,-16
LinePositiveY:  
        cp b
        jp nc,SteepLine
        add a,a
        ld (Line2sm+1),a
        ld h,a
        xor a
        sub b
        add a,a
        ld (Line1sm+1),a
        ld a,h
        sub b
        pop hl
LineLoopGentle: 
        push af
        ld a,(hl)
        or c
        ld (hl),a
        rrc c
        jr nc,$+3
        inc hl
        pop af       
        jp m,Line2sm
Line1sm add a,0
        add hl,de
Line2sm add a,0
        djnz LineLoopGentle
        ld a,(hl)
        or c
        ld (hl),a
        ret

SteepLine:
        ld h,a
        neg
        add a,a
        ld (Line3sm+1),a
        ld a,b
        add a,a
        ld (Line4sm+1),a
        sub h
        ld b,h
        pop hl
LineLoopSteep: 
        push af
        ld a,(hl)
        or c
        ld (hl),a
        add hl,de
        pop af
        jp m,Line4sm
Line3sm add a,0
        rrc c
        jr nc,$+3
        inc hl
Line4sm add a,0
        djnz LineLoopSteep
        ld a,(hl)
        or c
        ld (hl),a
        ret
        
text_picture:
    ld hl,text_pic
    ld de,$fc00
;    jp DispRLE        

;===========================================================
; RLE picture displayer v1.1
; Decodes a RLE picture made by RLE2PIC
;
; written by David Phillips <electrum@tfs.net>
; started: 8/19/98
; last update: 11/5/98
;
; input: HL = RLE encoded picture, DE = where to display
; output: 1024 byte decoded picture
; destroys: AF, BC, DE, HL
; current size: 32 bytes
;===========================================================
DispRLE:
 ld bc,1024         ; we need to copy 
DispRLEL:
 ld a,(hl)          ; get the next byte
 cp $91             ; is it a run?
 jr z,DispRLERun    ; then we need to decode the run
 ldi                ; copy the byte, and update counters
DispRLEC:
 ld a,b             ; check the low byte and
 or c               ; the high byte for 0
 jr nz,DispRLEL     ; if not, then we're not done either
 ret                ; if it's zero, we're done
DispRLERun:
 inc hl             ; move to the run value
 ld a,(hl)          ; get the run value
 inc hl             ; move to the run count
 push hl            ; save source pointer
 ld h,(hl)          ; get the run count
 ex de,hl           ; swap source and destination pointers
DispRLERunL:
 ld (hl),a          ; copy the byte
 inc hl             ; increase destination pointer
 dec bc             ; decrease byte count
 dec d              ; decrease run count
 jr nz,DispRLERunL  ; if we're not done, then loop
 ex de,hl           ; swap pointers back
 pop hl             ; recover source pointer
 inc hl             ; advance the source pointer
 jr DispRLEC        ; check to see if we should loop



display_text:
    ld c,(hl)
    inc hl
    ld b,(hl)
    inc hl
    ld (_curRow),bc
    call _puts
    ld a,(hl)
    cp $ff
    ret z
    jr display_text

display_text2:
    call _homeup
    ld b,7
display_text2_loop:
    push bc
    call _puts
    push hl
    call _newline
    pop hl
    pop bc
    djnz display_text2_loop
    ret
    
text_pic:
; compressed picture made with PIC2RLE
; PIC2RLE by David Phillips <david@acz.org>


 .db $91,$00,$6e,$1f,$91,$00,$0e,$02,$20,$91,$00,$0d
 .db $07,$f2,$60,$91,$00,$0d,$04,$fb,$f4,$91,$00,$0d
 .db $01,$ff,$7f,$80,$91,$00,$0c,$02,$9c,$fe,$70,$91
 .db $00,$0c,$0d,$24,$cb,$91,$00,$0d,$12,$29,$25,$80
 .db $91,$00,$0c,$16,$09,$24,$c0,$91,$00,$0c,$04,$08
 .db $16,$20,$91,$00,$0c,$0c,$08,$10,$3c,$91,$00,$0c
 .db $78,$08,$00,$12,$91,$00,$0c,$88,$e8,$00,$12,$91
 .db $00,$0c,$b9,$30,$60,$12,$91,$00,$0c,$a9,$10,$58
 .db $2a,$91,$00,$0c,$a9,$92,$68,$2a,$91,$00,$0c,$48
 .db $f2,$38,$4a,$91,$00,$0c,$38,$07,$00,$44,$91,$00
 .db $0c,$08,$04,$00,$fc,$91,$00,$0c,$04,$00,$41,$91
 .db $00,$0d,$02,$1d,$c2,$91,$00,$0d,$03,$06,$02,$91
 .db $00,$0e,$c0,$04,$91,$00,$0e,$3f,$f8,$91,$00,$0e
 .db $01,$91,$00,$0f,$03,$91,$00,$0f,$0f,$91,$00,$0f
 .db $17,$91,$00,$0f,$3f,$80,$91,$00,$0e,$3f,$80,$91
 .db $00,$0e,$33,$c0,$91,$00,$0e,$73,$60,$91,$00,$0e
 .db $73,$f8,$91,$00,$0e,$c3,$d8,$91,$00,$0d,$01,$c3
 .db $fc,$91,$00,$0d,$03,$c3,$86,$91,$00,$0d,$07,$83
 .db $87,$91,$00,$0d,$07,$03,$83,$80,$91,$00,$0d,$03
 .db $83,$c0,$91,$00,$0d,$03,$8f,$80,$91,$00,$0d,$03
 .db $80,$91,$00,$0e,$03,$80,$91,$00,$0e,$07,$80,$91
 .db $00,$0e,$0d,$80,$91,$00,$0e,$1f,$e0,$91,$00,$0e
 .db $10,$38,$91,$00,$0e,$e0,$3c,$91,$00,$0d,$03,$e0
 .db $07,$91,$00,$0d,$07,$a0,$03,$80,$91,$00,$0c,$0d
 .db $c0,$01,$e0,$91,$00,$0c,$1b,$80,$01,$e0,$91,$00
 .db $0c,$17,$80,$00,$e0,$91,$00,$0b,$0f,$bc,$00,$00
 .db $f0,$91,$00,$0b,$0f,$e8,$00,$20,$70,$91,$00,$0b
 .db $01,$e0,$00,$3f,$fc,$91,$00,$0e,$03,$a0,$91,$00
 .db $0f,$20,$91,$00,$10

; 1024 bytes compressed to 341 -- 33% of original.

.end