#include "include.inc"
;.plugin lite186


.org _asm_exec_ram


;To do:
; Win Assemlby 03
; Matrix screensaver

SinCosTable = $9000

normal_contrast = 15


cap = $8c
char = $91
char = $a9

    jp program_start

program_start:
   
    
    di
        
    ld hl,$8e00        ;make 256 byte vector table pointing to int
    ld (hl),$8F
    ld bc,256
    ld de,$8e01
    ldir
     
     
    ld hl,int_code            ;copy interrupt to where it'll exec
    ld de,$8f8f
    ld bc,int_end-int_start
    ldir 

    ld a,$8E
    ld i,a         ;load interrupt register with vector table
    im 2           ;set interrupt mode
    ei             ;start the interrupt


    xor a
program_loop:
    ld hl,demos
    cp (hl)
    jr z,exit
    inc a
    push af
    dec hl
    
    call add_hl_2a
    
    call _ldhlind
    di
    rst 20h
    rst 10h
    jr c,quick_exit
    ex de,hl
    ld a,b
    call _get_word_ahl
    push de
    call _set_abs_src_addr
    
    xor a
    pop hl
    call _set_mm_num_bytes
    
    ld hl,demo_exec_ram
    call _set_abs_dest_addr
    
    call _mm_ldir
    
    call _ram_page_1
    ei
    call demo_exec_ram
    
    pop af
    jr program_loop
    

    
quick_exit:
    ld hl,_jforcecmdnochar
    push hl

exit:
    im 1
    ei
    call disable_planes
    call _homeup
    call _clrScrn    
    ret    
            
    
#include "demos.asm"
#include "routines.asm"
#include "animation.asm"
#include "sound.asm"



int_code:
.org $8f8f
int_start:      ;this is what is exec when user int is triggered
;    push af
    ex af,af'
    
    in a,(3)
    bit 1,a
    jp z,leave_int     ;skip if on interrupt
    
;    inc (hl)           ;inc user counter
    ld a,(int_counter)
    inc a
    ld (int_counter),a
    
    ld a,$ff
    out (1),a                       ;clear key port
    
    ld a,%10111111                  ;Exit's row
    out (1),a                       ;send
    nop
    nop
    in a,(1)                        ;get keys
    
    bit 6,a                         ;is Exit pressed?
    jp z,int_quick_exit

leave_int:
    ld a,%00001000
    out (3),a
    ld a,%00001011
    out (3),a
    
    ex af,af'
;    pop af
    
    ei
    reti
    
int_quick_exit:
    ld hl,quick_exit
    ex (sp),hl    
    jr leave_int
    
    
int_end:    

int_counter = $8f8e
    
demo_exec_ram = int_code + int_end - int_start




    .end