//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cShotgun.cpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================

//==============================================================================
// Includes
#include "cShotgun.hpp"

#include "cWorld.hpp"
#include "cBullet.hpp"
#include "cMixer.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace ShootingStar;
//==============================================================================

//==============================================================================
//! Constructor
//------------------------------------------------------------------------------
cShotgun::cShotgun (void):
cWeapon (8, 1000, 2500),
mSound (cMixer::GetInstance ().LoadSound ("shotgun.wav")),
mReloadSound (cMixer::GetInstance ().LoadSound ("shotgunreload.wav"))
{
	SetAmmo (8, 3);
};
//==============================================================================

//==============================================================================
//! Destructor
//------------------------------------------------------------------------------
cShotgun::~cShotgun (void)
{
	// Empty
};
//==============================================================================

//==============================================================================
void 
cShotgun::Fire (const cVector2f &position, float angle)
{
	cMixer::GetInstance ().PlaySound (mSound);
	
	SpawnSuuliekki ();
	
	for ( int i = 0; i < 16; i++ )
	{
		// Spawn a bullet object
		cBullet *pBullet = new cBullet;
		pBullet->SetPosition (position);
		pBullet->SetRotation (angle);
		pBullet->SetOwner (GetOwner ());
	
		pBullet->Rotate (-5.0f + 10.0f * rand () / (RAND_MAX + 1.0f));
		pBullet->Move (0.0f, 2.5f + 0.5f * rand () / (RAND_MAX + 1.0f));
		pBullet->SetVelocity (pBullet->GetDirection () * 2.0f);
		pBullet->SetDamage (1);
		cWorld::GetInstance ().SpawnObject (pBullet);
	}
}
void cShotgun::BeginReload (void) {

	cMixer::GetInstance ().PlaySound (mReloadSound,7);

}
//==============================================================================

//==============================================================================
// EOF
//==============================================================================
