//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cOptions.cpp
// Project: Shooting Star
// Author: 
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================

//==============================================================================
// Includes
#include "cOptions.hpp"
#include <stdexcept>
#include "cMixer.hpp"
#include "Debug.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace ShootingStar;
//==============================================================================


//! Constructor
cOptions::cOptions (void)
{
	// Empty
};

//! Destructor
cOptions::~cOptions (void)
{
	// Empty
};

//! Save options
void 
cOptions::Save (string filename)
{
	ofstream fout;
	try
	{
		dbgInfo () << "Saving options to file " << filename << '\n';
	
		// Open file for writing
		fout.open (filename.c_str ());
		if ( !fout )
		{
			dbgError () << "Unable to open file " << filename << " for writing\n";
			throw runtime_error ("Unable to save options");
		}
		
		// Save player 1 keys
		fout << "Player 1 keys:";
		SaveKeys (fout, mPlayer1Keys);		
		
		// Save player 2 keys
		fout << "Player 2 keys:";
		SaveKeys (fout, mPlayer2Keys);
		
		// Save options
		fout << "Fullscreen:";
		SaveBool (fout, mFullscreen);
		fout << "640x480 mode:";
		SaveBool (fout, mLowRes);
		fout << "Sound:";
		SaveBool (fout, mSound);
		fout << "Music:";
		SaveBool (fout, mMusic);
		fout << "Frame skipping:";
		SaveBool (fout, mFrameSkip);
		fout << "Frame delay:";
		SaveBool (fout, mDelay);

		// Close the file
		fout.close ();
	}
	catch ( ... )
	{
		fout.close ();
		throw;
	}
}

//! Load options
void 
cOptions::Load (string filename)
{
	ifstream fin;
	try
	{
		dbgInfo () << "Loading options from file " << filename << '\n';
	
		// Open file for reading
		fin.open (filename.c_str ());
		if ( !fin )
		{
			dbgError () << "Unable to open file " << filename << " for reading\n";
			throw runtime_error ("Unable to load options");		
		}
		
		char buffer[80];
		
		// Load player 1 keys
		fin.getline (buffer, 80, ':');
		LoadKeys (fin, mPlayer1Keys);
		
		// Load player 2 keys
		fin.getline (buffer, 80, ':');
		LoadKeys (fin, mPlayer2Keys);
		
		// Load options
		fin.getline (buffer, 80, ':');
		LoadBool (fin, mFullscreen);
		fin.getline (buffer, 80, ':');
		LoadBool (fin, mLowRes);
		fin.getline (buffer, 80, ':');
		LoadBool (fin, mSound);
		fin.getline (buffer, 80, ':');
		LoadBool (fin, mMusic);
		fin.getline (buffer, 80, ':');
		LoadBool (fin, mFrameSkip);
		fin.getline (buffer, 80, ':');
		LoadBool (fin, mDelay);
	
		// Close the file
		fin.close ();
	}
	catch ( ... )
	{
		fin.close ();
		throw;
	}
	
	cMixer::GetInstance ().EnableMusic (mMusic);
	cMixer::GetInstance ().EnableSounds (mSound);
}

void 
cOptions::SaveKeys (ofstream &fout, tPlayerKeys &keys)
{
	int key;
	for ( int i = 0; i < tPlayerKeys::NumberOfKeys; i++ )
	{
		key = keys.keys[i];
		fout << key;
		if ( i < tPlayerKeys::NumberOfKeys - 1 )
			fout << ' ';
		else
			fout << '\n';
		if ( !fout )
		{
			dbgError () << "Unable to write to options file\n";
			throw runtime_error ("Unable to save options");
		}
	}
}

void 
cOptions::LoadKeys (ifstream &fin, tPlayerKeys &keys)
{
	int key;
	for ( int i = 0; i < tPlayerKeys::NumberOfKeys; i++ )
	{
		fin >> key;
		if ( !fin )
		{
			dbgError () << "Unable to read from options file\n";
			throw runtime_error ("Unable to load options");
		}
		int (keys.keys[i]) = key;	// IS THIS SAFE?
	}
}

void 
cOptions::SaveBool (ofstream &fout, bool value)
{
	if ( value )
		fout << "enabled\n";
	else
		fout << "disabled\n";

	if ( !fout )
	{
		dbgError () << "Unable to write to options file\n";
		throw runtime_error ("Unable to save options");
	}
}

void 
cOptions::LoadBool (ifstream &fin, bool &value)
{
	char buffer[80];
	fin.getline (buffer, 80);
	if ( !fin )
	{
		dbgError () << "Unable to read from options file\n";
		throw runtime_error ("Unable to load options");
	}
	if ( string (buffer) == string ("disabled") )
		value = false;
	else
		value = true;
	
}

//==============================================================================
// EOF
//==============================================================================
