//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cMedPack.cpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================

//==============================================================================
// Includes
#include "cMedPack.hpp"
#include "cMixer.hpp"
#include "cHurtable.hpp"
#include "cAnimationManager.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace ShootingStar;
//==============================================================================

//==============================================================================
//! Constructor
//------------------------------------------------------------------------------
cMedPack::cMedPack (void):
mPower (100),
mSound (cMixer::GetInstance ().LoadSound ("pickup.wav"))
{
	SetCollisionModel (CollisionModel_Circle);
	SetCollisionRadius (20.0f);
	SetVelocity (cVector2f (0.0f, 0.0f));

	mAnimation.SetAnimation (cAnimationManager::GetInstance ().LoadAnimation ("medpack"));
	mAnimation.SetNumberOfFrames (1);
	mAnimation.SetFrameDelay (999999);

	SetLayer (-10);
};
//==============================================================================

//==============================================================================
//! Destructor
//------------------------------------------------------------------------------
cMedPack::~cMedPack (void)
{
	// Empty
};
//==============================================================================

//==============================================================================
//! Called when object collides with other object
void 
cMedPack::OnObjectCollision (cCollidable *pOther)
{
	cHurtable *pHurtable = dynamic_cast<cHurtable*>(pOther);
	if ( pHurtable != NULL )
	{
		if ( pHurtable->GetHealth () < pHurtable->GetMaxHealth () )
		{
			cMixer::GetInstance ().PlaySound (mSound);
			pHurtable->GainHealth (mPower);
			Kill ();
		}
	}
}
//==============================================================================

//==============================================================================
// EOF
//==============================================================================
