//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cExplosionSystem.cpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================

//==============================================================================
// Includes
#include "cExplosionSystem.hpp"
#include "cTextureManager.hpp"
#include "cBurnable.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace ShootingStar;
//==============================================================================


//! Constructor
cExplosionSystem::cExplosionSystem (void):
cParticleSystem (100),
mDeltaTime (0)
{
	SetTexture (cTextureManager::GetInstance ().LoadTexture ("tuli2.png"));
	SetAngleVariation (360.0f);
	SetSpeed (0.3f, 0.6f);
	SetSize (32.0f, 128.0f);
	SetEnergy (700, 0.9f);
	SetBlending (true);
	SetEmitDelay (0);
	SetStartColor (1.0f, 1.0f, 1.0f, 1.0f);
	SetEndColor (1.0f, 0.5f, 0.5f, 0.0f);
	KillEmptySystem (true);
  
	SetCollisionModel (CollisionModel_Particle);
  	SetCollidableParticles (GetParticles (), cParticleSystem::GetNumberOfParticles ());
	SetVelocity (cVector2f (0.0f, 0.0f));
	SetLayer (5);
};

//! Destructor
cExplosionSystem::~cExplosionSystem (void)
{
	// Empty
};

void 
cExplosionSystem::Update (Uint32 deltaTime)
{
	// Call base
	cParticleSystem::Update (deltaTime);

	mDeltaTime = deltaTime;
}

//! Called when object collides with other object
void 
cExplosionSystem::OnObjectCollision (cCollidable *pOther)
{
	cBurnable *pVictim = dynamic_cast<cBurnable*> (pOther);
	if ( pVictim != NULL )
		pVictim->Burn (mDeltaTime, GetOwner ());
}

//==============================================================================
// EOF
//==============================================================================
