//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cObject.hpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef cObject_hpp
#define cObject_hpp
//==============================================================================
// Includes
#include <list>
#include "Types.hpp"
#include "cIdentifiable.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
class cWorld;
//==============================================================================
	
//==============================================================================
//! Base class of all objects
//------------------------------------------------------------------------------
class cObject : public cIdentifiable
{
	// Constructor & Destructor
	public:
		//! Constructor
		cObject (void);
		//! Destructor
		virtual ~cObject (void);
	
	// Public methods
	public:
		//! Updating interface
		virtual void Update (Uint32 deltaTime) = 0;

		//! Is this object alive
		bool IsAlive (void) const { return mAlive; };
		//! Spawn this object (used in cWorld)
		void Spawn (void) { mAlive = true; };
		//! Kill this object
		void Kill (void);
		void SetParent (cObject *pParent);
		
		//! Add reference
		void AddReference (void);
		//! Release reference
		void ReleaseReference (void);
		
		static void CollectGarbage (void);
		static void CleanUp (void);
		
		static int GetObjectCount (void) { return mObjects.size (); };
		static int GetGarbageCount (void) { return mGarbageObjects.size (); };
	// Member variables
	private:
		static list<cObject*> mObjects;
		static list<cObject*> mGarbageObjects;
		static bool mCleanUp;
	
		int mReferenceCount;
		bool mAlive;
		cObject *mpParent;
		list<cObject*> mChildren;
};
//==============================================================================

//==============================================================================
}		// End of the ShootingStar namespace
#endif // cObject_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
