//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cSoldier.hpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef cSoldier_hpp
#define cSoldier_hpp
//==============================================================================
// Includes
#include <vector>
#include <string>
#include "cSprite.hpp"
#include "cBurnable.hpp"
#include "cParticleEmitter.hpp"
#include "cAnimationHandle.hpp"
#include "cPointer.hpp"
#include "cWeapon.hpp"
#include "cParticleSystem.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
class cWeapon;
//==============================================================================
	
//==============================================================================
//! Soldier
//------------------------------------------------------------------------------
class cSoldier : public cSprite, public cBurnable, public cParticleEmitter
{
	// Constructor & Destructor
	public:
		//! Constructor
		cSoldier (string animationPrefix);
		//! Destructor
		virtual ~cSoldier (void);
	
	// Public methods
	public:
		void PullTrigger (void);
		void ReleaseTrigger (void);
	
		void TurnLeft (void)
		{ 
			mTurning = true; 
			mTurningRight = mTurnToTarget = false; 
		};
		void TurnRight (void) 
		{ 
			mTurning = mTurningRight = true; 
			mTurnToTarget = false;
		};
		void StopTurning (void)
		{ 
			mTurning = mTurningRight = false; 
			mTurnToTarget = false;
		};
		void TurnTo (float target)
		{
			mTurningRight = false;
			mTurning = mTurnToTarget = true;
			mTurnTarget = target;
		}
		
		void EnableFineAim (void) { mFineAim = true; };
		void DisableFineAim (void) { mFineAim = false; };
		
		void WalkForward (void) { mWalking = true; mWalkingBackward = false; };
		void WalkBackward (void) { mWalking = mWalkingBackward = true; };
		void StopWalking (void) { mWalking = mWalkingBackward = false; };
	
		//! Rendering interface
		virtual void Render (Uint32 deltaTime);
		//! Updating interface
		virtual void Update (Uint32 deltaTime);
	
		//! Add weapon
		void AddWeapon (cWeapon *pWeapon);
		//! Change to next weapon
		void NextWeapon (void);
		//! Change to previous weapon
		void PreviousWeapon (void);
		//! Remove all weapons
		void RemoveWeapons (void);
	
		//! Return current weapon
		cWeapon *GetCurrentWeapon (void);
		
		virtual void OnLevelChanged (void);
	
		//! Called when object is hurt
		virtual void OnHurt (int amount, const cVector2f &direction, ObjectID attacker); 
		virtual void OnDeath (void);
		
	// Member variables
	protected:
		bool mTurning;
		bool mTurningRight;
		bool mTurnToTarget;
		float mTurnTarget;
		bool mFineAim;
	
		bool mWalking;
		bool mWalkingBackward;
	
	// Member variables
	protected:
		vector<cPointer<cWeapon> > mWeapons;
		int mCurrentWeapon;
	private:
		Uint32 mSoundDeath;
		Uint32 mSoundHurt;
	
		cAnimationHandle mStandAnim;
		cAnimationHandle mWalkAnim;
		cAnimationHandle mShootAnim;
		cAnimationHandle mWalkShootAnim;
	
		enum AnimationType
		{
		  Animation_Stand,
		  Animation_Walk,
		  Animation_Shoot,
		  Animation_WalkShoot
		};
		AnimationType mCurrentAnimation;
		
		cPointer<cParticleSystem> mBlood;
};
//==============================================================================

//==============================================================================
}		// End of the ShootingStar namespace
#endif // cSoldier_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
