/*
    ffx.cpp

    ejemplo de efecto para los fast_code.

    iq + una-i
*/

#include <windows.h>
#include <math.h>
#include <stdlib.h>

int xres=320;
int yres=240;
int bpp = 32;

#define RGB32(r, g, b) (0xFF000000 | (((long) ((r) * 255)) << 16) | (((long) ((g) * 255)) << 8) | (long) ((b) * 255))
#define RGBA32(r, g, b, a) ((((long) ((a) * 255)) << 24) | (((long) ((r) * 255)) << 16) | (((long) ((g) * 255)) << 8) | (long) ((b) * 255))


extern void set_palette( long *palette );
extern void set_color( int i, int r, int g, int b );

long *Buffer;

void DrawLine (int x1, int y1, int x2, int y2, long Color)
{
/*	int aux;
	if (x2 < x1)
	{
		aux = x2;
		x2 = x1;
		x1 = aux;
	}
	if (y2 < y1)
	{
		aux = y2;
		y2 = y1;
		y1 = aux;
	}*/

	if (x2 - x1 >= y2 - y1)
	{
		for (int x = x1; x < x2; x ++)
			Buffer [(y1 + ((x - x1) * (y2 - y1) / (x2 - x1))) * 320 + x] = Color;
	}
	else
		for (int y = y1; y < y2; y ++)
			Buffer [(x1 + ((y - y1) * (x2 - x1) / (y2 - y1))) + y * 320] = Color;
}


void DrawBox (int x1, int y1, int x2, int y2, long Color)
{
	long *p;
	int x, y;

//	if ((Color  & 0xFF000000) == 0xFF000000)
	{
		for (y = y1; y <= y2; y ++)
			for (x = x1, p = &Buffer [y * 320 + x1]; x <= x2; x ++)
				*(p ++) = Color;
	}
/*	else
	{
		for (y = y1; y <= y2; y ++)
			for (x = x1, p = &Buffer [y * 320 + x1]; x <= x2; x ++)
			{
				long a = 0xFF;//(Color >> 24);
				long c = Color & 0xFFFFFF;
				long o = (*p);
				long r = (((((c & 0xFF0000) * a + (o & 0xFF0000) * (0xFF - a)) & 0xFF0000) + 1) >> 8);
				long g = (((((c & 0xFF00) * a + (o & 0xFF00) * (0xFF - a)) & 0xFF00) + 1) >> 8);
				long b = (((((c & 0xFF) * a + (o & 0xFF) * (0xFF - a)) & 0xFF) + 1) >> 8);
				*p = 0x000000 | 
					r |
					g |
					b;
				p ++;
			}
	}*/
}


void DrawLevels (int x, int y, int Count)
{
	const long Colors [10] = {
		RGB32 (1, 0, 0),
		RGB32 (1, 0.25, 0),
		RGB32 (1, 0.5, 0),

		RGB32 (1, 0.75, 0),
		RGB32 (1, 1, 0),
		RGB32 (0.75, 1, 0),

		RGB32 (0.5, 1, 0),
		RGB32 (0.3, 1, 0),
		RGB32 (0.2, 1, 0),
		RGB32 (0.1, 1, 0)
	};
	
	if (Count <= 0)
		return;
	if (Count > 10)
		Count = 10;

	int i = 10 - Count;
	y += 4 * i;

	while (i < 10)
	{
		DrawBox (x, y, x + 6, y + 2, Colors [i]);
		y += 4;
		i ++;
	}
}


long LineData [70] [200];

int FFX_Init( void *buffer )
{
		srand (timeGetTime ());
		for (int l = 0; l < 70; l ++)
			for (int i = 0; i < 200; i ++)
			{
				long r = rand () * 100 / RAND_MAX;
				if (r > 92)
					LineData [l] [i] = RGB32 (0.8, 0.8, 0.8);
				else if (r > 85)
					LineData [l] [i] = RGB32 (0.6, 0.6, 0.6);
				else if (r < 10)
					LineData [l] [i] = RGB32 (0.06, 0.06, 0.06);
				else
					LineData [l] [i] = 0;
			}
    return( 1 );
}

int Levels [8] = { 0, 0, 0, 0, 0, 0, 0, 0 };

void FFX_DoFrame( void *buffer, float time )
{
    Buffer = (long*) buffer;
		DrawBox (0, 0, 319, 239, RGB32 (0.7, 0.6, 0.2));

		// Show levels
		DrawBox (220, 70, 309, 112, RGB32 (0, 0, 0));
		float f = (float) (fmod (time, 0.5) / 0.5 * 2 - 1);
		if (f < 0) f = 0;
				
		Levels [0] = (int) (10.499999f * (1 - f * f * f));
		Levels [1] = (int) (2.499999f * (1 - (float) (fmod (time, 0.25) / 0.25 * 2 - 1)));
		Levels [4] = (int) (8.0 * sin (time * 20) * sin (time * 6));
		Levels [5] = (int) (6.0 * sin (time * 3) * tan (time * 4.5));

		for (int i = 0; i < 8; i ++)
			DrawLevels (222 + i * 9,  72, Levels [i]);

		// Show sources
		DrawBox (10, 140, 209, 229, RGB32 (0, 0, 0));
		int Line = (int) (time * 50);
		for (int y = 145; y < 224; y ++)
		{
			Line = (Line + 1) % 70;
			if ((Line % 20) < 5)
				continue;
			memcpy (&Buffer [y * 320 + 15], LineData [Line], sizeof (long) * 190);
		}

		// Draw lines
		DrawLine (100 + 10 * sin (time * 10), 20 + 10 * cos (time * 10), 100 - 10 * sin (time * 10), 20 - 10 * cos (time * 10), 0);

		// Sign screen
		DrawLine (260, 220, 270, 220, 0);
		DrawLine (270, 220, 260, 230, 0);
		DrawLine (260, 230, 270, 230, 0);

		DrawLine (275, 220, 275, 230, 0);
		DrawLine (275, 220, 280, 225, 0);
		DrawLine (280, 225, 285, 220, 0);
		DrawLine (285, 220, 285, 230, 0);

		DrawLine (290, 220, 290, 230, 0);
		DrawLine (290, 220, 300, 220, 0);
		DrawLine (290, 230, 300, 230, 0);
		DrawLine (299, 225, 299, 230, 0);
		DrawLine (295, 225, 299, 225, 0);
}

void FFX_End( void )
{
}
