/*
    ffx.cpp

    ejemplo de efecto para los fast_code.

    iq + una-i
*/


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>

int xres=640;
int yres=480;
int bpp = 32;

char fontch[]="0123456789ABCDEFG:.#|";
char font[]=
{
	1,1,1,1,1,0,
	1,0,0,0,1,0,
	1,0,0,0,1,0,
	1,0,0,0,1,0,
	1,0,0,0,1,0,
	1,0,0,0,1,0,
	1,0,0,0,1,0,
	1,1,1,1,1,0,

	0,0,1,0,0,0,
	0,0,1,0,0,0,
	0,0,1,0,0,0,
	0,0,1,0,0,0,
	0,0,1,0,0,0,
	0,0,1,0,0,0,
	0,0,1,0,0,0,
	0,0,1,0,0,0,

	1,1,1,1,1,0,
	1,0,0,0,1,0,
	0,0,0,0,1,0,
	0,0,0,0,1,0,
	0,1,1,1,0,0,
	1,0,0,0,0,0,
	1,0,0,0,0,0,
	1,1,1,1,1,0,

	1,1,1,1,0,0,
	0,0,0,0,1,0,
	0,0,0,0,1,0,
	0,0,1,1,1,0,
	0,0,0,0,1,0,
	0,0,0,0,1,0,
	0,0,0,0,1,0,
	1,1,1,1,0,0,

	0,0,0,0,1,0,
	1,0,0,0,1,0,
	1,0,0,0,1,0,
	0,1,1,1,1,0,
	0,0,0,0,1,0,
	0,0,0,0,1,0,
	0,0,0,0,1,0,
	0,0,0,0,1,0,

	1,1,1,1,1,0,
	1,0,0,0,0,0,
	1,0,0,0,0,0,
	1,1,1,1,0,0,
	0,0,0,0,1,0,
	0,0,0,0,1,0,
	0,0,0,0,1,0,
	1,1,1,1,0,0,

	0,1,1,1,1,0,
	1,0,0,0,0,0,
	1,0,0,0,0,0,
	1,1,1,1,0,0,
	1,0,0,0,1,0,
	1,0,0,0,1,0,
	1,0,0,0,1,0,
	0,1,1,1,0,0,

	1,1,1,1,1,0,
	0,0,0,0,1,0,
	0,0,0,0,1,0,
	0,0,0,0,1,0,
	0,0,1,1,1,0,
	0,0,0,0,1,0,
	0,0,0,0,1,0,
	0,0,0,0,1,0,

	0,1,1,1,0,0,
	1,0,0,0,1,0,
	1,0,0,0,1,0,
	0,1,1,1,0,0,
	1,0,0,0,1,0,
	1,0,0,0,1,0,
	1,0,0,0,1,0,
	0,1,1,1,0,0,

	0,1,1,1,1,0,
	1,0,0,0,1,0,
	1,0,0,0,1,0,
	0,1,1,1,1,0,
	0,0,0,0,1,0,
	0,0,0,0,1,0,
	0,0,0,0,1,0,
	0,0,0,0,1,0,

	0,1,1,1,0,0,
	1,0,0,0,1,0,
	1,0,0,0,1,0,
	1,1,1,1,1,0,
	1,0,0,0,1,0,
	1,0,0,0,1,0,
	1,0,0,0,1,0,
	1,0,0,0,1,0,

	1,1,1,1,0,0,
	1,0,0,0,1,0,
	1,0,0,0,1,0,
	1,1,1,1,0,0,
	1,0,0,0,1,0,
	1,0,0,0,1,0,
	1,0,0,0,1,0,
	1,1,1,1,0,0,

	0,1,1,1,1,0,
	1,0,0,0,0,0,
	1,0,0,0,0,0,
	1,0,0,0,0,0,
	1,0,0,0,0,0,
	1,0,0,0,0,0,
	1,0,0,0,0,0,
	0,1,1,1,1,0,

	1,1,1,1,0,0,
	1,0,0,0,1,0,
	1,0,0,0,1,0,
	1,0,0,0,1,0,
	1,0,0,0,1,0,
	1,0,0,0,1,0,
	1,0,0,0,1,0,
	1,1,1,1,0,0,

	0,1,1,1,1,0,
	1,0,0,0,0,0,
	1,0,0,0,0,0,
	1,1,1,0,0,0,
	1,0,0,0,0,0,
	1,0,0,0,0,0,
	1,0,0,0,0,0,
	0,1,1,1,1,0,

	0,1,1,1,1,0,
	1,0,0,0,0,0,
	1,0,0,0,0,0,
	1,1,1,0,0,0,
	1,0,0,0,0,0,
	1,0,0,0,0,0,
	1,0,0,0,0,0,
	1,0,0,0,0,0,

	1,1,1,1,1,0,
	1,0,0,0,0,0,
	1,0,0,0,0,0,
	1,0,1,1,1,0,
	1,0,0,0,1,0,
	1,0,0,0,1,0,
	1,0,0,0,1,0,
	1,1,1,1,1,0,

	0,0,0,0,0,0,
	0,0,1,1,0,0,
	0,0,1,1,0,0,
	0,0,0,0,0,0,
	0,0,0,0,0,0,
	0,0,1,1,0,0,
	0,0,1,1,0,0,
	0,0,0,0,0,0,

	0,0,0,0,0,0,
	0,0,0,0,0,0,
	0,0,0,0,0,0,
	0,0,0,0,0,0,
	0,0,0,0,0,0,
	0,0,0,0,0,0,
	0,0,1,1,0,0,
	0,0,1,1,0,0,

	0,1,0,1,0,0,
	1,1,1,1,1,0,
	0,1,0,1,0,0,
	0,1,0,1,0,0,
	0,1,0,1,0,0,
	0,1,0,1,0,0,
	1,1,1,1,1,0,
	0,1,0,1,0,0,

	0,0,1,1,0,0,
	0,0,1,1,0,0,
	0,0,1,1,0,0,
	0,0,1,1,0,0,
	0,0,1,1,0,0,
	0,0,1,1,0,0,
	0,0,1,1,0,0,
	0,0,1,1,0,0,
};

void drawchar(long* buf,int size,long pos,	long col, char ch)
{
	int k,j,m,n;
	int i=0;
	while (fontch[i]!=ch && fontch[i]) i++;
	k=i*6*8;
	if (!fontch[i]) return;
	for (j=0;j<8;j++)
	{
		for (m=0;m<size;m++)
		{
			for (i=0;i<6;i++)
			{
				for (n=0;n<size;n++)
				{
					if (font[k]) buf[pos]=col;
					pos++;
				}
				k++;
			}
			pos+=xres-6*size;
			k-=6;
		}
		k+=6;
	}
}


void drawstring(long* buf,int size,long pos,	long col, char *strin)
{
	int i,j;
	i=0;
	while (strin[i])
	{
		drawchar (buf,size,pos,col,strin[i]);
		pos+=6*size;
		i++;
	}
}

 // "| ... .. |"

#define pattx 4
#define patty 20

char *patt[pattx*patty];

void rand_note (char *strng)
{
	int k;

	k=(rand()%7)+'A';
	strng[2]=k;
	k=rand()%2;
	if (k) strng[3]='#'; else strng[3]='.';
	k=(rand()%7)+'2';
	strng[4]=k;
	k=rand()%2;
	if (k)
	{
		k=(rand()%7)+'A';
		strng[6]=k;
		k=(rand()%10)+'0';
		strng[7]=k;
		k=(rand()%10)+'0';
		strng[8]=k;
	}

}

void rand_patt (void)
{
	int i,j,k;
	for (j=0;j<patty*pattx;j++)
	{
		patt[j]=(char*)malloc(12);
		patt[j][0]='|';
		patt[j][1]=' ';
		patt[j][2]='.';
		patt[j][3]='.';
		patt[j][4]='.';
		patt[j][5]=' ';
		patt[j][6]='.';
		patt[j][7]='.';
		patt[j][8]='.';
		patt[j][9]=' ';
		patt[j][10]='|';
		patt[j][11]=0;
	}

	for (i=0;i<pattx*patty/4;i++)
	{
		j=rand()%pattx;
		k=rand()%patty;
		rand_note(patt[j+k*pattx]);
	}

}

void draw_patt (long* buf, long pos, int offs)
{
	int i,j;
	for (j=0;j<patty;j++)
		for (i=0;i<pattx;i++)
			drawstring(buf,2,pos+i*12*6*2+((j+offs)%patty)*xres*9*2,0xffffffff,patt[pattx*j+i]);
}

extern void set_palette( long *palette );
extern void set_color( int i, int r, int g, int b );

int *polla;

int FFX_Init( void *buffer )
{
	int i,j;
	polla=(int*)malloc(xres*yres*4);
	for (j=0;j<yres;j++)
		for (i=0;i<xres;i++)
			polla[i+j*xres]=(int)(128+127*sin((float)i*(float)j*0.0001))+
							((int)(128+127*sin((float)i*0.03+(float)j*0.01))<<8);

	rand_patt();
    return( 1 );
}

float old_time=0.0f;
int	  patt_offset=0;

void FFX_DoFrame( void *buffer, float time )
{
    int     i,j,k;
    long    *mibuf = (long*)buffer;
	char merda[100];

	if ((time-old_time)>0.2f) 
	{
		old_time=time;
		patt_offset=(patt_offset+1)%patty;
	}

	sprintf(merda,"%8.2f\0",time);

    //long    *mibuf = (long*)buffer;

	j=(int)(time*100.0);
	k=xres*yres;
	for (i=0; i<xres*yres;i++)
		mibuf[i]=polla[(i+j)%k];
	drawstring(mibuf,3,100+10*xres,0xffffffff,merda);
	draw_patt(mibuf,xres*100+40,patty-patt_offset-1);
	/*    for( i=0; i<yres; i++ )
        {
        mibuf[xres*i+i] = (unsigned char) 255;//0xffff8040;
        //mibuf[xres*i+i] = 0xff4080ff;
        }*/
}

void FFX_End( void )
{
}
