/* SuperDuper texture handler */
/* SoopaDoopa 2001 */

#include "texture.h"
#include "malloc.h"
#include "gif.h"
#include "dma.h"

#define dd(a,b) a,b
#define wwd(a,b) ((((long)b)<<32)+(long)a)
#define hhw(a,b) ((((long)b)<<16)+(long)a)

static char *filestart,*filepos;

typedef struct texture_pcxheader
{
	int encoding;
	int bitsperpixel;
	int minx,maxx,miny,maxy;
	int nplanes;
	int bytesperline;
	int sizex;
	int sizey;
}texture_pcxheader;

static texture_pcxheader header; 

void texture_pcxreadinit(char *file)
{
	filestart=file;
	filepos=file;
}

void texture_pcxreadreset()
{
	filepos=filestart;
}

int texture_pcxreadbyte()
{
	filepos++;
	
	return (*(filepos-1))&255;
}

int texture_pcxreadword()
{
	int lo,hi;

	lo=255&(texture_pcxreadbyte());
	hi=255&(texture_pcxreadbyte());
	
	return (hi<<8)+lo;
}

void texture_pcxreadheader()
{
	int t;
	
	texture_pcxreadreset();

	texture_pcxreadbyte();
	texture_pcxreadbyte();
	header.encoding=texture_pcxreadbyte();
	header.bitsperpixel=texture_pcxreadbyte();
	header.minx=texture_pcxreadword();
	header.miny=texture_pcxreadword();
	header.maxx=texture_pcxreadword();
	header.maxy=texture_pcxreadword();

	for(t=0;t<53;t++)texture_pcxreadbyte();

	header.nplanes=texture_pcxreadbyte();
	header.bytesperline=texture_pcxreadword();

	header.sizex=header.maxx-header.minx+1;
	header.sizey=header.maxy-header.miny+1;
}

static int64 log(int a)
{
	int r=0;
	
	a--;
	while(a>0)
	{
		a=a>>1;
		r++;
	}
	
	return r;
}

static void texture_update(texture *tex)
{
	tex->TH=log(tex->height);
	tex->TW=log(tex->width);
}

int64 texture_TEX0(texture* tex)
{
	texture_update(tex);
	
	if(tex->bitsperpixel==32)
	return ((int64)1<<34)+(tex->TH<<30)+(tex->TW<<26)+(0<<20)+(((tex->width/64)&63)<<14)+(tex->addr/256);
	return ((int64)1<<61)+(((int64)tex->clutaddr/256)<<37)+((int64)1<<34)+(tex->TH<<30)+(tex->TW<<26)+(0x13<<20)+(((tex->width/64)&63)<<14)+(tex->addr/256);
}

int64 texture_TEX1(texture* tex)
{
	return 0;
}

int64 texture_TEX2(texture* tex)
{
	return texture_TEX0(tex);
}

void texture_pcxreaddata(char *dest, int skip)
{
	int t,x,y;
	
	static char line[4096*4];
	
	texture_pcxreadreset();
	
	for(t=0;t<128;t++)texture_pcxreadbyte();
	
	for(y=0;y<header.sizey;y++)
	{
		x=0;
		while(x<header.bytesperline*header.nplanes)
		{
			int b=texture_pcxreadbyte();

			if((b&0xc0)==0xc0)
			{
				int b2=texture_pcxreadbyte();
				b-=192;
				while(b>0)
				{
					line[x]=b2;
					x++;
					b--;
				}
			}
			else
			{
				line[x]=b;
				x++;
			}
		}
		
		for(x=0;x<header.sizex;x++)
		{
			if(skip==-1) //alpha
			{
				dest[(y*header.sizex+x)*(4)+3]=((255&(int)(line[x]))>>1);
			}
			else
			{
				for(t=0;t<header.nplanes;t++)
					dest[(y*header.sizex+x)*(header.nplanes+skip)+t]=line[x+t*header.bytesperline];
				for(;t<header.nplanes+skip;t++)
					dest[(y*header.sizex+x)*(header.nplanes+skip)+t]=127;
			}
		}
	}
}

void texture_pcxreadpal(int *dest)
{
	int t;
	
	texture_pcxreadbyte();

	for(t=0;t<256;t++)
	{
		int r=texture_pcxreadbyte();
		int g=texture_pcxreadbyte();
		int b=texture_pcxreadbyte();
		dest[t]=rgb(r,g,b)+0x7f000000;
	}
}

void texture_load(texture *tex, char *file)
{
	texture_pcxreadinit(file);

	texture_pcxreadheader();


	if(header.nplanes==3)
	{
		tex->bitsperpixel=32;
		tex->width=header.sizex;
		tex->height=header.sizey;
		tex->image=malloc((tex->width*tex->height*tex->bitsperpixel)/8);
		tex->clut=0;
		texture_pcxreaddata((char*)tex->image,1);
	}
	else
	{
		tex->bitsperpixel=8;
		tex->width=header.sizex;
		tex->height=header.sizey;
		tex->image=malloc((tex->width*tex->height*tex->bitsperpixel)/8);
		tex->clut=malloc(4*256);
		texture_pcxreaddata((char*)tex->image,0);
		texture_pcxreadpal((int*)tex->clut);
	}

}

void texture_loadalpha(texture *tex, char *file)
{
	texture_pcxreadinit(file);

	texture_pcxreadheader();

	texture_pcxreaddata((char*)tex->image,-1);
}

void texture_init(texture *tex)
{
	tex->bitsperpixel=32;
	tex->width=256;
	tex->height=256;
	tex->image=0;//malloc((tex->width*tex->height*tex->bitsperpixel)/8);
	tex->clut=0;
}

static int128	list[40];

#define MAXTRANSFER (128*128)

static void send(int128 *p, int length)
{
	while(length>0)
	{
		gif_env;
		
		int thislength;
		
		if(length>MAXTRANSFER)
		{
			thislength=MAXTRANSFER;
			length-=MAXTRANSFER;
		}
		else
		{
			thislength=length;
			length=0;
		}

		gif_begin(list);
		gif_tag(0,0,2,0,0);
		gif_endimagemode(thislength);

		FlushCache(0);
		dma02_wait();

		dma02_send(list,gif_length,0x101);

		dma02_wait();
		dma02_send(p,thislength,0x101);
		dma02_wait();

		p+=MAXTRANSFER;
	}
}

void texture_upload(texture *tex, int addr)
{
	int t;
	int width=tex->width,height=tex->height;


	FlushCache(0);

	dma02_wait();

	if(tex->bitsperpixel==32)
	{
		gif_env;
		
		gif_begin(list);
		gif_tag(0xe,1,0,0,0);
		gVEC(0x50,wwd(0x0000000,0x000000+addr/256+(width<<10)));
		gVEC(0x51,wwd(0,hhw(0,0)));
		gVEC(0x52,wwd(width,height));
		gVEC(0x53,0);
		gif_endfinal();

		FlushCache(0);
		dma02_wait();

		dma02_send(list,gif_length,0x101);

		dma02_wait();

		send((int128*)(tex->image),(height*width)/4);
	}
	else
	{
		gif_env;
		
		gif_begin(list);
		gif_tag(0xe,1,0,0,0);
		gVEC(0x50,wwd(0x0000000,0x13000000+addr/256+(width<<10)));
		gVEC(0x51,wwd(0,hhw(0,0)));
		gVEC(0x52,wwd(width,height));
		gVEC(0x53,0);
		gif_endfinal();

		FlushCache(0);
		dma02_wait();

		dma02_send(list,gif_length,0x101);

		dma02_wait();

		send((int128*)(tex->image),(height*width)/4);

		//Swap the colors in the clut to CSM1 format
		for(t=0;t<256;t++)
		{		
			if((t&0x18)==8)
			{
				int temp;

				temp=tex->clut[t];
				tex->clut[t]=tex->clut[t+8];
				tex->clut[t+8]=temp;
			}
		}
			gif_begin(list);
			gif_tag(0xe,1,0,0,0);
			gVEC(0x50,wwd(0x0000000,0x00000000+tex->clutaddr/256+(16<<10)));
			gVEC(0x51,wwd(0,hhw(0,0)));
			gVEC(0x52,wwd(16,16));
			gVEC(0x53,0);
			gif_endfinal();

			FlushCache(0);
			dma02_wait();
	
			dma02_send(list,gif_length,0x101);

			dma02_wait();

			send((int128*)(tex->clut),(16*16)/4);

		//Swap the colors back to normal format
		for(t=0;t<256;t++)
		{		
			if((t&0x18)==8)
			{
				int temp;

				temp=tex->clut[t];
				tex->clut[t]=tex->clut[t+8];
				tex->clut[t+8]=temp;
			}
		}
	}

	tex->addr=addr;
}

void texture_cleartexturemem(int color)
{
	int t;
	static int bitmap[32*32];
	texture tex;

	for(t=0;t<32*32;t++)bitmap[t]=color;
	texture_init(&tex);

	tex.width=32;
	tex.height=32;
	tex.image=(void*)bitmap;

	for(t=0;t<1024;t++)texture_upload(&tex,t*32*4*32);
}

static int nextfree=0;
#define BLOCKSIZE 8192
#define BLOCKSIZEW 64
#define BLOCKSIZEH 32

int texture_allocinit(int start)
{
	start=(-BLOCKSIZE)&(start+BLOCKSIZE-1);
	
	nextfree=start;
}
int texture_allocvideomem(int size)
{
	size=(-BLOCKSIZE)&(size+BLOCKSIZE-1);

	nextfree+=size;
	return nextfree-size;
}

void texture_allocupload(texture *tex)
{
	tex->clutaddr=texture_allocvideomem(16*16*4);
	texture_upload(tex,texture_allocvideomem(tex->width*(((-BLOCKSIZEH)&(tex->height-1))+BLOCKSIZEH)*(tex->bitsperpixel/8)));
}