#include "main.h"
#include "3d.h"
#include "vectors.h"
#include <math.h>
#include "textures.h"


/*
  fog_color[4]={....};

  glEnable(GL_FOG);
  glFogf(GL_FOG_MODE, GL_LINEAR);
  glFogfv(GL_FOG_COLOR, fog_color);
  glFogf(GL_FOG_START, 10.0);
  glFogf(GL_FOG_END, 20.0);

  */


Matrix mproj={1.8, 0.0, 0.0, 0.0, 0.0, 2.41, 0.0, 0.0, 0.0, 0.0, -1.0, -1.0, 0.0, 0.0, -0.2, 0.0};

#define STEPMULBY	20000.0					//quand step=1.0 ---> le temp ACCURATE_TIMER=20000.0
#define STEPMULBY1	20000.0



Vect3D MEDUSE_Camera(float step, unsigned char part, Matrix m);
void MEDUSE_put(float step);
void SUBMARINE1_put(float step, float blobbing);
void MEDUSE_put_bulles(float scalefactor, float t1, Matrix mfinal, Vect3D translate);
void SUBLAND_draw();
void SUBLAND_spiral(Vect3D position, Vect3D angle_dir, float param[5], float alphafactor);
void SUBMARINE_volumetric(float step);


Matrix mcamera;
Vect3D nullvect={0.0, 0.0, 0.0};

float medusebullefactor;


/*****************************/


void METEORE_deluge(float step)
{

		GLfloat LightAmbient[]=         { 1.0f, 1.0f, 1.0f, 5.0f };
	GLfloat LightDiffuse[]=         { 0.5f, 0.5f, 0.5f, 5.0f };
	GLfloat LightPosition[]=        { 0.0f, 800.0f, 2.0f, 1.0f };



	LightPosition[0]=400.0*sin(ACCURATE_TIMER*0.005);
	LightPosition[1]=900+400.0*cos(ACCURATE_TIMER*0.001);
	LightPosition[2]=400.0*cos(ACCURATE_TIMER*0.005);

        glLightfv(GL_LIGHT1, GL_AMBIENT, LightAmbient);
        glLightfv(GL_LIGHT1, GL_DIFFUSE, LightDiffuse);
        glLightfv(GL_LIGHT1, GL_POSITION,LightPosition);
        glEnable(GL_LIGHT1);
		glEnable(GL_FOG);
		glEnable(GL_LIGHTING);


		float alphastep=step;



	step*=0.5;
	while(step>=2.0) {step-=2.0;}

	Vect3D pos, angle;

	pos.x=0.0;
	pos.y=290.0;
	pos.z=0.0;
	angle.x=0.0;
	angle.y=0.0;
	angle.z=0.0;

	float spirparam[5];

	spirparam[0]=0.5;
	spirparam[1]=24.0;								//enroulement
	spirparam[2]=23.0;								//diametre
	spirparam[3]=ACCURATE_TIMER*0.001;								//allongement
	spirparam[4]=-400.0+step*500.0;	//distance

	glDisable(GL_LIGHTING);

	SUBLAND_spiral(pos, angle, spirparam, (alphastep-4.0)*0.33);

		
	glDisable(GL_FOG);

}

/*****************************/



void MEDUSE_manage_everything(float step)
{

	Vect3D msrc;



	if (step>=3.0)
	{
	float fog_color[4]={28*0.5*INV256, 27*0.5*INV256, 87*0.5*INV256, 1.0f};
	glEnable(GL_FOG);
	glFogf(GL_FOG_MODE, GL_LINEAR);
	glFogfv(GL_FOG_COLOR, fog_color);
	glFogf(GL_FOG_START, 300.0);
	glFogf(GL_FOG_END, 400.0);
	}



	if (step>=0.0 && step<1.0) { medusebullefactor=1.0+step*6.0; msrc=MEDUSE_Camera(step, 0, mcamera); }	
	if (step>=1.0 && step<2.0) { medusebullefactor=6.0+step*30.0; msrc=MEDUSE_Camera(step-1.0, 1, mcamera); }
	if (step>=2.0 && step<3.0) { medusebullefactor=36.0+step*100.0; msrc=MEDUSE_Camera(step-2.0, 2, mcamera); }
	if (step>=3.0 && step<4.0) { msrc=MEDUSE_Camera(step-3.0, 3, mcamera); }
	if (step>=4.0 && step<5.0) { msrc=MEDUSE_Camera(step-4.0, 4, mcamera); }
	if (step>=5.0 && step<6.0) { msrc=MEDUSE_Camera(step-5.0, 5, mcamera); }
	if (step>=6.0 && step<=7.0) { msrc=MEDUSE_Camera(step-5.0, 5, mcamera); }


	if (step>=4.0 && step<=7.0) { SUBLAND_draw();}
	if (step>=3.0 && step<4.0) { SUBLAND_draw(); SUBMARINE1_put(1.0, 1.0); }
	if (step>=2.0 && step<3.0) { SUBMARINE1_put(1.0, 1.0-(step-2.0)); }
	if (step>=1.0 && step<2.0) { SUBMARINE1_put(step-1.0, step-1.0);}
	if (step>=1.0 && step<2.0) { MEDUSE_put(step-1.0); }
	if (step<1.0) { MEDUSE_put(step); }






	if (step<2.0)
	{
	MEDUSE_put_bulles(medusebullefactor, ACCURATE_TIMER*0.001, mcamera, msrc);
	}
	else
	{

	MEDUSE_put_bulles(medusebullefactor, ACCURATE_TIMER*0.001, mcamera, msrc);
	}



	if (step>=4.0 && step <= 7.0)
	{
	METEORE_deluge(step);
	SUBMARINE_volumetric((step-4.0)*0.3333333);
	}



	if(step>=3.0)
	{
	glDisable(GL_FOG);
	}


}


unsigned char SUBMARINE_volumetric_state=0;
Object_Data SUBvol;

Vect3D position_cailloux[16*18];

/* tjrs appliquer APRES APRES APRES avoir affich les cailloux, sinon ca merdasse sec */

void SUBMARINE_volumetric(float step)
{

	if (SUBMARINE_volumetric_state==0)
	{
		H3D_allocate_obj(&SUBvol, 4, 5);

		/*
			.0--------1
		   /         / 
		  /         /
		 .2-------/3
          \      /
		   \   /
		    \/4


         */

		Vect3D p0={-1.0,1.0,1.0};
		Vect3D p1={1.0,1.0,1.0};
		Vect3D p2={-1.0,1.0,-1.0};
		Vect3D p3={1.0,1.0,-1.0};
		Vect3D p4={0.0,-1.0,0.0};

		SUBvol.v_original[0]=p0;
		SUBvol.v_original[1]=p1;
		SUBvol.v_original[2]=p2;
		SUBvol.v_original[3]=p3;
		SUBvol.v_original[4]=p4;

		SUBvol.f[0].idx[0]=1;
		SUBvol.f[0].idx[1]=3;
		SUBvol.f[0].idx[2]=4;

		SUBvol.f[1].idx[0]=3;
		SUBvol.f[1].idx[1]=2;
		SUBvol.f[1].idx[2]=4;

		SUBvol.f[2].idx[0]=2;
		SUBvol.f[2].idx[1]=0;
		SUBvol.f[2].idx[2]=4;

		SUBvol.f[3].idx[0]=0;
		SUBvol.f[3].idx[1]=1;
		SUBvol.f[3].idx[2]=4;


		SUBMARINE_volumetric_state=1;
	}

	Matrix m[5];

  for (int i=0;i<16*18;i+=2)
  {
	 Vect3D posi;
	 
	 posi=position_cailloux[i];



	MAT_ident_scale(1.0, 400.0, 1.0, m[0]);

		 posi.y=0.0;

	MAT_obj_mat(0.0, 0.0, 0.0, posi, m[1]);
	MAT_mul(m[0], m[1], m[2]);
	MAT_mul(m[2], mcamera, m[3]);
	

		H3D_transform_obj_matrix(&SUBvol, m[3]);
		H3D_transform_normal(&SUBvol, m[3], 0);
	

		SUBvol.uvw[4].x=0.7*step;
		SUBvol.uvw[0].x=0.0;
		SUBvol.uvw[1].x=0.0;
		SUBvol.uvw[2].x=0.0;
		SUBvol.uvw[3].x=0.0;

		Vect3D color={1.0, 1.0, 1.0};
		H3D_render_volumetric(&SUBvol, color);
  }

}




Vect3D MEDUSE_Camera(float step, unsigned char part, Matrix m)
{

	Vect3D src, trg;
	Vect3D src_part1;
	float param1;

   // step=1.0;



	if (part==0)
	{
		param1=step*STEPMULBY;
		src.x=sin(param1*0.00025)*50.0;
		src.y=cos(param1*0.00015)*50.0;
		src.z=sin(param1*0.00012)*30.0;
		trg=nullvect;
	}

	if (part==1)
	{

		Vect3D posobj;

		param1=STEPMULBY+step*STEPMULBY1;
		src.x=sin(1.0+param1*0.00025)*50.0;;
		src.y=cos(2.0+param1*0.00015)*50.0;;
		src.z=sin(3.0+param1*0.00012)*30.0;


		posobj.x=-200.0*step;
		posobj.y=-200.0*step;
		posobj.z=-200.0*step;



		trg=Vect3D_Sub(posobj, src);
		trg=Vect3D_Normalize(trg);
		trg=Vect3D_MulScalar(trg, 44.1);
		trg=Vect3D_Invert(trg);

		src=Vect3D_Add(posobj, trg);


		trg=posobj;

		float step1=step;
		if(step1>1.0) step1=1.0;

		trg.x*=step1;
		trg.y*=step1;
		trg.z*=step1;


	}

	if (part==2)
	{

		Vect3D poscam={-180.279831, -174.662949, -169.768250 };
		Vect3D posanimal={-200.0, -200.0, -200.0};

		Vect3D t=Vect3D_Sub(posanimal, poscam);
		t=Vect3D_MulScalar(t,step);
		src=Vect3D_Add(poscam,t);
		src.x+=sin(step)*20.0;
		src.y+=sin(step*1.6)*20.0;
		src.z+=sin(step*0.3)*20.0;

		trg=posanimal;
		trg.x+=sin(step*10.0);

	//	fprintf(debugfile, "step %f source : %f %f %f  target : %f %f %f ", step, src.x, src.y, src.z, trg.x, trg.y, trg.z);
	}

	if (part==3)
	{

			Vect3D poscam={-183.170578, -180.008530, -194.089600};  
			Vect3D trgcam={-200.544022, -200.000000, -200.000000}; 

			Vect3D dposcam={0.0, -400.0, 110.0};
			Vect3D dtrgcam={0.0, -250.0, 0.0};

			Vect3D dpos=Vect3D_Sub(dposcam, poscam);
			dpos=Vect3D_MulScalar(dpos,step);
			src=Vect3D_Add(poscam,dpos);

			Vect3D dtrg=Vect3D_Sub(dtrgcam, trgcam);
			dtrg=Vect3D_MulScalar(dtrg,step);
			trg=Vect3D_Add(trgcam,dtrg);

	}

	if (part==4)
	{

		src.x=sin(step*3.0*3.14*sin(step*1.0))*110.0;
		src.y=-400.0+40.0*sin(step*2.0);
		src.z=cos(step*3.0*5.14*sin(step*2.0))*110.0;

		trg.x=0.0;
		trg.y=-250.0;
		trg.z=0.0;
	}

	if (part==5)
	{

		src.x=sin(3.0*3.14*sin(1.0)+step*2)*110.0;
		src.y=-400.0+40.0*sin(2.0+step);
		src.z=cos(step*3+3.0*5.14*sin(2.0))*110.0;

		trg.x=0.0+step*40.0;
		trg.y=-250.0-step*50.0;
		trg.z=0.0;
	}

	
	if (part==6)
	{

		src.x=sin(3.0*3.14*sin(1.0)+2.0)*110.0;
		src.y=-400.0+40.0*sin(2.0+1.0);
		src.z=cos(3+3.0*5.14*sin(2.0))*110.0;

		trg.x=0.0;
		trg.y=-300.0-400*step;
		trg.z=0.0;
	}



	MAT_cam_matrix(m, src, trg, 0);

	return trg;

}



#define SPIRAL_sphere	SCN_SphereLow

/*
void SUBLAND_spiral(Vect3D position, Vect3D angle_dir, float param[5])
{
	Matrix m[4];

	MAT_ident_scale(1.0*param[0], 1.0*param[0], 1.0*param[0], m[0]);
	MAT_obj_mat(angle_dir.x, angle_dir.y, angle_dir.z, position, m[1]);
	MAT_mul(m[0], m[1], m[2]);
	MAT_mul(m[2], mcamera, m[3]);
	
	for (int i=0;i<18;i++)	//30 objets
	{
		Vect3D addingvtx;

		addingvtx.x=param[2]*sin(i*param[1]*3.14/128.0);
		addingvtx.y=i*param[3] + param[4];
		addingvtx.z=param[2]*cos(i*param[1]*3.14/128.0);;

		for (int v=0;v<SPIRAL_sphere.nbvtx;v++)
		{
			SPIRAL_sphere.v_intermed[v]=Vect3D_MulScalar(SPIRAL_sphere.v_original[v], 0.1+i*0.1);
			SPIRAL_sphere.v_intermed[v]=Vect3D_Add(SPIRAL_sphere.v_intermed[v], addingvtx);
			SPIRAL_sphere.uvw[v]=Vect3D_Normalize(SPIRAL_sphere.v_original[v]);
		}

	H3D_transform_intermed_obj_matrix(&SPIRAL_sphere, m[3]);
	H3D_transform_normal(&SPIRAL_sphere, m[3], 0);
	H3D_render_object(&SPIRAL_sphere, 2, textures[3], i/24.0);
	}
}
*/

void SUBLAND_spiral(Vect3D position, Vect3D angle_dir, float param[5], float alphafactor)
{
	Matrix m[4];

	MAT_ident_scale(1.0*param[0], 1.0*param[0], 1.0*param[0], m[0]);
	MAT_obj_mat(angle_dir.x, angle_dir.y, angle_dir.z, position, m[1]);
	MAT_mul(m[0], m[1], m[2]);
	MAT_mul(m[2], mcamera, m[3]);
	
	for (int j=0;j<16;j++)
	{
		for (int i=0;i<18;i++)	//30 objets
		{
			Vect3D addingvtx;

			addingvtx.x=(j*param[2])*sin(j+i*param[1]*3.14/128.0);
			addingvtx.y=param[4]+sin(j+i+param[3])*50.0;
			addingvtx.z=(j*param[2])*cos(j+i*param[1]*3.14/128.0);

			position_cailloux[j*18 + i]=Vect3D_Add(addingvtx, position);

			for (int v=0;v<SPIRAL_sphere.nbvtx;v++)
			{
				SPIRAL_sphere.v_intermed[v]=Vect3D_MulScalar(SPIRAL_sphere.v_original[v], 0.1+i*0.1);
				SPIRAL_sphere.v_intermed[v]=Vect3D_Add(SPIRAL_sphere.v_intermed[v], addingvtx);
			}

		H3D_transform_intermed_obj_matrix(&SPIRAL_sphere, m[3]);
		H3D_transform_normal(&SPIRAL_sphere, m[3], 0);

			for ( v=0;v<SPIRAL_sphere.nbvtx;v++)
			{
			//	SPIRAL_sphere.uvw[v]=Vect3D_Add(SPIRAL_sphere.v_rotated[v],addingvtx);
			//	SPIRAL_sphere.uvw[v]=Vect3D_Normalize(SPIRAL_sphere.uvw[v]);
			//	SPIRAL_sphere.uvw[v]=Vect3D_MulScalar(SPIRAL_sphere.uvw[v], 17.0);

				//SPIRAL_sphere.uvw[v]=Vect3D_Add(SPIRAL_sphere.v_original[v], SPIRAL_sphere.v_rotated[v]);
				SPIRAL_sphere.uvw[v]=SPIRAL_sphere.v_original[v];

			//	SPIRAL_sphere.uvw[v]=Vect3D_Add(SPIRAL_sphere.uvw[v], addingvtx);
				SPIRAL_sphere.uvw[v]=Vect3D_Normalize(SPIRAL_sphere.uvw[v]);
				SPIRAL_sphere.uvw[v]=Vect3D_MulScalar(SPIRAL_sphere.uvw[v], 0.3);
			
				SPIRAL_sphere.uvw[v].x+=j*0.1;
				SPIRAL_sphere.uvw[v].y+=i*0.1;
				
			}

		H3D_render_object(&SPIRAL_sphere, 0, textures[5], alphafactor*(i+1)/24.0);
		}
	}
}













/**********************************************************************************************************/
/**********************************************************************************************************/
/**********************************************************************************************************/
/**********************************************************************************************************/



#define SUBLAND_erosion	255
#define SUBLAND_blur_pass	2
unsigned char SUBLAND_plasma[256*256];

//prendre des multiples de 2 pour xtrig et ytrig (mieux, power of 2)

void SUBLAND_create(Object_Data *o, int xtrig, int ytrig, float scale_height)
{

	for (int i=0;i<256*256;i++)
	{
		SUBLAND_plasma[i]=random(SUBLAND_erosion);
	}

	for (i=0;i<SUBLAND_blur_pass;i++)
	{
		TEXTURE_blur_greyscale_256x256((unsigned char*) &SUBLAND_plasma);
	}

    H3D_allocate_obj(o, xtrig*ytrig*2, xtrig*ytrig*4);


	float fmulx=1.0/xtrig;
	float fmuly=1.0/ytrig;

	int idx_faces=0, idx_pts=0;

	for (int y=1;y<ytrig-1;y++)
	{
		for (int x=1;x<xtrig-1;x++)
		{
			int plasmax, plasmay;
			float xcoord, ycoord;

			plasmax=x;
			plasmay=y;

			float height[4];
			
			height[0]=(float)SUBLAND_plasma[plasmax+(plasmay<<8)];
			height[1]=(float)SUBLAND_plasma[1+plasmax+(plasmay<<8)];
			height[2]=(float)SUBLAND_plasma[256+plasmax+(plasmay<<8)];
			height[3]=(float)SUBLAND_plasma[257+plasmax+(plasmay<<8)];

			xcoord=x*fmulx - 0.5;
			ycoord=y*fmuly - 0.5;	
			
			
			for (int j=0;j<4;j++)
				{
					height[j]/=(float) SUBLAND_erosion;
					height[j]*=scale_height;
				}


			Vect2D coord[4];

			coord[0].x=xcoord;
			coord[0].y=ycoord;

			coord[1].x=xcoord+fmulx;
			coord[1].y=ycoord;

			coord[2].x=xcoord;
			coord[2].y=ycoord+fmuly;

			coord[3].x=xcoord+fmulx;
			coord[3].y=ycoord+fmuly;


			for (j=0;j<4;j++)
			{
			float dist=sqrt(coord[j].y*coord[j].y + coord[j].x*coord[j].x);
			height[j]*=4.0*(1.0-dist);
			height[j]-=dist*4.0;
			}

			o->v_original[idx_pts].x=coord[0].x;
			o->v_original[idx_pts].z=coord[0].y;
			o->v_original[idx_pts].y=height[0];

			o->v_original[idx_pts+1].x=coord[1].x;
			o->v_original[idx_pts+1].z=coord[1].y;
			o->v_original[idx_pts+1].y=height[1];

			o->v_original[idx_pts+2].x=coord[2].x;
			o->v_original[idx_pts+2].z=coord[2].y;
			o->v_original[idx_pts+2].y=height[2];
			
			o->v_original[idx_pts+3].x=coord[3].x;
			o->v_original[idx_pts+3].z=coord[3].y;
			o->v_original[idx_pts+3].y=height[3];


			o->uvw[idx_pts].x=o->v_original[idx_pts].x+0.5;
			o->uvw[idx_pts].y=o->v_original[idx_pts].z+0.5;

			o->uvw[idx_pts+1].x=o->v_original[idx_pts+1].x+0.5;
			o->uvw[idx_pts+1].y=o->v_original[idx_pts+1].z+0.5;

			o->uvw[idx_pts+2].x=o->v_original[idx_pts+2].x+0.5;
			o->uvw[idx_pts+2].y=o->v_original[idx_pts+2].z+0.5;

			o->uvw[idx_pts+3].x=o->v_original[idx_pts+3].x+0.5;
			o->uvw[idx_pts+3].y=o->v_original[idx_pts+3].z+0.5;

		


			idx_pts+=4;

			o->f[idx_faces].idx[0]=idx_pts;
			o->f[idx_faces].idx[1]=idx_pts+1;
			o->f[idx_faces].idx[2]=idx_pts+2;

			o->f[idx_faces+1].idx[0]=idx_pts+1;
			o->f[idx_faces+1].idx[1]=idx_pts+3;
			o->f[idx_faces+1].idx[2]=idx_pts+2;

			o->f[idx_faces].nrm=o->v_original[idx_pts];
			o->f[idx_faces+1].nrm=o->v_original[idx_pts+1];


			idx_faces+=2;

		}
	}

	o->nbfaces=idx_faces;
	o->nbvtx=idx_pts;

}



Object_Data sublandscape;
unsigned char SUBLAND_state=0;

void COMPUTE_sublandscape()
{
	SUBLAND_create(&sublandscape, 32, 32, 4.0);
}

void SUBLAND_draw()
{







	Vect3D src, trg;


	Matrix mobj, mobj1,mobj2, fmat;
		
	MAT_ident_scale(471.0, 31.0, 471.0, mobj);
	MAT_obj_mat(0, 0, 0, nullvect, mobj1);
	MAT_mul(mobj, mobj1, mobj2);
	MAT_mul(mobj2, mcamera, fmat);



	H3D_transform_normal(&sublandscape, fmat, 0);
	H3D_transform_obj_matrix(&sublandscape, fmat);

		//	H3D_transform_blobby_obj(&sublandscape, 0, 1.0, ACCURATE_TIMER*0.00025);
	//	H3D_transform_intermed_obj_matrix(&sublandscape, fmat);

	H3D_render_object(&sublandscape, 0, textures[4], 1.0);



}


	

/* ne pas aller au dessus de 100 steps pour la queue de la meduse = 100 faces */

#define MAX_STEPS_QMEDUSE	200

void MEDUSE_create_queue(Object_Data *o, Vect3D p1, Vect3D p2, Vect3D p3, Vect3D p4, int nbsteps)
{

	Vect3D sk[MAX_STEPS_QMEDUSE];

	SPLINES_generate_points(p1, p2, p3, p4, nbsteps, (Vect3D*) &sk);

	int idxpts=2;

	o->v_original[0]=p2;
	o->v_original[1]=p2;	//les 2 points au debut de la queue sont confondus

	for (int j=1;j<nbsteps-1;j++)
	{
	  Vect3D axisY={1.0, 0.0, 0.0};
	  Vect3D tang, ortho, invortho,  h1, h2;

	  tang=Vect3D_Sub(sk[j], sk[j-1]);			//vecteur tangent a la trajectoire
	  ortho=Vect3D_CrossProduct(tang, axisY);	//un vecteur normal

	  ortho=Vect3D_Normalize(ortho);		//normalise ce vecteur orthogonal a la trajectoire

	  float aw=float(j)/float(nbsteps);
	  float w=fabs(sin(aw*3.14));
	  ortho=Vect3D_MulScalar(ortho, w*0.5);

	  invortho=Vect3D_Invert(ortho);

	  h1=Vect3D_Add(sk[j], ortho);
	  h2=Vect3D_Add(sk[j], invortho); 

	  o->v_original[idxpts]=h1;
	  o->v_original[idxpts+1]=h2;

	  idxpts+=2;
	}

	idxpts=0;
	int idxfaces=0;

	for (int k=0;k<nbsteps-2;k++)
	{
		o->f[idxfaces].idx[0]=idxpts;
		o->f[idxfaces].idx[1]=idxpts+1;
		o->f[idxfaces].idx[2]=idxpts+2;

		o->f[idxfaces+1].idx[0]=idxpts+1;
		o->f[idxfaces+1].idx[1]=idxpts+2;
		o->f[idxfaces+1].idx[2]=idxpts+3;


		idxfaces+=2;
		idxpts+=2;

	}

	o->nbfaces=idxfaces-2;
	o->nbvtx=idxpts;

}







Object_Data queue_meduse; 

unsigned char STATE_MEDUSE=0;

void MEDUSE_put(float step)
{


	float AT=step*STEPMULBY;

	float t1=AT*0.0015;

	if (STATE_MEDUSE==0)
	{
		Vect3D t1={0.0, 0.1, 1.0};
		Vect3D t2={0.0, 0.0, 2.0};
		Vect3D t3={1.2, -20.0, 2.4};
		Vect3D t4={0.0, 0.0, 1.0};
     H3D_allocate_obj(&queue_meduse, 300, 1200);
	 MEDUSE_create_queue(&queue_meduse, t1, t2, t3, t4, 20);

	 for (int idxp=0;idxp<SCN_SphereMiddle.nbvtx;idxp++)
	 {
		SCN_SphereMiddle.uvw[idxp]=Vect3D_MulScalar(SCN_SphereMiddle.uvw[idxp],0.5);
	 }

	 for (int idxk=0;idxk<queue_meduse.nbvtx;idxk++)
	 {
		 queue_meduse.uvw[idxk]=Vect3D_MulScalar(queue_meduse.v_original[idxk], 0.5);
	 }

	 for (int idu=0;idu<queue_meduse.nbfaces;idu++)
	 {
		queue_meduse.f[idu].nrm=t1;
	 }

	 STATE_MEDUSE=1;
	}


	Matrix mobj, mobj1, mobj2,  mfinal, mmeduse;
	Vect3D source, target;


	Vect3D translate={1.0, 1.0, 1.0};


	GLfloat LightAmbient[]=         { 0.5f, 0.5f, 0.5f, 0.1f };
	GLfloat LightDiffuse[]=         { 0.5f, 0.5f, 0.5f, 1.0f };
	GLfloat LightPosition[]=        { 0.0f, 0.0f, 2.0f, 1.0f };



        glLightfv(GL_LIGHT1, GL_AMBIENT, LightAmbient);
        glLightfv(GL_LIGHT1, GL_DIFFUSE, LightDiffuse);
        glLightfv(GL_LIGHT1, GL_POSITION,LightPosition);
        glEnable(GL_LIGHT1);

	

	for (int i=0;i<8;i++)
	{


	float medusescale=0.5+fabs(sin(i*15))*0.5;
	float queuescale=0.5+fabs(cos(i*15))*1.0;
	float arg1=AT*0.0003+i*45*3.14/180.0;


	
	if (i&1)
	{
	translate.y=cos(arg1+i*15)*30.0;
	translate.x=cos(arg1)*20.0;
	translate.z=sin(arg1)*20.0;
	}
	else
	{
	translate.y=sin(arg1+i*15)*20.0;
	translate.x=sin(arg1*2)*20.0;
	translate.z=cos(arg1)*30.0;

	}


	MAT_ident_scale(0.8*medusescale, 0.8*medusescale, 0.8*medusescale, mobj);
	MAT_obj_mat(t1, t1, t1, translate, mobj1);
	MAT_mul(mobj, mobj1, mmeduse);
	MAT_mul(mmeduse, mcamera, mfinal);

	
	glEnable(GL_LIGHTING);

	H3D_transform_blobby_obj(&SCN_SphereMiddle, 1, 2.0, i*4.0+t1);
	H3D_transform_intermed_obj_matrix(&SCN_SphereMiddle, mfinal);
	H3D_transform_normal(&SCN_SphereMiddle, mfinal, 0);
	H3D_render_object(&SCN_SphereMiddle, 2, textures[3], 1.0);

	glDisable(GL_LIGHTING);

	

	 for (int iq=0;iq<20;iq++)
	 {
		MAT_ident_scale(1.0*medusescale, (0.9+fabs(sin(iq*45+AT*0.0005))*0.3)*medusescale*queuescale, 1.0*medusescale, mobj);
		MAT_obj_mat(0.0, iq*18.0+t1, 0.0, nullvect, mobj1);
		MAT_mul(mobj, mobj1, mobj2);

		MAT_mul(mobj2, mmeduse, mobj1);
		MAT_mul(mobj1, mcamera, mfinal);

	//	H3D_transform_obj_matrix(&queue_meduse, mfinal);
		H3D_transform_blobby_obj(&queue_meduse, 2, 2.0, iq*12.0+t1);
		H3D_transform_intermed_obj_matrix(&queue_meduse, mfinal);
		H3D_render_object(&queue_meduse, 2, spritebubble, 0.25);
	 }


	}



}




void MEDUSE_put_bulles(float scalefactor, float t1, Matrix mfinal, Vect3D translate)
{


		glBindTexture(GL_TEXTURE_2D, spritebubble);

	for (int bk=0;bk<10;bk++)
	{
		for (int i=0;i<100;i++)
		{
		Vect2D projbubblepos={0.0, 0.0};
		Vect3D bubblecol={1.0, 1.0, 1.0};

		Vect3D bubblepos;
		Vect3D bubblepos1;

		bubblepos.x=sin(t1*0.1+bk*25.6*3.14/128.0)*(23.0+cos(t1*0.1+bk*25.6*3.14/128.0)*43);
		bubblepos.y=(-50+(i+sin(t1*0.1+bk*25.6*3.14/128.0)*5.0))*2.0;
		bubblepos.z=cos(t1*0.1+bk*25.6*3.14/128.0)*(12.0+sin(t1*0.1+bk*25.6*3.14/128.0)*43);

		bubblepos.x+=sin(t1*0.1+i)*22.0;
		bubblepos.y+=sin(t1*0.1+i)*22.0;

		bubblepos=Vect3D_MulScalar(bubblepos, scalefactor);

		MAT_rotate_pt(bubblepos, &bubblepos1, mfinal);

		bubblepos1=Vect3D_Add(bubblepos1, translate);


		projbubblepos.x=bubblepos1.x*12.0f/bubblepos1.z;
		projbubblepos.y=bubblepos1.y*12.0f/bubblepos1.z;

		float sizefact=0.03+sin(t1+i+bk)*0.03;

		BRUSH_draw(sizefact, projbubblepos, 0.0, sizefact*5.0, bubblecol);
		}
	}
}





void SUBMARINE1_put(float step, float blobbing)
{

	
	float AT=STEPMULBY+step*STEPMULBY1;
	float AT1=STEPMULBY+blobbing*STEPMULBY1;
	
	
	Matrix mfinal;
	Vect3D source, target, newsource, newtarget, posobj;

	float t2=AT1*0.0025;


	
		posobj.x=200.0-400.0*step;
		posobj.y=200.0-400.0*step;
		posobj.z=200.0-400.0*step;



	Vect3D translate={1.0, 1.0, 1.0};	
	
	GLfloat LightAmbient[]=         { 0.5f, 0.5f, 0.5f, 0.1f };
	GLfloat LightDiffuse[]=         { 0.5f, 0.5f, 0.5f, 1.0f };
	GLfloat LightPosition[]=        { 0.0f, 0.0f, 2.0f, 1.0f };


    glLightfv(GL_LIGHT1, GL_AMBIENT, LightAmbient);
    glLightfv(GL_LIGHT1, GL_DIFFUSE, LightDiffuse);
    glLightfv(GL_LIGHT1, GL_POSITION,LightPosition);
    glEnable(GL_LIGHT1);		//a jarter peut-etre pour eviter des merdes d'openGL, deja init dans meduse

  

	Matrix m1,m2,m3;
	float t1=AT*0.025;

	//MAT_ident_scale(1.0, 4.0, 1.0, m1);
	MAT_obj_mat(0, 0,0, Vect3D_Invert(posobj), m2);
//	MAT_mul(m1, m2,m3);

	MAT_mul(m2,mcamera, mfinal);

	
glEnable(GL_LIGHTING);

	H3D_transform_blobby_obj(&SCN_SphereMiddle, 3, 2.0+fabs(sin(t2)), t2*0.2);
	H3D_transform_intermed_obj_matrix(&SCN_SphereMiddle, mfinal);
	H3D_transform_normal(&SCN_SphereMiddle, mfinal, 0);
	H3D_render_object(&SCN_SphereMiddle, 2, textures[3], 0.3);

	glDisable(GL_LIGHTING);



}







