
/* mekka intro               */
/* c a l o d o x   2 0 0 1   */

#include "main.h"
#include <math.h>
#include "writer.h"

void RECTANGLE_fill_around(GLfloat zoom, Vect3D color);


void BRUSH_draw(GLfloat zoom, Vect2D displace, GLfloat rotat, GLfloat alpha, Vect3D color)
	{

		
		glLoadIdentity();  
        glRotatef(rotat,0.0f,0.0f,1.0f);                         // Rotate On The Z Axis
		glTranslatef(displace.x,displace.y,-5.0);
		glRotatef(270,0.0f,0.0f,1.0f);  

		

		glBlendFunc(GL_SRC_ALPHA,GL_ONE);	// Blending Function For Translucency Based On Source Alpha Value

		glEnable(GL_BLEND);	
		glDisable(GL_DEPTH_TEST);

		glBegin(GL_QUADS);

		glColor4f(color.x, color.y, color.z,alpha);		// Full Brightness, 50% Alpha ( NEW )

		glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f*zoom, -1.0f*zoom,  0.0f);	// Bottom Left Of The Texture and Quad
		glTexCoord2f(1.0f, 0.0f); glVertex3f( 1.0f*zoom, -1.0f*zoom,  0.0f);	// Bottom Right Of The Texture and Quad
		glTexCoord2f(1.0f, 1.0f); glVertex3f( 1.0f*zoom,  1.0f*zoom,  0.0f);	// Top Right Of The Texture and Quad
		glTexCoord2f(0.0f, 1.0f); glVertex3f(-1.0f*zoom,  1.0f*zoom,  0.0f);	// Top Left Of The Texture and Quad
 
        glEnd();

		glEnable(GL_DEPTH_TEST);
		glDisable(GL_BLEND);
}




void HAND_draw(GLfloat zoom, Vect2D displace, GLfloat rotat, GLfloat alpha)
	{

		
		glLoadIdentity();  
        glRotatef(rotat,0.0f,0.0f,1.0f);                         // Rotate On The Z Axis
		glTranslatef(displace.x,displace.y,zoom);
		glRotatef(rotat,0.0f,0.0f,1.0f);  


		glEnable(GL_BLEND);	
		glDisable(GL_DEPTH_TEST);

		//glBlendFunc(GL_SRC_ALPHA,GL_ONE);	// Blending Function For Translucency Based On Source Alpha Value
		glBlendFunc(GL_SRC_ALPHA,GL_ONE);	// Blending Function For Translucency Based On Source Alpha Value

		glColor4f(1.0f,1.0f,1.0f,alpha);		// Full Brightness, 50% Alpha ( NEW )
		glBegin(GL_QUADS);

		glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f, 1.0f,  0.0f);	// Bottom Left Of The Texture and Quad
		glTexCoord2f(1.0f, 0.0f); glVertex3f( 1.0f, 1.0f,  0.0f);	// Bottom Right Of The Texture and Quad
		glTexCoord2f(1.0f, 1.0f); glVertex3f( 1.0f, -1.0f,  0.0f);	// Top Right Of The Texture and Quad
		glTexCoord2f(0.0f, 1.0f); glVertex3f(-1.0f, -1.0f,  0.0f);	// Top Left Of The Texture and Quad
 
        glEnd();

		glEnable(GL_DEPTH_TEST);
		glDisable(GL_BLEND);
}


void MASK_draw(GLfloat zoomx, GLfloat zoomy, GLfloat dispx, GLfloat dispy, GLfloat rotat)
	{

		
	
		glLoadIdentity();  
        glRotatef(rotat,0.0f,0.0f,1.0f);                         // Rotate On The Z Axis
		glTranslatef(dispx,dispy,-4.98f);
		glRotatef(rotat,0.0f,0.0f,1.0f);  

		glEnable(GL_BLEND);
		glBlendFunc(GL_ZERO,GL_SRC_ALPHA);

		glDisable(GL_DEPTH_TEST);

	

		glBegin(GL_QUADS);

			glColor4f(1.0, 1.0, 1.0,1.0);		// Full Brightness, 50% Alpha ( NEW )

		glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f*zoomx, 1.0f*zoomy,  0.0f);	// Bottom Left Of The Texture and Quad
		glTexCoord2f(0.99f, 0.0f); glVertex3f( 1.0f*zoomx, 1.0f*zoomy,  0.0f);	// Bottom Right Of The Texture and Quad
		glTexCoord2f(0.99f, 0.95f); glVertex3f( 1.0f*zoomx, -1.0f*zoomy,  0.0f);	// Top Right Of The Texture and Quad
		glTexCoord2f(0.0f, 0.95f); glVertex3f(-1.0f*zoomx, -1.0f*zoomy,  0.0f);	// Top Left Of The Texture and Quad
 
        glEnd();

		glEnable(GL_DEPTH_TEST);
		glDisable(GL_BLEND);


}

float FONT_draw(KTEXT kchar, GLfloat zoom, GLfloat posx, GLfloat posy, GLfloat rotat, GLfloat alpha)
	{

		glLoadIdentity();  
        glRotatef(rotat,0.0f,0.0f,1.0f);                         // Rotate On The Z Axis
		glTranslatef(0.0f,0.0f,-5.0);
	
		glBlendFunc(GL_SRC_ALPHA,GL_ONE);	// Blending Function For Translucency Based On Source Alpha Value
		glDisable(GL_DEPTH_TEST);
			
		glColor4f(1.0f,1.0f,1.0f,alpha);

		float sx=kchar.width/64.0;//kchar.wfix;	//hfix
		float sy=kchar.height/64.0;	//wfix
			
		sy*=zoom;
		sx*=zoom;

		glBegin(GL_QUADS);

		  glTexCoord2f(0.0, 0.0f);  glVertex3f(posx, posy+sy,  0.0f);	// Bottom Left Of The Texture and Quad
		  glTexCoord2f(1.0, 0.0f);  glVertex3f(posx+sx, posy+sy,  0.0f);	// Bottom Right Of The Texture and Quad
		  glTexCoord2f(1.0f, 1.0);  glVertex3f(posx+sx, posy,  0.0f);	// Top Right Of The Texture and Quad
		  glTexCoord2f(0.0f, 1.0f); glVertex3f(posx, posy,  0.0f);	// Top Left Of The Texture and Quad
	
        glEnd();
		glEnable(GL_DEPTH_TEST);
		return(sx*kchar.wfix);
} 

/*
float FONT_draw_black(KTEXT kchar, GLfloat zoom, GLfloat posx, GLfloat posy, GLfloat rotat, GLfloat alpha)
	{

		glLoadIdentity();  
        glRotatef(rotat,0.0f,0.0f,1.0f);                         // Rotate On The Z Axis
		glTranslatef(0.0f,0.0f,-5.0);
	
		glBlendFunc(GL_ZERO, GL_ONE_MINUS_SRC_COLOR);	// Blending Function For Translucency Based On Source Alpha Value
		glDisable(GL_DEPTH_TEST);
			
		glColor3f(alpha, alpha, alpha);

		float sx=kchar.width/64.0;//kchar.wfix;	//hfix
		float sy=kchar.height/64.0;	//wfix
			
		sy*=zoom;
		sx*=zoom;

		glBegin(GL_QUADS);

		  glTexCoord2f(0.0, 0.0f);  glVertex3f(posx, posy+sy,  0.0f);	// Bottom Left Of The Texture and Quad
		  glTexCoord2f(1.0, 0.0f);  glVertex3f(posx+sx, posy+sy,  0.0f);	// Bottom Right Of The Texture and Quad
		  glTexCoord2f(1.0f, 1.0);  glVertex3f(posx+sx, posy,  0.0f);	// Top Right Of The Texture and Quad
		  glTexCoord2f(0.0f, 1.0f); glVertex3f(posx, posy,  0.0f);	// Top Left Of The Texture and Quad
	
        glEnd();
		glEnable(GL_DEPTH_TEST);
		return(sx*kchar.wfix);
} 
*/


void FONT_print_poem(unsigned char *s, KTEXT *font, GLfloat zoom, Vect2D pos, float alpha, float ecart)
{

	// calculer l'espace totale occupe par ce texte a l'ecran
	int i=0;
	float sizex=0.0;

	while (s[i]!=0)
	{
		sizex+=ecart*(zoom*font[s[i]-32].width*font[s[i]-32].wfix)/64.0;
		i++;
	}
	pos.x-=sizex*0.5;
	pos.y-=0.5*(zoom*font[s[0]-32].height)/64.0;


	int j=0;
	float addx;

	glEnable(GL_BLEND); glBlendFunc(GL_SRC_ALPHA,GL_ONE);

		while (s[j]!=0)
		{
		glBindTexture(GL_TEXTURE_2D, font[s[j]-32].glhandle);
		addx=FONT_draw(font[s[j]-32], zoom, pos.x, pos.y, 0.0, alpha);
		pos.x+=addx*ecart;
		j++;
		}


	glDisable(GL_BLEND);

}


char *death_in_vegas_le_poeme[]={"down down down",
				  "i want to see more blue",
				  "oh yeah",
				  "i want to feel some more",
				  "where are thou ?",
				  "o land of forever blue",
				  "world i can't understand",
				  "world i don't want to see",
				  "how can i thank thee",
				  "showing me the way",
				  "flying away",
				  "o land of forever blue",
				  "let us fulfill my hedonism",
				  "let them fall with their pessimism",
				  "i thank thee",
				  "oh yeah",
				  "i thank thee",
				  "opening my eyes",
				  "my fate becomes real",
				  "o land of forever blue",
				  "thence come",
				  "o brave new world"
           };


typedef struct 
{
	float x,y,zoom;
	int hertz, msg_nb;
} poem_key;

poem_key le_poete[]= 
{
	{ -1.050000,-0.100000,0.240000,10200,0},
	{ 0.800000,-0.500000,0.240000,10260,1},
	{ -1.000000,0.300000,0.260000,10380,2},
	{ 1.150000,-0.450000,0.260000,10660,3},
	{ -0.000000,-0.100000,0.260000,12400,4},
	{ -1.350000,-0.600000,0.260000,12620,5},
	{ 1.200000,0.350000,0.260000,12840,6},
	{ -1.500000,-0.550000,0.240000,13200,7},
	{ -1.150000,0.500000,0.220000,13680,8},
	{ 1.250000,-0.450000,0.220000,14760,9},
	{ -1.949999,-0.450000,0.220000,15060,10},
	{ -0.000000,-0.050000,0.220000,16040,11},
	{ -1.600000,-0.300000,0.220000,16460,12},
	{ 1.100000,-0.450000,0.220000,17120,13},
	{ -1.650000,0.450000,0.280000,18380,14},
	{ 1.649999,-0.750000,0.280000,19800,15},
	{ -1.000000,-0.400000,0.280000,20040,16},
	{ 0.850000,-0.600000,0.280000,24020,17},
	{ -1.700000,-0.450000,0.220000,25220,18},
	{ 1.400000,-0.750000,0.270000,25680,19},
	{ -1.750000,-0.000000,0.240000,26560,20},
	{ -0.000000,-0.800000,0.280000,27540,21}
};

#define NB_POEM_KEYS	22


void AFFICHE_TEXTE()
{

	Vect2D pos;

	for (int i=0;i<NB_POEM_KEYS;i++)
	{
		
		int nbtxt=le_poete[i].msg_nb;

		if (current_hertz>le_poete[i].hertz && current_hertz<=le_poete[i].hertz+200)
		{
		
			
			float a=INTERPOLATE_float(le_poete[i].hertz, le_poete[i].hertz+200, 
							0.0, 1.0, current_hertz);


			pos.x=le_poete[i].x;
			pos.y=le_poete[i].y;

			FONT_print_poem((unsigned char*) death_in_vegas_le_poeme[nbtxt], arial_font_normal, 
				le_poete[i].zoom, pos, a, 1.0);
		}


		if (current_hertz>le_poete[i].hertz+200 && current_hertz<le_poete[i].hertz+1300)
		{
		
			int nbtxt=le_poete[i].msg_nb;
			float z=INTERPOLATE_float(le_poete[i].hertz+200, le_poete[i].hertz+1300, 
							le_poete[i].zoom, 1.3, current_hertz);
			float a=INTERPOLATE_float(le_poete[i].hertz+200, le_poete[i].hertz+1300, 
							1.0, 0.0, current_hertz);
			float e=INTERPOLATE_float(le_poete[i].hertz+200, le_poete[i].hertz+1300, 
							1.0, 1.3, current_hertz);

			pos.x=le_poete[i].x;
			pos.y=le_poete[i].y;

			if (i==21) z=le_poete[i].zoom;
			FONT_print_poem((unsigned char*) death_in_vegas_le_poeme[nbtxt], arial_font_normal, 
				z, pos, a, e);
		}
	}


}

/*
void TEST_TEST(float x, float y, float zoom, char *msg, float ecart)
{

		Vect2D mypos;
		mypos.x=x;
		mypos.y=y;
		FONT_print_poem((unsigned char*) msg, arial_font_normal, zoom, mypos, 1.0, ecart);
}
*/


void FONT_print_string(unsigned char *s, KTEXT *font, GLfloat zoom, GLfloat posx, GLfloat posy, GLfloat rotat, 
						float alpha, int style)
{

	int i=0;
	float sx=posx, addx;

	//glEnable(GL_TEXTURE_2D);
	glEnable(GL_BLEND);
	
	glBlendFunc(GL_SRC_ALPHA,GL_ONE);

	if (style==0)
	{

		while (s[i]!=0)
		{
		glBindTexture(GL_TEXTURE_2D, font[s[i]-32].glhandle);
		addx=FONT_draw(font[s[i]-32], zoom, sx, posy, rotat, alpha);
		sx+=addx;
		i++;
		}
	}
	

	glDisable(GL_BLEND);
//	glDisable(GL_TEXTURE_2D);
}




void LAYER_buffer(float alpha, float zooma)	//zoom = 1 pour un rendu 1:1
{


	zooma*=2.0799999999;		

	glLoadIdentity();  
	glTranslatef(0.0f,0.0f,-5.0);
//	glEnable(GL_TEXTURE_2D);
	glDisable(GL_DEPTH_TEST);
	glEnable(GL_BLEND);

	glColor4f(1.0f,1.0f,1.0f,alpha);		// Full Brightness, 50% Alpha ( NEW )
	glBlendFunc(GL_SRC_ALPHA,GL_ONE);


	float tx=640.0/1024.0;
	float ty=480.0/1024.0;

		glBegin(GL_QUADS);

		  glTexCoord2f(0.0, ty);  glVertex3f(OGL_MINX*zooma, OGL_MAXY*zooma,  -0.0f);	// Bottom Left Of The Texture and Quad
		  glTexCoord2f(tx, ty);  glVertex3f(OGL_MAXX*zooma,  OGL_MAXY*zooma,  -0.0f);	// Bottom Right Of The Texture and Quad
		  glTexCoord2f(tx, 0.0f);  glVertex3f(OGL_MAXX*zooma, OGL_MINY*zooma,  -0.0f);	// Top Right Of The Texture and Quad
		  glTexCoord2f(0.0f, 0.0f); glVertex3f(OGL_MINX*zooma, OGL_MINY*zooma,  -0.0f);	// Top Left Of The Texture and Quad
	
        glEnd();


	glDisable(GL_BLEND);
	glEnable(GL_DEPTH_TEST);
//	glDisable(GL_TEXTURE_2D);
}

void LAYER2_buffer(float alpha, float zooma, int style)	//zoom = 1 pour un rendu 1:1
{


	zooma*=2.0799999999;		

	glLoadIdentity();  
	glTranslatef(0.0f,0.0f,-5.0);
	glDisable(GL_DEPTH_TEST);
	glEnable(GL_BLEND);

//	glColor3f(0.0f,4.0f,1.0f);		// Full Brightness, 50% Alpha ( NEW )
	//glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);

	if (style==0)
	{

		Vect3D color={0x2C * INV256, 0x39*INV256, 0x44*INV256};
		RECTANGLE_fill_around(zooma, color);

		glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
		glColor4f(1.0f,1.0f,1.0f,alpha);
	}
	else
	{
		glColor3f(alpha,alpha,alpha);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
	}


		glBegin(GL_QUADS);

		  glTexCoord2f(0.0, 1.0);  glVertex3f(OGL_MINX*zooma, OGL_MAXY*zooma,  -0.0f);	// Bottom Left Of The Texture and Quad
		  glTexCoord2f(1.0, 1.0);  glVertex3f(OGL_MAXX*zooma,  OGL_MAXY*zooma,  -0.0f);	// Bottom Right Of The Texture and Quad
		  glTexCoord2f(1.0, 0.0f);  glVertex3f(OGL_MAXX*zooma, OGL_MINY*zooma,  -0.0f);	// Top Right Of The Texture and Quad
		  glTexCoord2f(0.0f, 0.0f); glVertex3f(OGL_MINX*zooma, OGL_MINY*zooma,  -0.0f);	// Top Left Of The Texture and Quad
	
        glEnd();


	glDisable(GL_BLEND);
	glEnable(GL_DEPTH_TEST);

}


void RECTANGLE_fill_around(GLfloat zoom, Vect3D color)
	{
		Vect3D p1,p2,p3,p4;


		p1.x=OGL_MINX*zoom;		p1.y=OGL_MAXY*zoom;
		p2.x=OGL_MAXX*zoom;		p2.y=OGL_MAXY*zoom;
		p3.x=OGL_MINX*zoom;		p3.y=OGL_MINY*zoom;
		p4.x=OGL_MAXX*zoom;		p1.y=OGL_MINY*zoom;
		
		glLoadIdentity();  
		glTranslatef(0.0f,0.0f,-5.0);
		glDisable(GL_DEPTH_TEST);
		glDisable(GL_TEXTURE_2D);
		glColor4f(color.x, color.y, color.z,1.0);		// Full Brightness, 50% Alpha ( NEW )
		
	
		glBegin(GL_QUADS);
		 glVertex3f(p1.x-6.0, p2.y,		0.0f);
		 glVertex3f(p1.x-6.0, p2.y+3.0,  0.0f);	
		 glVertex3f(p2.x+6.0, p2.y+3.0,  0.0f);
		 glVertex3f(p2.x+6.0, p2.y,		0.0f);	

		 glVertex3f(p1.x-6.0, p3.y,		0.0f);
		 glVertex3f(p1.x-6.0, p3.y-3.0,  0.0f);	
		 glVertex3f(p2.x+6.0, p3.y-3.0,  0.0f);
		 glVertex3f(p2.x+6.0, p3.y,		0.0f);	
    
	

		 glVertex3f(p1.x-6.0, p1.y+6.0,		0.0f);
		 glVertex3f(p1.x-6.0, p3.y,  0.0f);	
		 glVertex3f(p1.x, p3.y,  0.0f);
		 glVertex3f(p1.x, p1.y+6.0,		0.0f);	

		 glVertex3f(p2.x+6.0, p1.y+6.0,		0.0f);
		 glVertex3f(p2.x+6.0, p3.y,  0.0f);	
		 glVertex3f(p2.x, p3.y,  0.0f);
		 glVertex3f(p2.x, p1.y+6.0,		0.0f);	
        glEnd();


		glEnable(GL_TEXTURE_2D);
		glEnable(GL_DEPTH_TEST);
}


