/* 256x256x32bits TEXTURE GENERATOR
 * generation routines - optimized for size
 * code by dake/calodox - July 99
 */

#define uchar unsigned char 
#include <math.h>
 #include "nmldec.h"
 #include "savehead.h"

 /* PLASMA - NOISE - FILLED COLOR */

/**************************************************************************/
 void NML_GENPLASMA(uchar *framebuf, int off_x, int off_y,
                    int freq_x, int freq_y, int plasm_r,
                    int plasm_g, int plasm_b, int plasm_a,
                    int plasm_blend)
      {
      int x, y;

        for (y=0;y<256;y++)
            {
            for (x=0;x<256;x++)
                {
                int spx,spxr,spxg,spxb;
                int tempr,tempg,tempb, tt;

                spx=30+sin((x+off_x)*3.14*freq_x/128.0)*30.0;
                spx+=30+sin((y+off_y)*3.14*freq_y/128.0)*30.0;
                spx*=(plasm_a);
                spx>>=6;

                if (spx<0) spx=0;
                if (spx>255) spx=255;

                spxr=(spx*plasm_r)>>8;
                spxg=(spx*plasm_g)>>8;
                spxb=(spx*plasm_b)>>8;

                tt=(x+(y<<8))<<2;
                tempb=framebuf[tt];
                tempg=framebuf[tt+1];
                tempr=framebuf[tt+2];

                if (plasm_blend==1)     //saturation ADD
                   {
                   tempr+=spxr; if (tempr>255) tempr=255;
                   tempg+=spxg; if (tempg>255) tempg=255;
                   tempb+=spxb; if (tempb>255) tempb=255;
                   }

                if (plasm_blend==2)     //saturation SUB
                   {
                   tempr-=spxr; if (tempr<0) tempr=0;
                   tempg-=spxg; if (tempg<0) tempg=0;
                   tempb-=spxb; if (tempb<0) tempb=0;
                   }

                if (plasm_blend==3)
                   {
                   tempr=spxr;
                   tempg=spxg;
                   tempb=spxb;
                   }

                framebuf[(x+(y<<8))<<2]=tempb;
                framebuf[((x+(y<<8))<<2)+1]=tempg;
                framebuf[((x+(y<<8))<<2)+2]=tempr;

                }
           }
      }
/**************************************************************************/

unsigned long NMLRND_seed;
     
unsigned long NMLRND_find(unsigned long NMLRND_limit) 
    {
    if (NMLRND_limit==0) {NMLRND_limit++;}
    NMLRND_seed=(NMLRND_seed*31421)+6927;
    return((NMLRND_seed%NMLRND_limit));
    }
//===============================================

void NML_GENNOISE(uchar *framebuf, int noise_amount, int type_noise)
     {
     int n;

      for (n=0;n<256*256;n++)
          {
          int rdpix=NMLRND_find(noise_amount);
          int tempr, tempg, tempb;
          int noptr=n<<2;

          tempb=framebuf[noptr];
          tempg=framebuf[noptr+1];
          tempr=framebuf[noptr+2];

          if (type_noise==0)      //saturation ADD
             {
             tempr+=rdpix; if (tempr>255) tempr=255;
             tempg+=rdpix; if (tempg>255) tempg=255;
             tempb+=rdpix; if (tempb>255) tempb=255;
             }

          if (type_noise==1)      //saturation ADD
             {
             tempr-=rdpix; if (tempr<0) tempr=0;
             tempg-=rdpix; if (tempg<0) tempg=0;
             tempb-=rdpix; if (tempb<0) tempb=0;
             }

          if (type_noise==2)
             {
             tempr=tempg=tempb=rdpix;
             }

          framebuf[noptr]=tempb;
          framebuf[noptr+1]=tempg;
          framebuf[noptr+2]=tempr;
          }
      }


void NML_GENCOLOR(uchar *framebuf, int br, int bg, int bb)
     {
     int n;

     for (n=0;n<256*256;n++)
         {
         framebuf[(n<<2)]=bb;
         framebuf[(n<<2)+1]=bg;
         framebuf[(n<<2)+2]=br;
         }
     }

